/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.core.text.AbstractEditingModel;
import org.eclipse.pde.internal.core.text.IDocumentNode;
import org.eclipse.pde.internal.core.text.IDocumentRange;
import org.eclipse.pde.internal.core.text.IEditingModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormEditorContributor;
import org.eclipse.pde.internal.ui.editor.PDEFormTextEditorContributor;
import org.eclipse.pde.internal.ui.editor.SourceOutlinePage;
import org.eclipse.pde.internal.ui.editor.actions.FormatAction;
import org.eclipse.pde.internal.ui.editor.actions.HyperlinkAction;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.outline.IOutlineContentCreator;
import org.eclipse.pde.internal.ui.editor.outline.IOutlineSelectionHandler;
import org.eclipse.pde.internal.ui.editor.plugin.ExtensionHyperLink;
import org.eclipse.pde.internal.ui.editor.text.PDESelectAnnotationRulerAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;

public abstract class PDESourcePage
extends TextEditor
implements IFormPage,
IGotoMarker,
ISelectionChangedListener,
IOutlineContentCreator,
IOutlineSelectionHandler {
    private static String RES_BUNDLE_LOCATION = "org.eclipse.pde.internal.ui.editor.text.ConstructedPDEEditorMessages";
    private static ResourceBundle fgBundleForConstructedKeys = ResourceBundle.getBundle(RES_BUNDLE_LOCATION);
    private PDESourcePageChangedListener fEditorSelectionChangedListener;
    private PDEFormEditor fEditor;
    private Control fControl;
    private int fIndex;
    private String fId;
    private InputContext fInputContext;
    private ISortableContentOutlinePage fOutlinePage;
    private ISelectionChangedListener fOutlineSelectionChangedListener;
    protected Object fSelection;

    public static ResourceBundle getBundleForConstructedKeys() {
        return fgBundleForConstructedKeys;
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.pde.ui.pdeEditorContext"});
    }

    public PDESourcePage(PDEFormEditor editor, String id, String title) {
        this.fId = id;
        this.initialize(editor);
        IPreferenceStore[] stores = new IPreferenceStore[]{PDEPlugin.getDefault().getPreferenceStore(), EditorsUI.getPreferenceStore()};
        this.setPreferenceStore((IPreferenceStore)new ChainedPreferenceStore(stores));
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        if (this.isSelectionListener()) {
            this.getEditor().getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    public void initialize(FormEditor editor) {
        this.fEditor = (PDEFormEditor)editor;
    }

    public void dispose() {
        if (this.fEditorSelectionChangedListener != null) {
            this.fEditorSelectionChangedListener.uninstall(this.getSelectionProvider());
            this.fEditorSelectionChangedListener = null;
        }
        if (this.fOutlinePage != null) {
            this.fOutlinePage.dispose();
            this.fOutlinePage = null;
        }
        if (this.isSelectionListener()) {
            this.getEditor().getSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        super.dispose();
    }

    public abstract ILabelProvider createOutlineLabelProvider();

    public abstract ITreeContentProvider createOutlineContentProvider();

    public abstract ViewerComparator createOutlineComparator();

    public void updateSelection(SelectionChangedEvent event) {
        ISelection sel = event.getSelection();
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)sel;
            this.updateSelection(structuredSelection.getFirstElement());
        }
    }

    public abstract void updateSelection(Object var1);

    public ViewerComparator createDefaultOutlineComparator() {
        return null;
    }

    protected ISortableContentOutlinePage createOutlinePage() {
        SourceOutlinePage sourceOutlinePage = new SourceOutlinePage((IEditingModel)this.getInputContext().getModel(), (IBaseLabelProvider)this.createOutlineLabelProvider(), (IContentProvider)this.createOutlineContentProvider(), this.createDefaultOutlineComparator(), this.createOutlineComparator());
        this.fOutlinePage = sourceOutlinePage;
        this.fOutlineSelectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PDESourcePage.this.updateSelection(event);
            }
        };
        this.fOutlinePage.addSelectionChangedListener(this.fOutlineSelectionChangedListener);
        this.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)sourceOutlinePage);
        this.fEditorSelectionChangedListener = new PDESourcePageChangedListener();
        this.fEditorSelectionChangedListener.install(this.getSelectionProvider());
        return this.fOutlinePage;
    }

    public ISortableContentOutlinePage getContentOutline() {
        if (this.fOutlinePage == null) {
            this.fOutlinePage = this.createOutlinePage();
        }
        return this.fOutlinePage;
    }

    public FormEditor getEditor() {
        return this.fEditor;
    }

    public IManagedForm getManagedForm() {
        return null;
    }

    protected void firePropertyChange(int type) {
        if (type == 257) {
            this.fEditor.fireSaveNeeded(this.getEditorInput(), true);
        } else {
            super.firePropertyChange(type);
        }
    }

    public void setActive(boolean active) {
        this.fInputContext.setSourceEditingMode(active);
    }

    public boolean canLeaveThePage() {
        return true;
    }

    public boolean isActive() {
        return this.equals(this.fEditor.getActivePageInstance());
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        Control[] children = parent.getChildren();
        this.fControl = children[children.length - 1];
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.fControl, "org.eclipse.pde.doc.user.manifest_source_page");
    }

    public Control getPartControl() {
        return this.fControl;
    }

    public String getId() {
        return this.fId;
    }

    public int getIndex() {
        return this.fIndex;
    }

    public void setIndex(int index) {
        this.fIndex = index;
    }

    public boolean isEditor() {
        return true;
    }

    public InputContext getInputContext() {
        return this.fInputContext;
    }

    public void setInputContext(InputContext inputContext) {
        this.fInputContext = inputContext;
        this.setDocumentProvider(inputContext.getDocumentProvider());
    }

    public boolean selectReveal(Object object) {
        if (object instanceof IMarker) {
            IDE.gotoMarker((IEditorPart)this, (IMarker)((IMarker)object));
            return true;
        }
        return false;
    }

    public IDocumentRange getRangeElement(int offset, boolean searchChildren) {
        return null;
    }

    public void setHighlightRange(IDocumentRange range, boolean moveCursor) {
        int offset = range.getOffset();
        if (offset == -1) {
            this.resetHighlightRange();
            return;
        }
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return;
        }
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        int length = range.getLength();
        this.setHighlightRange(offset, length == -1 ? 1 : length, moveCursor);
    }

    public void setSelectedRange(IDocumentRange range, boolean fullNodeSelection) {
        int offset;
        int length;
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return;
        }
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        if (range instanceof IDocumentNode && !fullNodeSelection) {
            length = ((IDocumentNode)range).getXMLTagName().length();
            offset = range.getOffset() + 1;
        } else {
            length = range.getLength();
            offset = range.getOffset();
        }
        sourceViewer.setSelectedRange(offset, length);
    }

    public int getOrientation() {
        return 0x2000000;
    }

    protected void createActions() {
        PDEFormEditorContributor contributor;
        super.createActions();
        PDESelectAnnotationRulerAction action = new PDESelectAnnotationRulerAction(PDESourcePage.getBundleForConstructedKeys(), "PDESelectAnnotationRulerAction.", (ITextEditor)this, (IVerticalRulerInfo)this.getVerticalRuler());
        this.setAction("RulerClick", (IAction)action);
        PDEFormEditorContributor pDEFormEditorContributor = contributor = this.fEditor == null ? null : this.fEditor.getContributor();
        if (contributor instanceof PDEFormTextEditorContributor) {
            PDEFormTextEditorContributor textContributor = (PDEFormTextEditorContributor)contributor;
            this.setAction("org.eclipse.pde.ui.actions.Open", (IAction)textContributor.getHyperlinkAction());
            this.setAction("org.eclipse.pde.ui.actions.Format", (IAction)textContributor.getFormatAction());
            if (textContributor.supportsContentAssist()) {
                this.createContentAssistAction();
            }
        }
        this.createQuickOutlineAction();
    }

    private void createQuickOutlineAction() {
        TextOperationAction action = new TextOperationAction(PDESourcePage.getBundleForConstructedKeys(), "QuickOutline.", (ITextEditor)this, 513, true);
        action.setActionDefinitionId("org.eclipse.pde.ui.quickOutline");
        action.setText(PDEUIMessages.PDESourcePage_actionTextQuickOutline);
        action.setId("org.eclipse.pde.ui.quickOutline");
        action.setImageDescriptor(PDEPluginImages.DESC_OVERVIEW_OBJ);
        this.setAction("org.eclipse.pde.ui.quickOutline", (IAction)action);
    }

    private void createContentAssistAction() {
        ContentAssistAction contentAssist = new ContentAssistAction(PDESourcePage.getBundleForConstructedKeys(), "ContentAssistProposal.", (ITextEditor)this);
        contentAssist.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssist", (IAction)contentAssist);
        this.markAsStateDependentAction("ContentAssist", true);
    }

    public final void selectionChanged(SelectionChangedEvent event) {
        if (event.getSource() == this.getSelectionProvider()) {
            return;
        }
        ISelection sel = event.getSelection();
        if (sel instanceof ITextSelection) {
            return;
        }
        this.fSelection = sel instanceof IStructuredSelection ? ((IStructuredSelection)sel).getFirstElement() : null;
    }

    protected IDocumentRange findRange() {
        return null;
    }

    public void updateTextSelection() {
        IDocumentRange range = this.findRange();
        if (range == null) {
            return;
        }
        IBaseModel model = this.getInputContext().getModel();
        if (!(model instanceof AbstractEditingModel)) {
            return;
        }
        if (range.getOffset() == -1 || this.isDirty()) {
            try {
                ((AbstractEditingModel)model).adjustOffsets(((AbstractEditingModel)model).getDocument());
            }
            catch (CoreException coreException) {}
            range = this.findRange();
        }
        this.setHighlightRange(range, true);
        this.setSelectedRange(range, false);
    }

    protected boolean isSelectionListener() {
        return false;
    }

    public ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        PDEFormEditorContributor contributor;
        PDEFormEditorContributor pDEFormEditorContributor = contributor = this.fEditor == null ? null : this.fEditor.getContributor();
        if (contributor instanceof PDEFormTextEditorContributor) {
            FormatAction formatManifestAction;
            PDEFormTextEditorContributor textContributor = (PDEFormTextEditorContributor)contributor;
            HyperlinkAction action = textContributor.getHyperlinkAction();
            if (action != null && action.isEnabled() && !(action.getHyperLink() instanceof ExtensionHyperLink)) {
                menu.add((IAction)action);
            }
            if ((formatManifestAction = textContributor.getFormatAction()) != null && formatManifestAction.isEnabled()) {
                menu.add((IAction)formatManifestAction);
            }
        }
        super.editorContextMenuAboutToShow(menu);
    }

    public Object getSelection() {
        return this.fSelection;
    }

    public Object getOutlineInput() {
        return this.getInputContext().getModel();
    }

    protected void updateOutlinePageSelection(Object rangeElement) {
        if (PDEPlugin.getDefault().getPreferenceStore().getBoolean("ToggleLinkWithEditorAction.isChecked")) {
            if (!(this.fOutlinePage instanceof SourceOutlinePage)) {
                return;
            }
            SourceOutlinePage outlinePage = (SourceOutlinePage)this.fOutlinePage;
            outlinePage.removeAllSelectionChangedListeners();
            if (rangeElement != null) {
                outlinePage.setSelection((ISelection)new StructuredSelection(rangeElement));
            } else {
                outlinePage.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            outlinePage.addAllSelectionChangedListeners();
        }
    }

    protected void handleSelectionChangedSourcePage(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (!selection.isEmpty() && selection instanceof ITextSelection) {
            this.synchronizeOutlinePage(((ITextSelection)selection).getOffset());
        }
    }

    protected void updateHighlightRange(IDocumentRange rangeElement) {
        if (rangeElement != null) {
            this.setHighlightRange(rangeElement, false);
        } else {
            this.resetHighlightRange();
        }
    }

    protected void synchronizeOutlinePage(int offset) {
        IDocumentRange rangeElement = this.getRangeElement(offset, false);
        this.updateHighlightRange(rangeElement);
        this.updateOutlinePageSelection(rangeElement);
    }

    public void synchronizeOutlinePage() {
        int current_offset = this.getSourceViewer().getSelectedRange().x;
        this.synchronizeOutlinePage(current_offset);
    }

    private class PDESourcePageChangedListener
    implements ISelectionChangedListener {
        private PDESourcePageChangedListener() {
        }

        public void install(ISelectionProvider selectionProvider) {
            if (selectionProvider != null) {
                if (selectionProvider instanceof IPostSelectionProvider) {
                    IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                    provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
                } else {
                    selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
                }
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            PDESourcePage.this.handleSelectionChangedSourcePage(event);
        }

        public void uninstall(ISelectionProvider selectionProvider) {
            if (selectionProvider != null) {
                if (selectionProvider instanceof IPostSelectionProvider) {
                    IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                    provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
                } else {
                    selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
                }
            }
        }
    }
}

