/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.actions;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.internal.core.PDEStateHelper;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.schema.SchemaDescriptor;
import org.eclipse.pde.internal.core.schema.SchemaRegistry;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.schema.SchemaEditor;
import org.eclipse.swt.widgets.Shell;

public class OpenSchemaAction
extends Action {
    private ISchema fSchema = null;
    private String fFullPointID = null;

    public OpenSchemaAction() {
        this.initialize();
    }

    private void initialize() {
        this.setImageDescriptor(PDEPluginImages.DESC_SCHEMA_OBJ);
        this.setText(PDEUIMessages.HyperlinkActionOpenSchema);
        this.setToolTipText(PDEUIMessages.HyperlinkActionOpenSchema);
        this.setEnabled(false);
    }

    public void setInput(ISchema schema) {
        if (schema == null) {
            this.fFullPointID = PDEUIMessages.OpenSchemaAction_msgUnknown;
            return;
        }
        this.fFullPointID = schema.getQualifiedPointId();
        this.fSchema = schema;
    }

    public void setInput(IPluginExtensionPoint point) {
        if (point == null) {
            this.fSchema = null;
            this.fFullPointID = PDEUIMessages.OpenSchemaAction_msgUnknown;
            return;
        }
        this.fFullPointID = point.getFullId();
        if (this.fFullPointID.indexOf(46) == -1) {
            this.fSchema = null;
            return;
        }
        this.fSchema = this.findSchema(point);
    }

    public void setInput(String fullPointID) {
        if (fullPointID == null) {
            this.fSchema = null;
            this.fFullPointID = PDEUIMessages.OpenSchemaAction_msgUnknown;
            return;
        }
        this.fFullPointID = fullPointID;
        IPluginExtensionPoint point = PDEStateHelper.findExtensionPoint((String)this.fFullPointID);
        if (point == null) {
            this.fSchema = null;
            return;
        }
        this.fSchema = this.findSchema(point);
    }

    public void setInput(IPluginExtension extension) {
        if (extension == null) {
            this.fSchema = null;
            this.fFullPointID = PDEUIMessages.OpenSchemaAction_msgUnknown;
            return;
        }
        this.fFullPointID = extension.getPoint();
        IPluginExtensionPoint point = PDEStateHelper.findExtensionPoint((String)this.fFullPointID);
        if (point == null) {
            this.fSchema = null;
            return;
        }
        this.fSchema = this.findSchema(point);
    }

    private ISchema findSchema(IPluginExtensionPoint point) {
        URL url = SchemaRegistry.getSchemaURL((IPluginExtensionPoint)point);
        if (url == null) {
            return null;
        }
        SchemaDescriptor descriptor = new SchemaDescriptor(this.fFullPointID, url);
        ISchema schema = descriptor.getSchema(false);
        if (schema == null) {
            return null;
        }
        return schema;
    }

    private void displayErrorDialog() {
        String title = PDEUIMessages.OpenSchemaAction_titleExtensionPointSchema;
        String message = NLS.bind((String)PDEUIMessages.OpenSchemaAction_errorMsgSchemaNotFound, (Object)this.fFullPointID);
        MessageDialog.openWarning((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)title, (String)message);
    }

    public void run() {
        if (this.fSchema == null) {
            this.displayErrorDialog();
            return;
        }
        URL schemaURL = this.fSchema.getURL();
        if (schemaURL == null) {
            this.displayErrorDialog();
            return;
        }
        String rawURL = schemaURL.toString();
        if (rawURL.startsWith("jar")) {
            this.openSchemaJar(schemaURL.getPath());
        } else {
            this.openSchemaFile(schemaURL.getPath());
        }
    }

    private void openSchemaFile(String path) {
        try {
            String relativeLocation;
            IResource res;
            IWorkspaceRoot root = PDEPlugin.getWorkspace().getRoot();
            IPath workspacePath = root.getLocation();
            String workspaceLoc = workspacePath.toFile().toURL().getPath();
            if (path.startsWith(workspaceLoc) && (res = root.findMember(relativeLocation = path.substring(workspaceLoc.length()))) != null && res instanceof IFile && res.getProject().isOpen()) {
                SchemaEditor.openSchema((IFile)res);
                return;
            }
        }
        catch (MalformedURLException malformedURLException) {}
        SchemaEditor.openSchema(new File(path));
    }

    private void openSchemaJar(String path) {
        if (!path.startsWith("file:")) {
            this.displayErrorDialog();
            return;
        }
        int exclPointIndex = (path = path.substring(5)).indexOf(33);
        if (exclPointIndex <= 0 || exclPointIndex + 1 >= path.length()) {
            this.displayErrorDialog();
            return;
        }
        String jarFileName = path.substring(0, exclPointIndex);
        String schemaEntryName = path.substring(exclPointIndex + 1);
        if (schemaEntryName.startsWith("/")) {
            schemaEntryName = schemaEntryName.substring(1);
        }
        SchemaEditor.openSchema(new File(jarFileName), schemaEntryName);
    }
}

