/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.build;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.pde.internal.core.text.IDocumentRange;
import org.eclipse.pde.internal.core.text.IEditingModel;
import org.eclipse.pde.internal.core.text.build.BuildEntry;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.text.ResourceHyperlink;

public class BuildHyperlinkDetector
implements IHyperlinkDetector {
    private PDESourcePage fSourcePage;

    public BuildHyperlinkDetector(PDESourcePage page) {
        this.fSourcePage = page;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (region == null || canShowMultipleHyperlinks) {
            return null;
        }
        IDocumentRange element = this.fSourcePage.getRangeElement(region.getOffset(), true);
        if (!(element instanceof BuildEntry)) {
            return null;
        }
        BuildEntry entry = (BuildEntry)element;
        if (!entry.getModel().isEditable() || !(entry.getModel() instanceof IEditingModel)) {
            return null;
        }
        String name = entry.getName();
        if (!(name.equals("bin.includes") || name.equals("src.includes") || name.startsWith("source."))) {
            return null;
        }
        if (region.getOffset() <= entry.getOffset() + entry.getName().length()) {
            return null;
        }
        return this.matchLinkFor(entry, region.getOffset());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IHyperlink[] matchLinkFor(BuildEntry header, int mainOffset) {
        try {
            String match;
            IDocument doc = ((IEditingModel)header.getModel()).getDocument();
            String value = doc.get(header.getOffset(), header.getLength());
            int offset = mainOffset - header.getOffset();
            if (this.skipChar(value.charAt(offset))) {
                return null;
            }
            String pre = value.substring(0, offset);
            char[] preChars = pre.toCharArray();
            int start = pre.lastIndexOf(44);
            if (start == -1 && (start = value.indexOf(61)) == 0) {
                return null;
            }
            while (++start < preChars.length && this.skipChar(preChars[start])) {
            }
            String post = value.substring(offset);
            char[] postChars = post.toCharArray();
            int end = post.indexOf(44);
            if (end == -1) {
                end = post.length();
            }
            while (--end < postChars.length && this.skipChar(postChars[end])) {
            }
            if ((match = value.substring(start, preChars.length + ++end)).length() == 0 || match.indexOf(42) != -1) {
                return null;
            }
            IResource res = header.getModel().getUnderlyingResource();
            if (res == null) {
                return null;
            }
            res = res.getProject().findMember(match);
            return new IHyperlink[]{new ResourceHyperlink((IRegion)new Region(header.getOffset() + start, match.length()), match, res)};
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private boolean skipChar(char c) {
        return Character.isWhitespace(c) || c == '\\' || c == ',';
    }
}

