/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.cheatsheet;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEDetails;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.cheatsheet.ICSDetails;
import org.eclipse.pde.internal.ui.editor.cheatsheet.ICSMaster;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class CSAbstractDetails
extends PDEDetails
implements ICSDetails {
    private ICSMaster fMasterSection;
    private String fContextID;

    public CSAbstractDetails(ICSMaster masterSection, String contextID) {
        this.fMasterSection = masterSection;
        this.fContextID = contextID;
    }

    public void createContents(Composite parent) {
        this.configureParentLayout(parent);
        this.createDetails(parent);
        this.hookListeners();
    }

    private void configureParentLayout(Composite parent) {
        parent.setLayout((Layout)FormLayoutFactory.createDetailsGridLayout(false, 1));
    }

    public abstract void createDetails(Composite var1);

    public abstract void updateFields();

    public abstract void hookListeners();

    public void selectionChanged(IFormPart part, ISelection selection) {
    }

    public void fireSaveNeeded() {
        this.markDirty();
        this.getPage().getPDEEditor().fireSaveNeeded(this.getContextId(), false);
    }

    public String getContextId() {
        return this.fContextID;
    }

    public PDEFormPage getPage() {
        return (PDEFormPage)((Object)this.getManagedForm().getContainer());
    }

    public boolean isEditable() {
        return this.fMasterSection.isEditable();
    }

    public void modelChanged(IModelChangedEvent event) {
    }

    public boolean isEditableElement() {
        return this.fMasterSection.isEditable();
    }

    public FormToolkit getToolkit() {
        return this.getManagedForm().getToolkit();
    }

    public ICSMaster getMasterSection() {
        return this.fMasterSection;
    }

    protected Object getFirstSelectedObject(ISelection selection) {
        IStructuredSelection structuredSel = (IStructuredSelection)selection;
        if (structuredSel == null) {
            return null;
        }
        return structuredSel.getFirstElement();
    }
}

