/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.cheatsheet;

import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.cheatsheet.RegisterCSWizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public abstract class CSAbstractPage
extends PDEFormPage {
    private ImageHyperlink fImageHyperlinkRegisterCS;
    private FormToolkit fToolkit;
    private IModel fModel;

    public CSAbstractPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected void createUIFormTitleRegisterCSLink(IManagedForm managedForm, IModel model) {
        this.fToolkit = managedForm.getToolkit();
        this.fModel = model;
        ScrolledForm form = managedForm.getForm();
        if (this.fModel.isEditable()) {
            form.getToolBarManager().add((IContributionItem)this.createUIControlConRegisterCS());
            form.getToolBarManager().update(true);
        }
    }

    private ControlContribution createUIControlConRegisterCS() {
        return new ControlContribution("Register"){

            protected Control createControl(Composite parent) {
                CSAbstractPage.this.createUIImageHyperlinkRegisterCS(parent);
                CSAbstractPage.this.createUIListenerImageHyperlinkRegisterCS();
                return CSAbstractPage.this.fImageHyperlinkRegisterCS;
            }
        };
    }

    private void createUIImageHyperlinkRegisterCS(Composite parent) {
        this.fImageHyperlinkRegisterCS = new ImageHyperlink(parent, 0);
        this.fImageHyperlinkRegisterCS.setText(PDEUIMessages.CSAbstractPage_msgRegisterThisCheatSheet);
        this.fImageHyperlinkRegisterCS.setUnderlined(true);
        this.fImageHyperlinkRegisterCS.setForeground(this.fToolkit.getHyperlinkGroup().getForeground());
    }

    private void createUIListenerImageHyperlinkRegisterCS() {
        this.fImageHyperlinkRegisterCS.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                CSAbstractPage.this.handleLinkActivatedRegisterCS();
            }

            public void linkEntered(HyperlinkEvent e) {
                CSAbstractPage.this.handleLinkEnteredRegisterCS(e.getLabel());
            }

            public void linkExited(HyperlinkEvent e) {
                CSAbstractPage.this.handleLinkExitedRegisterCS();
            }
        });
    }

    private void handleLinkEnteredRegisterCS(String message) {
        this.fImageHyperlinkRegisterCS.setForeground(this.fToolkit.getHyperlinkGroup().getActiveForeground());
        this.getEditor().getEditorSite().getActionBars().getStatusLineManager().setMessage(message);
    }

    private void handleLinkExitedRegisterCS() {
        this.fImageHyperlinkRegisterCS.setForeground(this.fToolkit.getHyperlinkGroup().getForeground());
        this.getEditor().getEditorSite().getActionBars().getStatusLineManager().setMessage(null);
    }

    private void handleLinkActivatedRegisterCS() {
        RegisterCSWizard wizard = new RegisterCSWizard(this.fModel);
        wizard.init(PlatformUI.getWorkbench(), null);
        WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
        dialog.create();
        SWTUtil.setDialogSize((Dialog)dialog, 400, 300);
        dialog.open();
    }
}

