/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.cheatsheet.comp;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.internal.core.util.SAXParserWrapper;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CompCSFileValidator
implements ISelectionStatusValidator {
    public IStatus validate(Object[] selection) {
        if (selection.length == 0) {
            return this.errorStatus("");
        }
        if (!(selection[0] instanceof IFile)) {
            return this.errorStatus("");
        }
        IFile file = (IFile)selection[0];
        if (!this.isSimpleCSFile(file)) {
            return this.errorStatus(PDEUIMessages.CompCSFileValidator_errorInvalidSimpleCS);
        }
        return this.okStatus("");
    }

    private boolean isSimpleCSFile(IFile file) {
        SimpleCSContentTypeHandler handler = new SimpleCSContentTypeHandler();
        try {
            SAXParserWrapper parser = new SAXParserWrapper();
            parser.parse((InputStream)new BufferedInputStream(file.getContents()), (DefaultHandler)handler);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return false;
        }
        catch (AbortParseException abortParseException) {
            return handler.isSimpleCS();
        }
        catch (SAXException sAXException) {
            return false;
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        catch (CoreException coreException) {
            return false;
        }
        return handler.isSimpleCS();
    }

    private IStatus errorStatus(String message) {
        return new Status(4, PDEPlugin.getPluginId(), 4, message, null);
    }

    private IStatus okStatus(String message) {
        return new Status(0, PDEPlugin.getPluginId(), 0, message, null);
    }

    private static class AbortParseException
    extends SAXException {
        private static final long serialVersionUID = 1L;

        public AbortParseException() {
            super("Parsing operation forcibly aborted to save on performance time.");
        }
    }

    private static class SimpleCSContentTypeHandler
    extends DefaultHandler {
        private boolean fIsSimpleCS = false;

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("cheatsheet")) {
                this.fIsSimpleCS = true;
            }
            throw new AbortParseException();
        }

        public boolean isSimpleCS() {
            return this.fIsSimpleCS;
        }
    }
}

