/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.cheatsheet.comp.details;

import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.pde.internal.core.icheatsheet.comp.ICompCSIntro;
import org.eclipse.pde.internal.core.icheatsheet.comp.ICompCSModelFactory;
import org.eclipse.pde.internal.core.icheatsheet.comp.ICompCSObject;
import org.eclipse.pde.internal.core.icheatsheet.comp.ICompCSTaskObject;
import org.eclipse.pde.internal.core.util.PDETextHelper;

public class CompCSIntroductionTextListener
implements IDocumentListener {
    private ICompCSTaskObject fDataTaskObject = null;
    private boolean fBlockEvents = false;

    public void setBlockEvents(boolean block) {
        this.fBlockEvents = block;
    }

    public boolean getBlockEvents() {
        return this.fBlockEvents;
    }

    public void setData(ICompCSTaskObject object) {
        this.fDataTaskObject = object;
    }

    public void documentAboutToBeChanged(DocumentEvent e) {
    }

    public void documentChanged(DocumentEvent event) {
        if (this.fBlockEvents) {
            return;
        }
        if (this.fDataTaskObject == null) {
            return;
        }
        IDocument document = event.getDocument();
        if (document == null) {
            return;
        }
        String text = document.get().trim();
        boolean hasText = PDETextHelper.isDefined((String)text);
        if (hasText) {
            this.updateIntroductionText(text);
        } else {
            this.removeIntroductionText(text);
        }
    }

    private void updateIntroductionText(String text) {
        if (this.fDataTaskObject.getFieldIntro() == null) {
            this.addIntroductionText(text);
        } else {
            this.modifyIntroductionText(text);
        }
    }

    private void addIntroductionText(String text) {
        ICompCSModelFactory factory = this.fDataTaskObject.getModel().getFactory();
        ICompCSIntro intro = factory.createCompCSIntro((ICompCSObject)this.fDataTaskObject);
        intro.setFieldContent(text);
        this.fDataTaskObject.setFieldIntro(intro);
    }

    private void modifyIntroductionText(String text) {
        ICompCSIntro intro = this.fDataTaskObject.getFieldIntro();
        intro.setFieldContent(text);
    }

    private void removeIntroductionText(String text) {
        ICompCSIntro intro = this.fDataTaskObject.getFieldIntro();
        if (intro != null) {
            this.fDataTaskObject.setFieldIntro(null);
        }
    }
}

