/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.cheatsheet.simple;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.cheatsheet.simple.SimpleCSModel;
import org.eclipse.pde.internal.core.cheatsheet.simple.SimpleCSWorkspaceModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.context.UTF8InputContext;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;

public class SimpleCSInputContext
extends UTF8InputContext {
    public static final String CONTEXT_ID = "simplecs-context";

    public SimpleCSInputContext(PDEFormEditor editor, IEditorInput input, boolean primary) {
        super(editor, input, primary);
        this.create();
    }

    protected void addTextEditOperation(ArrayList ops, IModelChangedEvent event) {
    }

    protected IBaseModel createModel(IEditorInput input) throws CoreException {
        SimpleCSWorkspaceModel model = null;
        if (input instanceof IStorageEditorInput) {
            try {
                if (input instanceof IFileEditorInput) {
                    IFile file = ((IFileEditorInput)input).getFile();
                    model = new SimpleCSWorkspaceModel(file, true);
                    model.load();
                } else if (input instanceof IStorageEditorInput) {
                    BufferedInputStream is = new BufferedInputStream(((IStorageEditorInput)input).getStorage().getContents());
                    model = new SimpleCSModel();
                    model.load((InputStream)is, false);
                }
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
                return null;
            }
        }
        return model;
    }

    public String getId() {
        return CONTEXT_ID;
    }

    protected String getPartitionName() {
        return "___simplecs_partition";
    }

    protected void flushModel(IDocument doc) {
        if (!(this.getModel() instanceof IEditable)) {
            return;
        }
        IEditable editableModel = (IEditable)this.getModel();
        if (!editableModel.isDirty()) {
            return;
        }
        try {
            StringWriter swriter = new StringWriter();
            PrintWriter writer = new PrintWriter(swriter);
            editableModel.save(writer);
            writer.flush();
            swriter.close();
            doc.set(swriter.toString());
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
        }
    }
}

