/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.io.File;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.core.build.IBuildObject;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.pde.internal.ui.editor.MultiSourceEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.SystemFileEditorInput;
import org.eclipse.pde.internal.ui.editor.build.BuildInputContext;
import org.eclipse.pde.internal.ui.editor.build.BuildPage;
import org.eclipse.pde.internal.ui.editor.build.BuildSourcePage;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.feature.FeatureAdvancedPage;
import org.eclipse.pde.internal.ui.editor.feature.FeatureDependenciesPage;
import org.eclipse.pde.internal.ui.editor.feature.FeatureFormPage;
import org.eclipse.pde.internal.ui.editor.feature.FeatureIncludesPage;
import org.eclipse.pde.internal.ui.editor.feature.FeatureInputContext;
import org.eclipse.pde.internal.ui.editor.feature.FeatureInputContextManager;
import org.eclipse.pde.internal.ui.editor.feature.FeatureOutlinePage;
import org.eclipse.pde.internal.ui.editor.feature.FeatureReferencePage;
import org.eclipse.pde.internal.ui.editor.feature.FeatureSourcePage;
import org.eclipse.pde.internal.ui.editor.feature.FeatureUndoManager;
import org.eclipse.pde.internal.ui.editor.feature.InfoFormPage;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IShowEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class FeatureEditor
extends MultiSourceEditor
implements IShowEditorInput {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected String getEditorID() {
        return "org.eclipse.pde.ui.featureEditor";
    }

    public static void openFeatureEditor(IFeature feature) {
        if (feature != null) {
            IFeatureModel model = feature.getModel();
            FeatureEditor.openFeatureEditor(model);
        } else {
            Display.getCurrent().beep();
        }
    }

    public static void openFeatureEditor(IFeatureModel model) {
        if (model != null) {
            IResource resource = model.getUnderlyingResource();
            try {
                Object input = null;
                input = resource != null ? new FileEditorInput((IFile)resource) : new SystemFileEditorInput(new File(model.getInstallLocation(), "feature.xml"));
                IDE.openEditor((IWorkbenchPage)PDEPlugin.getActivePage(), (IEditorInput)input, (String)"org.eclipse.pde.ui.featureEditor", (boolean)true);
            }
            catch (PartInitException partInitException) {}
        } else {
            Display.getCurrent().beep();
        }
    }

    protected void createResourceContexts(InputContextManager manager, IFileEditorInput input) {
        FileEditorInput in;
        IFile file = input.getFile();
        IProject project = file.getProject();
        IFile buildFile = null;
        IFile featureFile = null;
        String name = file.getName().toLowerCase(Locale.ENGLISH);
        if (name.equals("feature.xml")) {
            featureFile = file;
            buildFile = project.getFile("build.properties");
        } else if (name.equals("build.properties")) {
            buildFile = file;
            featureFile = this.createFeatureFile(project);
        }
        if (featureFile.exists()) {
            in = new FileEditorInput(featureFile);
            manager.putContext((IEditorInput)in, new FeatureInputContext(this, (IEditorInput)in, file == featureFile));
        }
        if (buildFile.exists()) {
            in = new FileEditorInput(buildFile);
            manager.putContext((IEditorInput)in, new BuildInputContext(this, (IEditorInput)in, file == buildFile));
        }
        manager.monitorFile(featureFile);
        manager.monitorFile(buildFile);
    }

    protected InputContextManager createInputContextManager() {
        FeatureInputContextManager manager = new FeatureInputContextManager(this);
        manager.setUndoManager(new FeatureUndoManager(this));
        return manager;
    }

    public void monitoredFileAdded(IFile file) {
        String name = file.getName();
        if (!name.equalsIgnoreCase("feature.xml") && name.equalsIgnoreCase("build.properties") && !this.fInputContextManager.hasContext("build-context")) {
            FileEditorInput in = new FileEditorInput(file);
            this.fInputContextManager.putContext((IEditorInput)in, new BuildInputContext(this, (IEditorInput)in, false));
        }
    }

    public boolean monitoredFileRemoved(IFile file) {
        return true;
    }

    public void editorContextAdded(InputContext context) {
        this.addSourcePage(context.getId());
    }

    public void contextRemoved(InputContext context) {
        if (context.isPrimary()) {
            this.close(true);
            return;
        }
        IFormPage page = this.findPage(context.getId());
        if (page != null) {
            this.removePage(context.getId());
        }
    }

    protected void createSystemFileContexts(InputContextManager manager, SystemFileEditorInput input) {
        SystemFileEditorInput in;
        File dir;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.io.File");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        File file = (File)input.getAdapter(clazz);
        File buildFile = null;
        File featureFile = null;
        String name = file.getName().toLowerCase(Locale.ENGLISH);
        if (name.equals("feature.xml")) {
            featureFile = file;
            dir = file.getParentFile();
            buildFile = new File(dir, "build.properties");
        } else if (name.equals("build.properties")) {
            buildFile = file;
            dir = file.getParentFile();
            featureFile = this.createFeatureFile(dir);
        }
        if (featureFile.exists()) {
            in = new SystemFileEditorInput(featureFile);
            manager.putContext((IEditorInput)in, new FeatureInputContext(this, (IEditorInput)in, file == featureFile));
        }
        if (buildFile.exists()) {
            in = new SystemFileEditorInput(buildFile);
            manager.putContext((IEditorInput)in, new BuildInputContext(this, (IEditorInput)in, file == buildFile));
        }
    }

    private File createFeatureFile(File dir) {
        File pluginFile = new File(dir, "plugin.xml");
        return pluginFile;
    }

    private IFile createFeatureFile(IProject project) {
        IFile featureFile = project.getFile("feature.xml");
        return featureFile;
    }

    protected void createStorageContexts(InputContextManager manager, IStorageEditorInput input) {
        String name = input.getName().toLowerCase(Locale.ENGLISH);
        if (name.equals("build.properties")) {
            manager.putContext((IEditorInput)input, new BuildInputContext(this, (IEditorInput)input, true));
        } else if (name.startsWith("feature.xml")) {
            manager.putContext((IEditorInput)input, new FeatureInputContext(this, (IEditorInput)input, true));
        }
    }

    protected void addEditorPages() {
        try {
            this.addPage((IFormPage)new FeatureFormPage(this, PDEUIMessages.FeatureEditor_FeaturePage_title));
            this.addPage((IFormPage)new InfoFormPage(this, PDEUIMessages.FeatureEditor_InfoPage_title));
            this.addPage((IFormPage)new FeatureReferencePage(this, PDEUIMessages.FeatureEditor_ReferencePage_title));
            this.addPage((IFormPage)new FeatureIncludesPage(this, PDEUIMessages.FeatureEditor_IncludesPage_title));
            this.addPage((IFormPage)new FeatureDependenciesPage(this, PDEUIMessages.FeatureEditor_DependenciesPage_title));
            this.addPage((IFormPage)new FeatureAdvancedPage(this, PDEUIMessages.FeatureEditor_AdvancedPage_title));
            if (this.fInputContextManager.hasContext("build-context")) {
                this.addPage((IFormPage)new BuildPage(this));
            }
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
        this.addSourcePage("feature-context");
        this.addSourcePage("build-context");
    }

    protected String computeInitialPageId() {
        String firstPageId = super.computeInitialPageId();
        if (firstPageId == null) {
            InputContext primary = this.fInputContextManager.getPrimaryContext();
            if (primary != null && "feature-context".equals(primary.getId())) {
                firstPageId = "feature";
            }
            if (firstPageId == null) {
                firstPageId = "feature";
            }
        }
        return firstPageId;
    }

    protected PDESourcePage createSourcePage(PDEFormEditor editor, String title, String name, String contextId) {
        if (contextId.equals("feature-context")) {
            return new FeatureSourcePage(editor, title, name);
        }
        if (contextId.equals("build-context")) {
            return new BuildSourcePage(editor, title, name);
        }
        return super.createSourcePage(editor, title, name, contextId);
    }

    protected ISortableContentOutlinePage createContentOutline() {
        return new FeatureOutlinePage(this);
    }

    protected IPropertySheetPage getPropertySheet(PDEFormPage page) {
        return null;
    }

    public String getTitle() {
        if (!this.isModelCorrect(this.getAggregateModel())) {
            return super.getTitle();
        }
        IFeatureModel model = (IFeatureModel)this.getAggregateModel();
        String name = this.getTitleText(model.getFeature());
        if (name == null) {
            return super.getTitle();
        }
        return model.getResourceString(name);
    }

    public String getTitleProperty() {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        String pref = store.getString("Preferences.MainPage.showObjects");
        if (pref != null && pref.equals("useNames")) {
            return "label";
        }
        return "id";
    }

    private String getTitleText(IFeature feature) {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        String pref = store.getString("Preferences.MainPage.showObjects");
        if (pref != null && pref.equals("useNames")) {
            return feature.getTranslatableLabel();
        }
        return feature.getId();
    }

    protected boolean isModelCorrect(Object model) {
        return model != null ? ((IFeatureModel)model).isValid() : false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasKnownTypes() {
        try {
            TransferData[] types = this.getClipboard().getAvailableTypes();
            Transfer[] transfers = new Transfer[]{TextTransfer.getInstance(), RTFTransfer.getInstance()};
            int i = 0;
            block2: while (true) {
                if (i >= types.length) {
                    return false;
                }
                int j = 0;
                while (true) {
                    if (j >= transfers.length) {
                        ++i;
                        continue block2;
                    }
                    if (transfers[j].isSupportedType(types[i])) {
                        return true;
                    }
                    ++j;
                }
                break;
            }
        }
        catch (SWTError sWTError) {}
        return false;
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.views.properties.IPropertySheetPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz)) {
            return null;
        }
        return super.getAdapter(key);
    }

    protected InputContext getInputContext(Object object) {
        InputContext context = null;
        if (object instanceof IBuildObject) {
            context = this.fInputContextManager.findContext("build-context");
        } else if (object instanceof IFeatureObject) {
            context = this.fInputContextManager.findContext("feature-context");
        }
        return context;
    }

    protected boolean isPatchEditor() {
        IBaseModel model = this.getAggregateModel();
        if (model == null || !(model instanceof IFeatureModel)) {
            return false;
        }
        IFeature feature = ((IFeatureModel)model).getFeature();
        IFeatureImport[] imports = feature.getImports();
        int i = 0;
        while (i < imports.length) {
            if (imports[i].isPatch()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void showEditorInput(IEditorInput editorInput) {
        String name = editorInput.getName();
        if (name.equals("feature.xml")) {
            this.setActivePage(0);
        } else {
            this.setActivePage(this.getPageCount() - 3);
        }
    }
}

