/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureInfo;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureURLElement;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.feature.URLDetailsSection;
import org.eclipse.pde.internal.ui.editor.feature.URLSection;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.pde.internal.ui.editor.text.XMLConfiguration;
import org.eclipse.pde.internal.ui.editor.text.XMLPartitionScanner;
import org.eclipse.pde.internal.ui.elements.NamedElement;
import org.eclipse.pde.internal.ui.util.TextUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class InfoSection
extends PDESection {
    private IDocument fDocument;
    private IDocumentPartitioner fPartitioner;
    private XMLConfiguration fSourceConfiguration;
    private SourceViewer fSourceViewer;
    private CTabFolder fTabFolder;
    private Text fUrlText;
    private Object fElement;
    private int fElementIndex;
    private boolean fIgnoreChange;
    private Composite fNotebook;
    private StackLayout fNotebookLayout;
    private Control fInfoPage;
    private Control fUrlsPage;

    public InfoSection(PDEFormPage page, Composite parent, IColorManager colorManager) {
        super(page, parent, 4224, false);
        String description = PDEUIMessages.FeatureEditor_InfoSection_desc;
        this.getSection().setDescription(description);
        this.fSourceConfiguration = new XMLConfiguration(colorManager);
        this.fDocument = new Document();
        this.fPartitioner = new FastPartitioner((IPartitionTokenScanner)new XMLPartitionScanner(), new String[]{"__xml_tag", "__xml_comment"});
        this.fPartitioner.connect(this.fDocument);
        this.fDocument.setDocumentPartitioner(this.fPartitioner);
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    public void commit(boolean onSave) {
        this.handleApply();
        super.commit(onSave);
    }

    public void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(1808);
        section.setLayoutData((Object)data);
        Composite container = toolkit.createComposite((Composite)section);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        container.setLayoutData((Object)new GridData(768));
        toolkit.createLabel(container, null);
        this.fTabFolder = new CTabFolder(container, 0x800080);
        toolkit.adapt((Control)this.fTabFolder, true, true);
        GridData gd = new GridData(256);
        this.fTabFolder.setLayoutData((Object)gd);
        gd.heightHint = 2;
        toolkit.getColors().initializeSectionToolBarColors();
        Color selectedColor = toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG");
        this.fTabFolder.setSelectionBackground(new Color[]{selectedColor, toolkit.getColors().getBackground()}, new int[]{100}, true);
        this.fTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InfoSection.this.updateTabSelection();
            }
        });
        this.fNotebook = toolkit.createComposite(container);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.fNotebook.setLayoutData((Object)gd);
        this.fNotebookLayout = new StackLayout();
        this.fNotebook.setLayout((Layout)this.fNotebookLayout);
        this.fInfoPage = this.createInfoPage(toolkit, this.fNotebook);
        this.fUrlsPage = this.createUrlsPage(toolkit, this.fNotebook);
        this.fNotebookLayout.topControl = this.fInfoPage;
        this.createTabs();
        section.setClient((Control)container);
        this.initialize();
        if (this.fTabFolder.getItemCount() > 0) {
            this.fTabFolder.setSelection(0);
            this.updateTabSelection();
        }
    }

    private Control createInfoPage(FormToolkit toolkit, Composite parent) {
        Composite page = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 5;
        layout.verticalSpacing = 8;
        page.setLayout((Layout)layout);
        Label label = toolkit.createLabel(page, PDEUIMessages.FeatureEditor_InfoSection_url);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.fUrlText = toolkit.createText(page, null, 4);
        this.fUrlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InfoSection.this.infoModified();
            }
        });
        GridData gd = new GridData(768);
        this.fUrlText.setLayoutData((Object)gd);
        label = toolkit.createLabel(page, PDEUIMessages.FeatureEditor_InfoSection_text);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        gd = new GridData(2);
        label.setLayoutData((Object)gd);
        int styles = 834;
        this.fSourceViewer = new SourceViewer(page, null, styles);
        this.fSourceViewer.configure((SourceViewerConfiguration)this.fSourceConfiguration);
        this.fSourceViewer.setDocument(this.fDocument);
        this.fSourceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                InfoSection.this.updateSelection(event.getSelection());
            }
        });
        StyledText styledText = this.fSourceViewer.getTextWidget();
        styledText.setFont(JFaceResources.getTextFont());
        styledText.setMenu(this.getPage().getPDEEditor().getContextMenu());
        styledText.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        if (!SWT.getPlatform().equals("motif")) {
            toolkit.paintBordersFor(page);
        }
        Control[] children = page.getChildren();
        Control control = children[children.length - 1];
        gd = new GridData(1808);
        gd.widthHint = 50;
        gd.heightHint = 50;
        control.setLayoutData((Object)gd);
        return page;
    }

    private Control createUrlsPage(FormToolkit toolkit, Composite parent) {
        Composite page = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 2;
        layout.marginHeight = 5;
        layout.verticalSpacing = 8;
        page.setLayout((Layout)layout);
        URLSection urlSection = new URLSection(this.getPage(), page);
        urlSection.getSection().setLayoutData((Object)new GridData(1810));
        URLDetailsSection urlDetailsSection = new URLDetailsSection(this.getPage(), page);
        urlDetailsSection.getSection().setLayoutData((Object)new GridData(770));
        this.getManagedForm().addPart((IFormPart)urlSection);
        this.getManagedForm().addPart((IFormPart)urlDetailsSection);
        return page;
    }

    private void updateSelection(ISelection selection) {
        this.getPage().getPDEEditor().setSelection(selection);
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.fSourceViewer.doOperation(3);
            return true;
        }
        if (actionId.equals(ActionFactory.COPY.getId())) {
            this.fSourceViewer.doOperation(4);
            return true;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.fSourceViewer.doOperation(5);
            return true;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.fSourceViewer.doOperation(6);
            return true;
        }
        if (actionId.equals(ActionFactory.UNDO.getId())) {
            this.fSourceViewer.doOperation(1);
            return true;
        }
        if (actionId.equals(ActionFactory.REDO.getId())) {
            this.fSourceViewer.doOperation(2);
            return true;
        }
        return false;
    }

    public boolean setFormInput(Object input) {
        if (input instanceof IFeatureInfo) {
            IFeatureInfo info = (IFeatureInfo)input;
            int index = info.getIndex();
            if (index != -1) {
                this.fTabFolder.setSelection(index);
            }
            this.updateEditorInput(input, false);
            return true;
        }
        if (input instanceof IFeatureURLElement || input instanceof NamedElement) {
            this.fTabFolder.setSelection(3);
            this.updateEditorInput(input, false);
            return true;
        }
        return false;
    }

    private void handleApply() {
        if (this.fElementIndex >= 0 && this.fElementIndex < 3 && this.fElement != null) {
            this.handleApply((IFeatureInfo)this.fElement, this.fTabFolder.getSelectionIndex());
        } else {
            this.handleApply(null, this.fTabFolder.getSelectionIndex());
        }
    }

    private void handleApply(IFeatureInfo info, int index) {
        if (index >= 3) {
            return;
        }
        String urlName = this.fUrlText.getText();
        String text = this.fDocument.get();
        this.applyInfoText(info, urlName, text, index);
        this.updateTabImage(this.fTabFolder.getSelection());
    }

    private void applyInfoText(IFeatureInfo targetInfo, String urlText, String text, int index) {
        String url = null;
        if (urlText.length() > 0) {
            url = urlText;
        }
        try {
            IFeatureModel model = (IFeatureModel)this.getPage().getModel();
            IFeature feature = model.getFeature();
            if (targetInfo == null) {
                targetInfo = feature.getFeatureInfo(index);
            }
            if (targetInfo == null) {
                targetInfo = model.getFactory().createInfo(index);
                feature.setFeatureInfo(targetInfo, index);
            }
            targetInfo.setURL(url);
            targetInfo.setDescription(text);
        }
        catch (CoreException coreException) {}
    }

    protected void fillContextMenu(IMenuManager manager) {
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
    }

    public void initialize() {
        IFeatureModel featureModel = (IFeatureModel)this.getPage().getModel();
        this.fDocument.addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                InfoSection.this.infoModified();
            }

            public void documentAboutToBeChanged(DocumentEvent e) {
            }
        });
        this.fUrlText.setEditable(featureModel.isEditable());
        this.fSourceViewer.getTextWidget().setEditable(featureModel.isEditable());
        featureModel.addModelChangedListener((IModelChangedListener)this);
        this.updateEditorInput(featureModel.getFeature().getFeatureInfo(0), false);
    }

    public void dispose() {
        IFeatureModel featureModel;
        if (this.fSourceConfiguration != null) {
            this.fSourceConfiguration.dispose();
        }
        if ((featureModel = (IFeatureModel)this.getPage().getModel()) != null) {
            featureModel.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    private void infoModified() {
        IFeatureModel featureModel = (IFeatureModel)this.getPage().getModel();
        if (!this.fIgnoreChange && featureModel instanceof IEditable) {
            this.markDirty();
        }
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.markStale();
        }
    }

    public void refresh() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        int index = this.fTabFolder.getSelectionIndex();
        if (index < 3) {
            IFeatureInfo info = model.getFeature().getFeatureInfo(index);
            this.fElement = null;
            this.fElementIndex = -1;
            this.updateEditorInput(info, false);
        }
        super.refresh();
    }

    private void createTabs() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        this.addTab(PDEUIMessages.FeatureEditor_info_description, feature.getFeatureInfo(0));
        this.addTab(PDEUIMessages.FeatureEditor_info_copyright, feature.getFeatureInfo(1));
        this.addTab(PDEUIMessages.FeatureEditor_info_license, feature.getFeatureInfo(2));
        this.addTab(PDEUIMessages.FeatureEditor_info_discoveryUrls, null);
    }

    private void addTab(String label, IFeatureInfo info) {
        CTabItem item = new CTabItem(this.fTabFolder, 0);
        item.setText(label);
        item.setData((Object)info);
        this.updateTabImage(item);
    }

    private void updateTabImage(CTabItem item) {
        if (item == null) {
            return;
        }
        Object info = item.getData();
        if (info != null) {
            item.setImage(PDEPlugin.getDefault().getLabelProvider().getImage(info));
        } else {
            item.setImage(PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_DOC_SECTION_OBJ));
        }
    }

    private void updateTabSelection() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        int index = this.fTabFolder.getSelectionIndex();
        if (index < 3) {
            IFeatureInfo info = feature.getFeatureInfo(index);
            this.updateEditorInput(info, true);
        }
        Control oldPage = this.fNotebookLayout.topControl;
        this.fNotebookLayout.topControl = index < 3 ? this.fInfoPage : this.fUrlsPage;
        if (oldPage != this.fNotebookLayout.topControl) {
            this.fNotebook.layout();
        }
    }

    public void setFocus() {
        this.fSourceViewer.getTextWidget().setFocus();
        this.updateSelection(this.fSourceViewer.getSelection());
    }

    private void commitPrevious() {
        IFeatureInfo previous = (IFeatureInfo)this.fElement;
        this.handleApply(previous, this.fElementIndex);
    }

    public void updateEditorInput(Object input, boolean commitPrevious) {
        if (this.isDirty() && commitPrevious) {
            this.commitPrevious();
        }
        this.fIgnoreChange = true;
        String text = "";
        String url = null;
        if (input instanceof IFeatureInfo) {
            IFeatureInfo info = (IFeatureInfo)input;
            text = info.getDescription();
            url = info.getURL();
        }
        text = text == null ? "" : TextUtil.createMultiLine(text, 60, false);
        this.fDocument.set(text);
        if (url == null) {
            this.fUrlText.setText("");
        } else {
            this.fUrlText.setText(url.toString());
        }
        this.fElement = input;
        this.fElementIndex = this.fTabFolder.getSelectionIndex();
        Control oldPage = this.fNotebookLayout.topControl;
        this.fNotebookLayout.topControl = input instanceof IFeatureURLElement || input instanceof NamedElement ? this.fUrlsPage : this.fInfoPage;
        if (oldPage != this.fNotebookLayout.topControl) {
            this.fNotebook.layout();
        }
        this.fIgnoreChange = false;
    }

    public boolean canPaste(Clipboard clipboard) {
        return this.fSourceViewer.canDoOperation(5);
    }
}

