/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import java.util.TreeSet;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.iproduct.IJREInfo;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.launcher.VMHelper;
import org.eclipse.pde.internal.ui.parts.ComboPart;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class JRESection
extends PDESection {
    private Button fJRERadioButton;
    private Button fEERadioButton;
    private Button fInstalledJREsButton;
    private Button fExecutionEnvironmentsButton;
    private ComboPart fJREsCombo;
    private ComboPart fEEsCombo;
    private TreeSet fEEChoices;
    private boolean fBlockChanges;
    private static final String[] TAB_LABELS = new String[4];
    private CTabFolder fTabFolder;
    private int fLastTab;

    static {
        JRESection.TAB_LABELS[0] = "linux";
        JRESection.TAB_LABELS[1] = "macosx";
        JRESection.TAB_LABELS[2] = "solaris";
        JRESection.TAB_LABELS[3] = "win32";
    }

    public JRESection(PDEFormPage page, Composite parent) {
        super(page, parent, 128);
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        section.setLayoutData((Object)data);
        section.setText(PDEUIMessages.ProductJRESection_title);
        section.setDescription(PDEUIMessages.ProductJRESection_desc);
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 3));
        client.setLayoutData((Object)new GridData(768));
        this.initializeValues();
        this.fTabFolder = new CTabFolder(client, 0x800080);
        toolkit.adapt((Control)this.fTabFolder, true, true);
        GridData gd = new GridData(256);
        this.fTabFolder.setLayoutData((Object)gd);
        gd.heightHint = 2;
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        toolkit.getColors().initializeSectionToolBarColors();
        Color selectedColor = toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG");
        this.fTabFolder.setSelectionBackground(new Color[]{selectedColor, toolkit.getColors().getBackground()}, new int[]{100}, true);
        this.fTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JRESection.this.refresh();
            }
        });
        this.fTabFolder.setUnselectedImageVisible(false);
        this.fJRERadioButton = toolkit.createButton(client, PDEUIMessages.ProductJRESection_jreName, 16);
        this.fJRERadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JRESection.this.updateWidgets();
                JRESection.this.getJVMLocations().setJVM(JRESection.this.fJREsCombo.getSelection(), JRESection.this.fLastTab, 0);
            }
        });
        this.fJREsCombo = new ComboPart();
        this.fJREsCombo.createControl(client, toolkit, 2060);
        this.fJREsCombo.getControl().setLayoutData((Object)new GridData(768));
        String[] installs = VMHelper.getVMInstallNames();
        this.fJREsCombo.setItems(installs);
        this.fJREsCombo.add("", 0);
        this.fJREsCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!JRESection.this.fBlockChanges) {
                    JRESection.this.getJVMLocations().setJVM(JRESection.this.fJREsCombo.getSelection(), JRESection.this.fLastTab, 0);
                }
            }
        });
        this.fInstalledJREsButton = toolkit.createButton(client, PDEUIMessages.ProductJRESection_browseJREs, 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.fInstalledJREsButton);
        this.fInstalledJREsButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PreferencesUtil.createPreferenceDialogOn((Shell)JRESection.this.getSection().getShell(), (String)"org.eclipse.jdt.debug.ui.preferences.VMPreferencePage", (String[])new String[]{"org.eclipse.jdt.debug.ui.preferences.VMPreferencePage"}, null).open();
            }
        });
        this.fEERadioButton = toolkit.createButton(client, PDEUIMessages.ProductJRESection_eeName, 16);
        this.fEERadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JRESection.this.updateWidgets();
                JRESection.this.getJVMLocations().setJVM(JRESection.this.fEEsCombo.getSelection(), JRESection.this.fLastTab, 1);
            }
        });
        this.fEEsCombo = new ComboPart();
        this.fEEsCombo.createControl(client, toolkit, 2060);
        this.fEEsCombo.getControl().setLayoutData((Object)new GridData(768));
        this.fEEsCombo.setItems(this.fEEChoices.toArray(new String[this.fEEChoices.size()]));
        this.fEEsCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!JRESection.this.fBlockChanges) {
                    JRESection.this.getJVMLocations().setJVM(JRESection.this.fEEsCombo.getSelection(), JRESection.this.fLastTab, 1);
                }
            }
        });
        this.fExecutionEnvironmentsButton = toolkit.createButton(client, PDEUIMessages.ProductJRESection_browseEEs, 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.fExecutionEnvironmentsButton);
        this.fExecutionEnvironmentsButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PreferencesUtil.createPreferenceDialogOn((Shell)JRESection.this.getSection().getShell(), (String)"org.eclipse.jdt.debug.ui.jreProfiles", (String[])new String[]{"org.eclipse.jdt.debug.ui.jreProfiles"}, null).open();
            }
        });
        this.createTabs();
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
        this.getProductModel().addModelChangedListener((IModelChangedListener)this);
    }

    private IProductModel getProductModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    public void dispose() {
        IProductModel model = this.getProductModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    private void createTabs() {
        int i = 0;
        while (i < TAB_LABELS.length) {
            CTabItem item = new CTabItem(this.fTabFolder, 0);
            item.setText(TAB_LABELS[i]);
            item.setImage(PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_OPERATING_SYSTEM_OBJ));
            ++i;
        }
        this.fLastTab = 0;
        this.fTabFolder.setSelection(this.fLastTab);
        String currentTarget = TargetPlatform.getOS();
        if ("win32".equals(currentTarget)) {
            this.fTabFolder.setSelection(3);
        } else if ("macosx".equals(currentTarget)) {
            this.fTabFolder.setSelection(1);
        } else if ("solaris".equals(currentTarget)) {
            this.fTabFolder.setSelection(2);
        }
    }

    public void refresh() {
        this.fBlockChanges = true;
        this.fLastTab = this.fTabFolder.getSelectionIndex();
        int type = this.getJVMLocations().getJVMType(this.fLastTab);
        String name = this.getJVMLocations().getJVM(this.fLastTab);
        switch (type) {
            case 0: {
                if (this.fJREsCombo.indexOf(name) < 0) {
                    this.fJREsCombo.add(name);
                }
                this.fJREsCombo.setText(name);
                this.fJRERadioButton.setSelection(true);
                this.fEERadioButton.setSelection(false);
                break;
            }
            case 1: {
                if (this.fEEsCombo.indexOf(name) < 0) {
                    this.fEEsCombo.add(name);
                }
                this.fEEsCombo.setText(name);
                this.fEERadioButton.setSelection(true);
                this.fJRERadioButton.setSelection(false);
            }
        }
        this.updateWidgets();
        super.refresh();
        this.fBlockChanges = false;
    }

    private IJREInfo getJVMLocations() {
        IJREInfo info = this.getProduct().getJREInfo();
        if (info == null) {
            info = this.getModel().getFactory().createJVMInfo();
            this.getProduct().setJREInfo(info);
        }
        return info;
    }

    private IProduct getProduct() {
        return this.getModel().getProduct();
    }

    private IProductModel getModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    public boolean canPaste(Clipboard clipboard) {
        Display d = this.getSection().getDisplay();
        return d.getFocusControl() instanceof Text;
    }

    protected void updateWidgets() {
        this.fJREsCombo.setEnabled(this.fJRERadioButton.getSelection());
        this.fEEsCombo.setEnabled(this.fEERadioButton.getSelection());
    }

    protected void initializeValues() {
        this.fEEChoices = new TreeSet();
        IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
        IExecutionEnvironment[] envs = manager.getExecutionEnvironments();
        int i = 0;
        while (i < envs.length) {
            this.fEEChoices.add(envs[i].getId());
            ++i;
        }
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleModelEventWorldChanged(e);
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        this.refresh();
        this.getPage().setLastFocusControl(this.fJREsCombo.getControl());
    }
}

