/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.LaunchShortcutOverviewPage;
import org.eclipse.pde.internal.ui.editor.product.ProductExportAction;
import org.eclipse.pde.internal.ui.editor.product.ProductInfoSection;
import org.eclipse.pde.internal.ui.wizards.product.SynchronizationOperation;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.progress.IProgressService;

public class OverviewPage
extends LaunchShortcutOverviewPage {
    public static final String PAGE_ID = "overview";
    static /* synthetic */ Class class$0;

    public OverviewPage(FormEditor editor) {
        super(editor, PAGE_ID, PDEUIMessages.OverviewPage_title);
    }

    protected String getHelpResource() {
        return "/org.eclipse.pde.doc.user/guide/tools/editors/product_editor/overview.htm";
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.setText(PDEUIMessages.OverviewPage_title);
        form.setImage(PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_PRODUCT_DEFINITION));
        this.fillBody(managedForm, toolkit);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form.getBody(), "org.eclipse.pde.doc.user.overview_page");
    }

    private void fillBody(IManagedForm managedForm, FormToolkit toolkit) {
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)FormLayoutFactory.createFormTableWrapLayout(true, 2));
        ProductInfoSection section = new ProductInfoSection(this, body);
        managedForm.addPart((IFormPart)section);
        if (this.getModel().isEditable()) {
            this.createTestingSection(body, toolkit);
            this.createExportingSection(body, toolkit);
        }
    }

    private void createTestingSection(Composite parent, FormToolkit toolkit) {
        Section section = this.createStaticSection(toolkit, parent, PDEUIMessages.Product_OverviewPage_testing);
        FormText text = this.createClient((Composite)section, this.getLauncherText(false, PDEUIMessages.Product_overview_testing), toolkit);
        PDELabelProvider lp = PDEPlugin.getDefault().getLabelProvider();
        text.setImage("run", lp.get(PDEPluginImages.DESC_RUN_EXC));
        text.setImage("debug", lp.get(PDEPluginImages.DESC_DEBUG_EXC));
        text.setImage("profile", lp.get(PDEPluginImages.DESC_PROFILE_EXC));
        section.setClient((Control)text);
    }

    private void createExportingSection(Composite parent, FormToolkit toolkit) {
        Section section = this.createStaticSection(toolkit, parent, PDEUIMessages.OverviewPage_exportingTitle);
        section.setClient((Control)this.createClient((Composite)section, PDEUIMessages.Product_overview_exporting, toolkit));
    }

    public void linkActivated(HyperlinkEvent e) {
        String href = (String)e.getHref();
        if (href.equals("action.synchronize")) {
            this.handleSynchronize(true);
        } else if (href.equals("action.export")) {
            if (this.getPDEEditor().isDirty()) {
                this.getPDEEditor().doSave(null);
            }
            new ProductExportAction(this.getPDEEditor()).run();
        } else if (href.equals("configuration")) {
            String pageId = this.getProduct().useFeatures() ? "feature-configuration" : "plugin-configuration";
            this.getEditor().setActivePage(pageId);
        } else {
            super.linkActivated(e);
        }
    }

    protected Object getLaunchObject() {
        Object file;
        IEditorInput iEditorInput = this.getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((file = iEditorInput.getAdapter((Class)clazz)) != null) {
            return file;
        }
        return ((IProductModel)this.getPDEEditor().getAggregateModel()).getUnderlyingResource();
    }

    protected void preLaunch() {
        this.handleSynchronize(false);
    }

    private void handleSynchronize(boolean alert) {
        block3: {
            try {
                IProgressService service = PlatformUI.getWorkbench().getProgressService();
                IProject project = this.getPDEEditor().getCommonProject();
                SynchronizationOperation op = new SynchronizationOperation(this.getProduct(), this.getSite().getShell(), project);
                service.runInUI((IRunnableContext)service, (IRunnableWithProgress)op, (ISchedulingRule)PDEPlugin.getWorkspace().getRoot());
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                if (!alert) break block3;
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Synchronize", (String)e.getTargetException().getMessage());
            }
        }
    }

    private IProduct getProduct() {
        IBaseModel model = this.getPDEEditor().getAggregateModel();
        return ((IProductModel)model).getProduct();
    }

    protected short getIndent() {
        return 35;
    }
}

