/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.product.ConfigurationPage;
import org.eclipse.pde.internal.ui.editor.product.ProductEditor;
import org.eclipse.pde.internal.ui.parts.ComboPart;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.pde.internal.ui.wizards.product.ProductDefinitionWizard;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class ProductInfoSection
extends PDESection {
    private FormEntry fNameEntry;
    private ComboPart fAppCombo;
    private ComboPart fProductCombo;
    private Button fPluginButton;
    private Button fFeatureButton;
    private static int NUM_COLUMNS = 3;

    public ProductInfoSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128);
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setText(PDEUIMessages.ProductInfoSection_title);
        section.setDescription(PDEUIMessages.ProductInfoSection_desc);
        section.setLayout((Layout)FormLayoutFactory.createClearTableWrapLayout(false, 1));
        TableWrapData data = new TableWrapData(256);
        data.colspan = 2;
        section.setLayoutData((Object)data);
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, NUM_COLUMNS));
        IActionBars actionBars = this.getPage().getPDEEditor().getEditorSite().getActionBars();
        this.createNameEntry(client, toolkit, actionBars);
        this.createIdEntry(client, toolkit, actionBars);
        this.createApplicationEntry(client, toolkit, actionBars);
        this.createConfigurationOption(client, toolkit);
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
        this.getModel().addModelChangedListener((IModelChangedListener)this);
    }

    public void dispose() {
        IProductModel model = this.getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    private void createNameEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        this.createLabel(client, toolkit, PDEUIMessages.ProductInfoSection_titleLabel);
        this.fNameEntry = new FormEntry(client, toolkit, PDEUIMessages.ProductInfoSection_productname, null, false);
        this.fNameEntry.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            public void textValueChanged(FormEntry entry) {
                ProductInfoSection.this.getProduct().setName(entry.getValue().trim());
            }
        });
        this.fNameEntry.setEditable(this.isEditable());
    }

    private void createIdEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        this.createLabel(client, toolkit, "");
        this.createLabel(client, toolkit, PDEUIMessages.ProductInfoSection_prodIdLabel);
        Label label = toolkit.createLabel(client, PDEUIMessages.ProductInfoSection_id);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.fProductCombo = new ComboPart();
        this.fProductCombo.createControl(client, toolkit, 8);
        this.fProductCombo.getControl().setLayoutData((Object)new GridData(768));
        this.fProductCombo.setItems(TargetPlatform.getProducts());
        this.fProductCombo.add("");
        this.fProductCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProductInfoSection.this.getProduct().setId(ProductInfoSection.this.fProductCombo.getSelection());
            }
        });
        Button button = toolkit.createButton(client, PDEUIMessages.ProductInfoSection_new, 8);
        button.setEnabled(this.isEditable());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProductInfoSection.this.handleNewDefinition();
            }
        });
        this.fProductCombo.getControl().setEnabled(this.isEditable());
    }

    private void handleNewDefinition() {
        ProductDefinitionWizard wizard = new ProductDefinitionWizard(this.getProduct());
        WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
        dialog.create();
        if (dialog.open() == 0) {
            String id = wizard.getProductId();
            IProduct product = this.getProduct();
            product.setId(id);
            product.setApplication(wizard.getApplication());
        }
    }

    private void createApplicationEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        this.createLabel(client, toolkit, "");
        this.createLabel(client, toolkit, PDEUIMessages.ProductInfoSection_appLabel);
        Label label = toolkit.createLabel(client, PDEUIMessages.ProductInfoSection_app, 64);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.fAppCombo = new ComboPart();
        this.fAppCombo.createControl(client, toolkit, 8);
        GridData gd = new GridData(768);
        gd.horizontalSpan = NUM_COLUMNS - 1;
        this.fAppCombo.getControl().setLayoutData((Object)gd);
        this.fAppCombo.setItems(TargetPlatform.getApplications());
        this.fAppCombo.add("");
        this.fAppCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProductInfoSection.this.getProduct().setApplication(ProductInfoSection.this.fAppCombo.getSelection());
            }
        });
        this.fAppCombo.getControl().setEnabled(this.isEditable());
    }

    private void createConfigurationOption(Composite client, FormToolkit toolkit) {
        this.createLabel(client, toolkit, "");
        Composite comp = toolkit.createComposite(client);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        comp.setLayoutData((Object)gd);
        FormText text = toolkit.createFormText(comp, true);
        text.setText(PDEUIMessages.Product_overview_configuration, true, true);
        text.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
                ProductInfoSection.this.getStatusLineManager().setMessage(e.getLabel());
            }

            public void linkExited(HyperlinkEvent e) {
                ProductInfoSection.this.getStatusLineManager().setMessage(null);
            }

            public void linkActivated(HyperlinkEvent e) {
                String pageId = ProductInfoSection.this.fPluginButton.getSelection() ? "plugin-configuration" : "feature-configuration";
                ProductInfoSection.this.getPage().getEditor().setActivePage(pageId);
            }
        });
        this.fPluginButton = toolkit.createButton(comp, PDEUIMessages.ProductInfoSection_plugins, 16);
        gd = new GridData();
        gd.horizontalIndent = 25;
        this.fPluginButton.setLayoutData((Object)gd);
        this.fPluginButton.setEnabled(this.isEditable());
        this.fPluginButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IProduct product;
                boolean selected = ProductInfoSection.this.fPluginButton.getSelection();
                if (selected == (product = ProductInfoSection.this.getProduct()).useFeatures()) {
                    product.setUseFeatures(!selected);
                    ((ProductEditor)ProductInfoSection.this.getPage().getEditor()).updateConfigurationPage();
                }
            }
        });
        this.fFeatureButton = toolkit.createButton(comp, PDEUIMessages.ProductInfoSection_features, 16);
        gd = new GridData();
        gd.horizontalIndent = 25;
        this.fFeatureButton.setLayoutData((Object)gd);
        this.fFeatureButton.setEnabled(this.isEditable());
    }

    private void createLabel(Composite client, FormToolkit toolkit, String text) {
        Label label = toolkit.createLabel(client, text, 64);
        GridData gd = new GridData();
        gd.horizontalSpan = NUM_COLUMNS;
        label.setLayoutData((Object)gd);
    }

    public void commit(boolean onSave) {
        this.fNameEntry.commit();
        super.commit(onSave);
    }

    public void cancelEdit() {
        this.fNameEntry.cancelEdit();
        super.cancelEdit();
    }

    private IProductModel getModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    private IProduct getProduct() {
        return this.getModel().getProduct();
    }

    public void refresh() {
        IProduct product = this.getProduct();
        this.fNameEntry.setValue(product.getName(), true);
        this.refreshProductCombo(product.getId());
        this.fAppCombo.setText(product.getApplication());
        this.fPluginButton.setSelection(!product.useFeatures());
        this.fFeatureButton.setSelection(product.useFeatures());
        super.refresh();
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleModelEventWorldChanged(e);
            return;
        }
        String prop = e.getChangedProperty();
        if (prop == null) {
            return;
        }
        if (prop.equals("id")) {
            this.refreshProductCombo(e.getNewValue().toString());
        } else if (prop.equals("name")) {
            this.fNameEntry.setValue(e.getNewValue().toString(), true);
        } else if (prop.equals("application")) {
            this.fAppCombo.setText(e.getNewValue().toString());
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        boolean previousFeatureSelected = this.fFeatureButton.getSelection();
        this.refresh();
        this.getPage().setLastFocusControl((Control)this.fNameEntry.getText());
        this.revertConfigurationPage(previousFeatureSelected);
    }

    private void revertConfigurationPage(boolean previousFeatureSelected) {
        boolean currentFeatureSelected = this.fFeatureButton.getSelection();
        if (previousFeatureSelected == currentFeatureSelected) {
            return;
        }
        IFormPage currentPage = this.getPage().getEditor().getActivePageInstance();
        if (currentPage instanceof ConfigurationPage) {
            this.getPage().getEditor().setActivePage("overview");
        }
        ((ProductEditor)this.getPage().getEditor()).updateConfigurationPage();
    }

    private void refreshProductCombo(String productID) {
        if (productID == null) {
            productID = "";
        } else if (this.fProductCombo.indexOf(productID) == -1) {
            this.fProductCombo.add(productID, 0);
        }
        this.fProductCombo.setText(productID);
    }

    private IStatusLineManager getStatusLineManager() {
        IEditorSite site = this.getPage().getEditor().getEditorSite();
        return site.getActionBars().getStatusLineManager();
    }

    public boolean canPaste(Clipboard clipboard) {
        Display d = this.getSection().getDisplay();
        Control c = d.getFocusControl();
        return c instanceof Text;
    }
}

