/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaCompositor;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEDetails;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.schema.ElementSection;
import org.eclipse.pde.internal.ui.parts.ComboPart;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class AbstractSchemaDetails
extends PDEDetails {
    protected static final String STRING_TYPE = "string";
    protected static final String BOOLEAN_TYPE = "boolean";
    protected static final String[] BOOLS = new String[]{Boolean.toString(true), Boolean.toString(false)};
    private Section fSection;
    private Text fDtdLabel;
    private ElementSection fElementSection;
    private boolean fShowDTD;
    private Spinner fMinOccurSpinner;
    private Spinner fMaxOccurSpinner;
    private Button fUnboundSelect;
    private Label fMinLabel;
    private Label fMaxLabel;
    private boolean fBlockListeners = false;

    public AbstractSchemaDetails(ElementSection section, boolean showDTD) {
        this.fElementSection = section;
        this.fShowDTD = showDTD;
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 2) {
            return;
        }
        Object[] objects = event.getChangedObjects();
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof ISchemaCompositor) {
                this.updateDTDLabel(objects[i]);
            }
            ++i;
        }
    }

    public final void createContents(Composite parent) {
        parent.setLayout((Layout)FormLayoutFactory.createDetailsGridLayout(false, 1));
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        this.fSection = toolkit.createSection(parent, 384);
        this.fSection.clientVerticalSpacing = 6;
        this.fSection.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData gd = new GridData(1808);
        this.fSection.setLayoutData((Object)gd);
        this.getPage().alignSectionHeaders(this.fElementSection.getSection(), this.fSection);
        Composite client = toolkit.createComposite((Composite)this.fSection);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 3));
        this.createDetails(client);
        if (this.fShowDTD) {
            Label label = toolkit.createLabel(client, PDEUIMessages.AbstractSchemaDetails_dtdLabel);
            label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            gd = new GridData(768);
            gd.horizontalSpan = 3;
            gd.verticalIndent = 15;
            label.setLayoutData((Object)gd);
            this.fDtdLabel = toolkit.createText(client, "", 578);
            gd = new GridData(768);
            gd.horizontalSpan = 3;
            gd.heightHint = 60;
            this.fDtdLabel.setLayoutData((Object)gd);
            this.fDtdLabel.setEditable(false);
            this.fDtdLabel.setMenu(new Menu((Control)client));
        }
        toolkit.paintBordersFor(client);
        this.fSection.setClient((Control)client);
        this.markDetailsPart((Control)this.fSection);
        this.hookListeners();
    }

    public abstract void createDetails(Composite var1);

    public abstract void updateFields(ISchemaObject var1);

    public abstract void hookListeners();

    public boolean isEditableElement() {
        return this.fElementSection.isEditable();
    }

    protected void setDecription(String desc) {
        this.fSection.setDescription(desc);
    }

    protected void setText(String title) {
        this.fSection.setText(title);
    }

    public String getContextId() {
        return "schema-context";
    }

    public PDEFormPage getPage() {
        return (PDEFormPage)((Object)this.getManagedForm().getContainer());
    }

    public boolean isEditable() {
        return this.getPage().getPDEEditor().getAggregateModel().isEditable();
    }

    public void fireSaveNeeded() {
        this.markDirty();
        this.getPage().getPDEEditor().fireSaveNeeded(this.getContextId(), false);
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        if (!(part instanceof ElementSection)) {
            return;
        }
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        this.updateDTDLabel(obj);
        if (obj instanceof ISchemaObject) {
            this.setBlockListeners(true);
            this.updateFields((ISchemaObject)obj);
            this.setBlockListeners(false);
        }
    }

    private void updateDTDLabel(Object changeObject) {
        if (!this.fShowDTD || this.fDtdLabel.isDisposed()) {
            return;
        }
        if (changeObject instanceof ISchemaAttribute) {
            changeObject = ((ISchemaAttribute)changeObject).getParent();
        } else if (changeObject instanceof ISchemaCompositor) {
            while (changeObject != null) {
                if (changeObject instanceof ISchemaElement) break;
                changeObject = ((ISchemaCompositor)changeObject).getParent();
            }
        }
        if (changeObject instanceof ISchemaElement) {
            this.fDtdLabel.setText(((ISchemaElement)changeObject).getDTDRepresentation(false));
        }
    }

    protected void fireMasterSelection(ISelection selection) {
        this.fElementSection.fireSelection(selection);
    }

    protected ComboPart createComboPart(Composite parent, FormToolkit toolkit, String[] items, int colspan) {
        ComboPart cp = new ComboPart();
        cp.createControl(parent, toolkit, 8);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colspan;
        cp.getControl().setLayoutData((Object)gd);
        cp.setItems(items);
        cp.getControl().setEnabled(this.isEditable());
        return cp;
    }

    protected Button[] createTrueFalseButtons(Composite parent, FormToolkit toolkit, int colSpan) {
        Composite comp = toolkit.createComposite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        comp.setLayout((Layout)gl);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        comp.setLayoutData((Object)gd);
        Button tButton = toolkit.createButton(comp, BOOLS[0], 16);
        Button fButton = toolkit.createButton(comp, BOOLS[1], 16);
        gd = new GridData();
        gd.horizontalIndent = 20;
        fButton.setLayoutData((Object)gd);
        return new Button[]{tButton, fButton};
    }

    protected Composite createMinOccurComp(Composite parent, FormToolkit toolkit) {
        this.fMinLabel = toolkit.createLabel(parent, PDEUIMessages.AbstractSchemaDetails_minOccurLabel);
        this.fMinLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        Composite comp = toolkit.createComposite(parent);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)gd);
        this.fMinOccurSpinner = new Spinner(comp, 2048);
        this.fMinOccurSpinner.setMinimum(0);
        this.fMinOccurSpinner.setMaximum(999);
        return comp;
    }

    protected Composite createMaxOccurComp(Composite parent, FormToolkit toolkit) {
        this.fMaxLabel = toolkit.createLabel(parent, PDEUIMessages.AbstractSchemaDetails_maxOccurLabel);
        this.fMaxLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        Composite comp = toolkit.createComposite(parent);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)gd);
        this.fMaxOccurSpinner = new Spinner(comp, 2048);
        this.fMaxOccurSpinner.setMinimum(1);
        this.fMaxOccurSpinner.setMaximum(999);
        this.fMaxOccurSpinner.setIncrement(1);
        this.fUnboundSelect = toolkit.createButton(comp, PDEUIMessages.AbstractSchemaDetails_unboundedButton, 32);
        gd = new GridData();
        gd.horizontalIndent = 10;
        this.fUnboundSelect.setLayoutData((Object)gd);
        this.fUnboundSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractSchemaDetails.this.blockListeners()) {
                    return;
                }
                AbstractSchemaDetails.this.fMaxOccurSpinner.setEnabled(!AbstractSchemaDetails.this.fUnboundSelect.getSelection() && AbstractSchemaDetails.this.isEditableElement());
            }
        });
        return comp;
    }

    protected int getMinOccur() {
        if (this.fMinOccurSpinner != null) {
            return this.fMinOccurSpinner.getSelection();
        }
        return 0;
    }

    protected int getMaxOccur() {
        if (this.fMaxOccurSpinner != null) {
            if (this.fMaxOccurSpinner.isEnabled()) {
                return this.fMaxOccurSpinner.getSelection();
            }
            return Integer.MAX_VALUE;
        }
        return 1;
    }

    protected void updateMinOccur(int min) {
        if (this.fMinOccurSpinner != null) {
            this.fMinOccurSpinner.setSelection(min);
        }
    }

    protected void updateMaxOccur(int max) {
        if (this.fMaxOccurSpinner == null) {
            return;
        }
        boolean isMax = max == Integer.MAX_VALUE;
        this.fUnboundSelect.setSelection(isMax);
        this.fMaxOccurSpinner.setEnabled(!isMax);
        if (!isMax) {
            this.fMaxOccurSpinner.setSelection(max);
        }
    }

    protected void hookMinOccur(SelectionAdapter adapter) {
        this.fMinOccurSpinner.addSelectionListener((SelectionListener)adapter);
        this.fMinOccurSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AbstractSchemaDetails.this.blockListeners()) {
                    return;
                }
                int minOccur = AbstractSchemaDetails.this.fMinOccurSpinner.getSelection();
                if (minOccur > AbstractSchemaDetails.this.getMaxOccur()) {
                    AbstractSchemaDetails.this.fMinOccurSpinner.setSelection(minOccur - 1);
                }
            }
        });
    }

    protected void hookMaxOccur(SelectionAdapter adapter) {
        this.fUnboundSelect.addSelectionListener((SelectionListener)adapter);
        this.fMaxOccurSpinner.addSelectionListener((SelectionListener)adapter);
        this.fMaxOccurSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AbstractSchemaDetails.this.blockListeners()) {
                    return;
                }
                int maxValue = AbstractSchemaDetails.this.fMaxOccurSpinner.getSelection();
                if (maxValue < AbstractSchemaDetails.this.getMinOccur()) {
                    AbstractSchemaDetails.this.fMaxOccurSpinner.setSelection(maxValue + 1);
                }
            }
        });
    }

    protected void enableMinMax(boolean enable) {
        this.fMinOccurSpinner.setEnabled(enable);
        this.fMaxOccurSpinner.setEnabled(!this.fUnboundSelect.getSelection() && enable);
        this.fUnboundSelect.setEnabled(enable);
        this.fMinLabel.setEnabled(enable);
        this.fMaxLabel.setEnabled(enable);
    }

    protected boolean blockListeners() {
        return this.fBlockListeners;
    }

    protected void setBlockListeners(boolean blockListeners) {
        this.fBlockListeners = blockListeners;
    }
}

