/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaObjectReference;
import org.eclipse.pde.internal.core.schema.SchemaObject;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.context.XMLDocumentSetupParticpant;
import org.eclipse.pde.internal.ui.editor.schema.ElementSection;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.pde.internal.ui.editor.text.XMLConfiguration;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class DescriptionSection
extends PDESection
implements IPartSelectionListener {
    private SourceViewer fSourceViewer;
    private IDocument fDocument;
    private ISchemaObject fElement;
    private boolean fIgnoreChange;
    private XMLConfiguration fSourceConfiguration;

    public DescriptionSection(PDEFormPage page, Composite parent, IColorManager colorManager) {
        super(page, parent, 128);
        this.fSourceConfiguration = new XMLConfiguration(colorManager);
        this.getSection().setText(PDEUIMessages.SchemaEditor_DescriptionSection_title);
        this.getSection().setDescription(PDEUIMessages.SchemaEditor_DescriptionSection_desc);
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    public void commit(boolean onSave) {
        this.updateDescription();
        super.commit(onSave);
    }

    public void createClient(Section section, FormToolkit toolkit) {
        Composite container = toolkit.createComposite((Composite)section);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        GridData data = new GridData(768);
        section.setLayoutData((Object)data);
        this.fSourceViewer = new SourceViewer(container, null, 834);
        this.fSourceViewer.configure((SourceViewerConfiguration)this.fSourceConfiguration);
        this.fDocument = new Document();
        new XMLDocumentSetupParticpant().setup(this.fDocument);
        this.fSourceViewer.setDocument(this.fDocument);
        this.fSourceViewer.setEditable(this.isEditable());
        this.fSourceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DescriptionSection.this.updateSelection(event.getSelection());
            }
        });
        StyledText styledText = this.fSourceViewer.getTextWidget();
        styledText.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
        if (!SWT.getPlatform().equals("motif")) {
            toolkit.paintBordersFor(container);
        }
        styledText.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        Control[] children = container.getChildren();
        Control control = children[children.length - 1];
        GridData gd = new GridData(1808);
        gd.widthHint = 200;
        gd.heightHint = 120;
        control.setLayoutData((Object)gd);
        styledText.setMenu(this.getPage().getPDEEditor().getContextMenu());
        styledText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DescriptionSection.this.updateSelection(DescriptionSection.this.fSourceViewer.getSelection());
            }
        });
        section.setClient((Control)container);
        this.initialize();
    }

    private void updateSelection(ISelection selection) {
        this.getPage().getPDEEditor().setSelection(selection);
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.fSourceViewer.doOperation(3);
            return true;
        }
        if (actionId.equals(ActionFactory.COPY.getId())) {
            this.fSourceViewer.doOperation(4);
            return true;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.fSourceViewer.doOperation(5);
            return true;
        }
        if (actionId.equals(ActionFactory.SELECT_ALL.getId())) {
            this.fSourceViewer.doOperation(7);
            return true;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.fSourceViewer.doOperation(6);
            return true;
        }
        if (actionId.equals(ActionFactory.UNDO.getId())) {
            this.fSourceViewer.doOperation(1);
            return true;
        }
        if (actionId.equals(ActionFactory.REDO.getId())) {
            this.fSourceViewer.doOperation(2);
            return true;
        }
        return false;
    }

    protected void fillContextMenu(IMenuManager manager) {
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
    }

    private void updateDescription() {
        if (this.fElement instanceof SchemaObject) {
            ((SchemaObject)this.fElement).setDescription(this.fDocument.get());
        }
    }

    public void initialize() {
        this.updateDocument();
        this.fDocument.addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (!DescriptionSection.this.fIgnoreChange && DescriptionSection.this.getPage().getPDEEditor().getAggregateModel().isEditable()) {
                    DescriptionSection.this.markDirty();
                }
            }

            public void documentAboutToBeChanged(DocumentEvent e) {
            }
        });
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        if (!(part instanceof ElementSection)) {
            return;
        }
        Object changeObject = ((IStructuredSelection)selection).getFirstElement();
        if (changeObject != this.fElement && this.isDirty()) {
            this.updateDescription();
        }
        this.fElement = (ISchemaObject)changeObject;
        if (this.fElement instanceof ISchemaObjectReference) {
            this.fElement = ((ISchemaObjectReference)this.fElement).getReferencedObject();
        }
        this.updateDocument();
    }

    public void setFocus() {
        this.fSourceViewer.getTextWidget().setFocus();
    }

    public void updateDocument() {
        if (this.fElement != null) {
            this.fIgnoreChange = true;
            String text = this.fElement.getDescription();
            this.fDocument.set(text == null ? "" : text);
            this.fIgnoreChange = false;
        }
    }

    public boolean canPaste(Clipboard clipboard) {
        return this.fSourceViewer.canDoOperation(5);
    }

    public void dispose() {
        if (this.fSourceConfiguration != null) {
            this.fSourceConfiguration.dispose();
        }
        super.dispose();
    }
}

