/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaRestriction;
import org.eclipse.pde.internal.core.ischema.ISchemaSimpleType;
import org.eclipse.pde.internal.core.schema.ChoiceRestriction;
import org.eclipse.pde.internal.core.schema.SchemaAttribute;
import org.eclipse.pde.internal.core.schema.SchemaEnumeration;
import org.eclipse.pde.internal.core.schema.SchemaSimpleType;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.schema.AbstractSchemaDetails;
import org.eclipse.pde.internal.ui.editor.schema.ElementSection;
import org.eclipse.pde.internal.ui.editor.schema.NewClassCreationWizard;
import org.eclipse.pde.internal.ui.editor.schema.NewRestrictionDialog;
import org.eclipse.pde.internal.ui.elements.DefaultTableProvider;
import org.eclipse.pde.internal.ui.parts.ComboPart;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SchemaAttributeDetails
extends AbstractSchemaDetails {
    private static final String JAVA_TYPE = "java";
    private static final String RESOURCE_TYPE = "resource";
    private static final int BOOL_IND = 0;
    private static final int STR_IND = 1;
    private static final int JAVA_IND = 2;
    private static final int RES_IND = 3;
    private static final String[] TYPES = new String[4];
    private static final String[] USE;
    private SchemaAttribute fAttribute;
    private FormEntry fValue;
    private FormEntry fName;
    private Button fDepTrue;
    private Button fDepFalse;
    private Button fTransTrue;
    private Button fTransFalse;
    private ComboPart fType;
    private ComboPart fUse;
    private TableViewer fRestrictionsTable;
    private FormEntry fClassEntry;
    private FormEntry fInterfaceEntry;
    private Button fAddRestriction;
    private Button fRemoveRestriction;
    private Composite fBooleanTypeComp;
    private Composite fStringTypeComp;
    private Composite fJavaTypeComp;
    private Composite fResourceTypeComp;
    private Composite fNotebook;
    private StackLayout fNotebookLayout;

    static {
        SchemaAttributeDetails.TYPES[0] = "boolean";
        SchemaAttributeDetails.TYPES[1] = "string";
        SchemaAttributeDetails.TYPES[2] = JAVA_TYPE;
        SchemaAttributeDetails.TYPES[3] = RESOURCE_TYPE;
        USE = new String[]{"optional", "required", "default"};
    }

    public SchemaAttributeDetails(ElementSection section) {
        super(section, false);
    }

    public void createDetails(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Color foreground = toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE");
        this.fName = new FormEntry(parent, toolkit, PDEUIMessages.SchemaDetails_name, 0);
        Label label = toolkit.createLabel(parent, PDEUIMessages.SchemaDetails_deprecated);
        label.setForeground(foreground);
        Button[] buttons = this.createTrueFalseButtons(parent, toolkit, 2);
        this.fDepTrue = buttons[0];
        this.fDepFalse = buttons[1];
        label = toolkit.createLabel(parent, PDEUIMessages.SchemaAttributeDetails_use);
        label.setForeground(foreground);
        this.fUse = this.createComboPart(parent, toolkit, USE, 2);
        this.fValue = new FormEntry(parent, toolkit, PDEUIMessages.SchemaAttributeDetails_defaultValue, null, false, 6);
        label = toolkit.createLabel(parent, PDEUIMessages.SchemaAttributeDetails_type);
        label.setForeground(foreground);
        this.fType = this.createComboPart(parent, toolkit, TYPES, 2);
        this.fNotebook = toolkit.createComposite(parent);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        this.fNotebook.setLayoutData((Object)gd);
        this.fNotebook.setLayout((Layout)new GridLayout());
        this.fNotebookLayout = new StackLayout();
        this.fNotebook.setLayout((Layout)this.fNotebookLayout);
        this.fBooleanTypeComp = this.createEmptyComposite(this.fNotebook, toolkit);
        this.fStringTypeComp = this.createStringTypeComp(this.fNotebook, toolkit, foreground);
        this.fJavaTypeComp = this.createJavaTypeComp(this.fNotebook, toolkit, foreground);
        this.fResourceTypeComp = this.createEmptyComposite(this.fNotebook, toolkit);
        toolkit.paintBordersFor(parent);
        toolkit.paintBordersFor(this.fNotebook);
        toolkit.paintBordersFor(this.fJavaTypeComp);
        toolkit.paintBordersFor(this.fStringTypeComp);
        this.setText(PDEUIMessages.SchemaAttributeDetails_title);
    }

    private Composite createEmptyComposite(Composite parent, FormToolkit toolkit) {
        Composite comp = toolkit.createComposite(parent);
        comp.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 2;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        return comp;
    }

    private Composite createJavaTypeComp(Composite parent, FormToolkit toolkit, Color foreground) {
        Composite comp = this.createEmptyComposite(parent, toolkit);
        this.fClassEntry = new FormEntry(comp, toolkit, PDEUIMessages.SchemaAttributeDetails_extends, PDEUIMessages.SchemaAttributeDetails_browseButton, this.isEditable(), 13);
        this.fInterfaceEntry = new FormEntry(comp, toolkit, PDEUIMessages.SchemaAttributeDetails_implements, PDEUIMessages.SchemaAttributeDetails_browseButton, this.isEditable(), 13);
        return comp;
    }

    private Composite createStringTypeComp(Composite parent, FormToolkit toolkit, Color foreground) {
        Composite comp = this.createEmptyComposite(parent, toolkit);
        Label label = toolkit.createLabel(comp, PDEUIMessages.SchemaDetails_translatable);
        label.setForeground(foreground);
        GridData gd = new GridData(2);
        gd.horizontalIndent = 11;
        gd.verticalIndent = 2;
        label.setLayoutData((Object)gd);
        Button[] buttons = this.createTrueFalseButtons(comp, toolkit, 2);
        this.fTransTrue = buttons[0];
        this.fTransFalse = buttons[1];
        label = toolkit.createLabel(comp, PDEUIMessages.SchemaAttributeDetails_restrictions);
        label.setForeground(foreground);
        gd = new GridData(2);
        gd.horizontalIndent = 11;
        gd.verticalIndent = 2;
        label.setLayoutData((Object)gd);
        Composite tableComp = toolkit.createComposite(comp);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        tableComp.setLayout((Layout)layout);
        tableComp.setLayoutData((Object)new GridData(768));
        Table table = toolkit.createTable(tableComp, 2562);
        gd = new GridData(768);
        gd.heightHint = 40;
        table.setLayoutData((Object)gd);
        this.fRestrictionsTable = new TableViewer(table);
        this.fRestrictionsTable.setContentProvider((IContentProvider)new SchemaAttributeContentProvider());
        this.fRestrictionsTable.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        Composite resButtonComp = toolkit.createComposite(comp);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        resButtonComp.setLayout((Layout)layout);
        resButtonComp.setLayoutData((Object)new GridData(2));
        this.fAddRestriction = toolkit.createButton(resButtonComp, PDEUIMessages.SchemaAttributeDetails_addRestButton, 0);
        this.fRemoveRestriction = toolkit.createButton(resButtonComp, PDEUIMessages.SchemaAttributeDetails_removeRestButton, 0);
        this.fAddRestriction.setLayoutData((Object)new GridData(768));
        this.fRemoveRestriction.setLayoutData((Object)new GridData(768));
        return comp;
    }

    public void updateFields(ISchemaObject object) {
        if (!(object instanceof SchemaAttribute)) {
            return;
        }
        this.fAttribute = (SchemaAttribute)object;
        this.setDecription(NLS.bind((String)PDEUIMessages.SchemaAttributeDetails_description, (Object)this.fAttribute.getName()));
        this.fRestrictionsTable.setInput(new Object());
        this.fName.setValue(this.fAttribute.getName(), true);
        this.fDepTrue.setSelection(this.fAttribute.isDeprecated());
        this.fDepFalse.setSelection(!this.fAttribute.isDeprecated());
        this.fTransTrue.setSelection(this.fAttribute.isTranslatable());
        this.fTransFalse.setSelection(!this.fAttribute.isTranslatable());
        boolean isStringType = this.fAttribute.getType().getName().equals("string");
        int kind = this.fAttribute.getKind();
        this.fType.select(isStringType ? 1 + kind : 0);
        this.fUse.select(this.fAttribute.getUse());
        Object value = this.fAttribute.getValue();
        this.fValue.setValue(value != null ? value.toString() : "", true);
        this.updateJavaFields();
        boolean editable = this.isEditableElement();
        this.updateTabSelection(this.fType.getSelectionIndex());
        this.fTransTrue.setEnabled(editable);
        this.fTransFalse.setEnabled(editable);
        this.fRestrictionsTable.getControl().setEnabled(editable);
        this.fAddRestriction.setEnabled(editable);
        this.fRemoveRestriction.setEnabled(!this.fRestrictionsTable.getSelection().isEmpty() && editable);
        if (this.fAttribute.getUse() != 2) {
            this.fValue.getLabel().setEnabled(false);
            this.fValue.getText().setEditable(false);
        } else {
            this.fValue.setEditable(editable);
        }
        this.fName.setEditable(editable);
        this.fDepTrue.setEnabled(editable);
        this.fDepFalse.setEnabled(editable);
        this.fType.setEnabled(editable);
        this.fUse.setEnabled(editable);
        this.fClassEntry.setEditable(editable);
        this.fInterfaceEntry.setEditable(editable);
    }

    private void updateJavaFields() {
        String basedOn = this.fAttribute.getBasedOn();
        if (basedOn != null && basedOn.length() > 0) {
            int index = basedOn.indexOf(":");
            if (index == -1) {
                String className = basedOn.substring(basedOn.lastIndexOf(".") + 1);
                if (className.length() > 1 && className.charAt(0) == 'I') {
                    this.fClassEntry.setValue("", true);
                    this.fInterfaceEntry.setValue(basedOn, true);
                } else {
                    this.fClassEntry.setValue(basedOn, true);
                    this.fInterfaceEntry.setValue("", true);
                }
            } else {
                this.fClassEntry.setValue(basedOn.substring(0, index), true);
                this.fInterfaceEntry.setValue(basedOn.substring(index + 1), true);
            }
        } else {
            this.fClassEntry.setValue("", true);
            this.fInterfaceEntry.setValue("", true);
        }
    }

    public void hookListeners() {
        IActionBars actionBars = this.getPage().getPDEEditor().getEditorSite().getActionBars();
        this.fValue.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry entry) {
                if (SchemaAttributeDetails.this.blockListeners()) {
                    return;
                }
                SchemaAttributeDetails.this.fAttribute.setValue(SchemaAttributeDetails.this.fValue.getValue());
            }
        });
        this.fName.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry entry) {
                if (SchemaAttributeDetails.this.blockListeners()) {
                    return;
                }
                SchemaAttributeDetails.this.fAttribute.setName(SchemaAttributeDetails.this.fName.getValue());
                SchemaAttributeDetails.this.setDecription(NLS.bind((String)PDEUIMessages.SchemaAttributeDetails_description, (Object)SchemaAttributeDetails.this.fAttribute.getName()));
            }
        });
        this.fDepTrue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SchemaAttributeDetails.this.blockListeners()) {
                    return;
                }
                SchemaAttributeDetails.this.fAttribute.setDeprecatedProperty(SchemaAttributeDetails.this.fDepTrue.getSelection());
            }
        });
        this.fTransTrue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SchemaAttributeDetails.this.blockListeners()) {
                    return;
                }
                SchemaAttributeDetails.this.fAttribute.setTranslatableProperty(SchemaAttributeDetails.this.fTransTrue.getSelection());
            }
        });
        this.fType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SchemaAttributeDetails.this.blockListeners()) {
                    return;
                }
                String typeString = SchemaAttributeDetails.this.fType.getSelection();
                if (!typeString.equals("boolean")) {
                    typeString = "string";
                }
                SchemaAttributeDetails.this.fAttribute.setType((ISchemaSimpleType)new SchemaSimpleType(SchemaAttributeDetails.this.fAttribute.getSchema(), typeString));
                int kind = SchemaAttributeDetails.this.fType.getSelectionIndex() - 1;
                SchemaAttributeDetails.this.fAttribute.setKind(kind > 0 ? kind : 0);
                ISchemaSimpleType type = SchemaAttributeDetails.this.fAttribute.getType();
                if (type instanceof SchemaSimpleType && kind != 0 && ((SchemaSimpleType)type).getRestriction() != null) {
                    ((SchemaSimpleType)type).setRestriction(null);
                }
                SchemaAttributeDetails.this.updateTabSelection(SchemaAttributeDetails.this.fType.getSelectionIndex());
            }
        });
        this.fUse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SchemaAttributeDetails.this.blockListeners()) {
                    return;
                }
                int use = SchemaAttributeDetails.this.fUse.getSelectionIndex();
                SchemaAttributeDetails.this.fAttribute.setUse(use);
                SchemaAttributeDetails.this.fValue.getLabel().setEnabled(use == 2);
                SchemaAttributeDetails.this.fValue.getText().setEditable(use == 2);
                if (use == 2 && SchemaAttributeDetails.this.fValue.getValue().length() == 0) {
                    SchemaAttributeDetails.this.fValue.setValue(PDEUIMessages.SchemaAttributeDetails_defaultDefaultValue);
                    SchemaAttributeDetails.this.fValue.getText().setSelection(0, SchemaAttributeDetails.this.fValue.getValue().length());
                    SchemaAttributeDetails.this.fValue.getText().setFocus();
                } else if (use != 2) {
                    SchemaAttributeDetails.this.fValue.setValue("");
                }
            }
        });
        this.fClassEntry.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            public void textValueChanged(FormEntry entry) {
                if (SchemaAttributeDetails.this.blockListeners()) {
                    return;
                }
                SchemaAttributeDetails.this.setBasedOn();
            }

            public void linkActivated(HyperlinkEvent e) {
                if (SchemaAttributeDetails.this.blockListeners()) {
                    return;
                }
                String value = SchemaAttributeDetails.this.fClassEntry.getValue();
                if ((value = SchemaAttributeDetails.this.handleLinkActivated(value, false)) != null) {
                    SchemaAttributeDetails.this.fClassEntry.setValue(value);
                }
            }

            public void browseButtonSelected(FormEntry entry) {
                if (SchemaAttributeDetails.this.blockListeners()) {
                    return;
                }
                SchemaAttributeDetails.this.doOpenSelectionDialog(2, SchemaAttributeDetails.this.fClassEntry);
            }
        });
        this.fInterfaceEntry.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            public void textValueChanged(FormEntry entry) {
                if (SchemaAttributeDetails.this.blockListeners()) {
                    return;
                }
                SchemaAttributeDetails.this.setBasedOn();
            }

            public void linkActivated(HyperlinkEvent e) {
                if (SchemaAttributeDetails.this.blockListeners()) {
                    return;
                }
                String value = SchemaAttributeDetails.this.fInterfaceEntry.getValue();
                if ((value = SchemaAttributeDetails.this.handleLinkActivated(value, true)) != null) {
                    SchemaAttributeDetails.this.fInterfaceEntry.setValue(value);
                }
            }

            public void browseButtonSelected(FormEntry entry) {
                if (SchemaAttributeDetails.this.blockListeners()) {
                    return;
                }
                SchemaAttributeDetails.this.doOpenSelectionDialog(4, SchemaAttributeDetails.this.fInterfaceEntry);
            }
        });
        this.fAddRestriction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SchemaAttributeDetails.this.blockListeners()) {
                    return;
                }
                NewRestrictionDialog dialog = new NewRestrictionDialog(SchemaAttributeDetails.this.getPage().getSite().getShell());
                if (dialog.open() != 0) {
                    return;
                }
                String text = dialog.getNewRestriction();
                if (text != null && text.length() > 0) {
                    ISchemaSimpleType type = SchemaAttributeDetails.this.fAttribute.getType();
                    ChoiceRestriction res = (ChoiceRestriction)type.getRestriction();
                    Vector<Object> vres = new Vector<Object>();
                    if (res != null) {
                        Object[] currRes = res.getChildren();
                        int i = 0;
                        while (i < currRes.length) {
                            vres.add(currRes[i]);
                            ++i;
                        }
                    }
                    vres.add(new SchemaEnumeration((ISchemaObject)SchemaAttributeDetails.this.fAttribute.getSchema(), text));
                    if (res == null) {
                        res = new ChoiceRestriction(SchemaAttributeDetails.this.fAttribute.getSchema());
                    }
                    res.setChildren(vres);
                    if (type instanceof SchemaSimpleType) {
                        ((SchemaSimpleType)type).setRestriction((ISchemaRestriction)res);
                    }
                    SchemaAttributeDetails.this.fRestrictionsTable.refresh();
                }
            }
        });
        this.fRemoveRestriction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SchemaAttributeDetails.this.blockListeners()) {
                    return;
                }
                ISelection selection = SchemaAttributeDetails.this.fRestrictionsTable.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection sselection = (IStructuredSelection)selection;
                Object[] aselection = sselection.toArray();
                ISchemaSimpleType type = SchemaAttributeDetails.this.fAttribute.getType();
                ChoiceRestriction res = (ChoiceRestriction)type.getRestriction();
                Vector<Object> vres = new Vector<Object>();
                if (res != null) {
                    Object[] currRes = res.getChildren();
                    int i = 0;
                    while (i < currRes.length) {
                        boolean stays = true;
                        int j = 0;
                        while (j < aselection.length) {
                            if (currRes[i].equals(aselection[j])) {
                                stays = false;
                            }
                            ++j;
                        }
                        if (stays) {
                            vres.add(currRes[i]);
                        }
                        ++i;
                    }
                    res.setChildren(vres);
                    if (type instanceof SchemaSimpleType) {
                        if (vres.size() == 0) {
                            ((SchemaSimpleType)type).setRestriction(null);
                        } else {
                            ((SchemaSimpleType)type).setRestriction((ISchemaRestriction)res);
                        }
                    }
                    SchemaAttributeDetails.this.fRestrictionsTable.refresh();
                }
            }
        });
        this.fRestrictionsTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (SchemaAttributeDetails.this.blockListeners()) {
                    return;
                }
                SchemaAttributeDetails.this.fRemoveRestriction.setEnabled(SchemaAttributeDetails.this.fAttribute.getSchema().isEditable() && !event.getSelection().isEmpty());
            }
        });
    }

    private String handleLinkActivated(String value, boolean isInter) {
        IProject project = this.getPage().getPDEEditor().getCommonProject();
        try {
            if (project != null && project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IType element = javaProject.findType(value.replace('$', '.'));
                if (element != null) {
                    JavaUI.openInEditor((IJavaElement)element);
                } else {
                    NewClassCreationWizard wizard = new NewClassCreationWizard(project, isInter);
                    WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
                    dialog.create();
                    SWTUtil.setDialogSize((Dialog)dialog, 400, 500);
                    if (dialog.open() == 0) {
                        return wizard.getQualifiedName();
                    }
                }
            }
        }
        catch (PartInitException partInitException) {
        }
        catch (CoreException coreException) {}
        return null;
    }

    private void setBasedOn() {
        String classEntry = this.fClassEntry.getValue().replaceAll(":", "");
        String interfaceEntry = this.fInterfaceEntry.getValue().replaceAll(":", "");
        StringBuffer sb = new StringBuffer();
        if (classEntry.length() > 0) {
            sb.append(classEntry);
        }
        if (classEntry.length() > 0 || interfaceEntry.length() > 0) {
            sb.append(":");
        }
        if (interfaceEntry.length() > 0) {
            sb.append(interfaceEntry);
        }
        this.fAttribute.setBasedOn(sb.length() > 0 ? sb.toString() : null);
    }

    private void doOpenSelectionDialog(int scopeType, FormEntry entry) {
        try {
            String filter = entry.getValue();
            filter = filter.substring(filter.lastIndexOf(".") + 1);
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)PDEPlugin.getActiveWorkbenchShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)scopeType, (boolean)false, (String)filter);
            dialog.setTitle(PDEUIMessages.GeneralInfoSection_selectionTitle);
            if (dialog.open() == 0) {
                IType type = (IType)dialog.getResult()[0];
                entry.setValue(type.getFullyQualifiedName('$'));
                entry.commit();
            }
        }
        catch (CoreException coreException) {}
    }

    private void updateTabSelection(int kind) {
        Control oldPage = this.fNotebookLayout.topControl;
        switch (kind) {
            case 0: {
                this.fNotebookLayout.topControl = this.fBooleanTypeComp;
                break;
            }
            case 1: {
                this.fNotebookLayout.topControl = this.fStringTypeComp;
                break;
            }
            case 2: {
                this.fNotebookLayout.topControl = this.fJavaTypeComp;
                break;
            }
            case 3: {
                this.fNotebookLayout.topControl = this.fResourceTypeComp;
            }
        }
        if (oldPage != this.fNotebookLayout.topControl) {
            this.fNotebook.layout();
        }
    }

    public void modelChanged(IModelChangedEvent event) {
        Object[] changedObjs = event.getChangedObjects();
        if (event.getChangeType() == 1 && changedObjs.length > 0 && changedObjs[0] instanceof SchemaAttribute) {
            this.fName.getText().setFocus();
        }
        super.modelChanged(event);
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
        this.fName.commit();
        this.fClassEntry.commit();
        this.fInterfaceEntry.commit();
        this.fValue.commit();
    }

    class SchemaAttributeContentProvider
    extends DefaultTableProvider {
        SchemaAttributeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ISchemaSimpleType type = SchemaAttributeDetails.this.fAttribute.getType();
            ISchemaRestriction restriction = type.getRestriction();
            if (restriction != null) {
                return restriction.getChildren();
            }
            return new Object[0];
        }
    }
}

