/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.pde.internal.ui.editor.JarEntryEditorInput;
import org.eclipse.pde.internal.ui.editor.JarEntryFile;
import org.eclipse.pde.internal.ui.editor.MultiSourceEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.SystemFileEditorInput;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.schema.SchemaFormOutlinePage;
import org.eclipse.pde.internal.ui.editor.schema.SchemaFormPage;
import org.eclipse.pde.internal.ui.editor.schema.SchemaInputContext;
import org.eclipse.pde.internal.ui.editor.schema.SchemaInputContextManager;
import org.eclipse.pde.internal.ui.editor.schema.SchemaOverviewPage;
import org.eclipse.pde.internal.ui.editor.schema.SchemaSourcePage;
import org.eclipse.pde.internal.ui.search.ShowDescriptionAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;

public class SchemaEditor
extends MultiSourceEditor {
    private ShowDescriptionAction fPreviewAction;

    protected String getEditorID() {
        return "org.eclipse.pde.ui.schemaEditor";
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public String getContextIDForSaveAs() {
        return "schema-context";
    }

    protected void createResourceContexts(InputContextManager manager, IFileEditorInput input) {
        IFile file = input.getFile();
        FileEditorInput in = new FileEditorInput(file);
        manager.putContext((IEditorInput)in, new SchemaInputContext(this, (IEditorInput)in, true));
        manager.monitorFile(file);
    }

    protected InputContextManager createInputContextManager() {
        SchemaInputContextManager contextManager = new SchemaInputContextManager(this);
        return contextManager;
    }

    public void monitoredFileAdded(IFile file) {
    }

    public boolean monitoredFileRemoved(IFile file) {
        return true;
    }

    public void editorContextAdded(InputContext context) {
        this.addSourcePage(context.getId());
    }

    public void contextRemoved(InputContext context) {
        this.close(false);
    }

    protected void createSystemFileContexts(InputContextManager manager, SystemFileEditorInput input) {
        manager.putContext((IEditorInput)input, new SchemaInputContext(this, (IEditorInput)input, true));
    }

    protected void createStorageContexts(InputContextManager manager, IStorageEditorInput input) {
        manager.putContext((IEditorInput)input, new SchemaInputContext(this, (IEditorInput)input, true));
    }

    void previewReferenceDocument() {
        ISchema schema = (ISchema)this.getAggregateModel();
        if (this.fPreviewAction == null) {
            this.fPreviewAction = new ShowDescriptionAction(schema);
        } else {
            this.fPreviewAction.setSchema(schema);
        }
        this.fPreviewAction.run();
    }

    protected void addEditorPages() {
        try {
            this.addPage((IFormPage)new SchemaOverviewPage(this));
            this.addPage((IFormPage)new SchemaFormPage(this));
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
        this.addSourcePage("schema-context");
    }

    protected String computeInitialPageId() {
        String firstPageId = super.computeInitialPageId();
        if (firstPageId == null) {
            firstPageId = "overview";
        }
        return firstPageId;
    }

    protected PDESourcePage createSourcePage(PDEFormEditor editor, String title, String name, String contextId) {
        return new SchemaSourcePage(editor, title, name);
    }

    protected ISortableContentOutlinePage createContentOutline() {
        return new SchemaFormOutlinePage(this);
    }

    protected InputContext getInputContext(Object object) {
        InputContext context = null;
        if (object instanceof ISchemaObject) {
            context = this.fInputContextManager.findContext("schema-context");
        }
        return context;
    }

    public static boolean openSchema(IFile file) {
        if (file != null && file.exists()) {
            FileEditorInput input = new FileEditorInput(file);
            try {
                return PDEPlugin.getActivePage().openEditor((IEditorInput)input, "org.eclipse.pde.ui.schemaEditor") != null;
            }
            catch (PartInitException partInitException) {}
        }
        Display.getDefault().beep();
        return false;
    }

    public static boolean openSchema(IPath path) {
        String pluginId = path.segment(0);
        IPluginModelBase model = PluginRegistry.findModel((String)pluginId);
        if (model != null && model.getUnderlyingResource() != null) {
            IProject project = model.getUnderlyingResource().getProject();
            IFile file = project.getFile(path.removeFirstSegments(1));
            return SchemaEditor.openSchema(file);
        }
        Display.getDefault().beep();
        return false;
    }

    public static boolean openSchema(File file) {
        if (file == null || !file.exists()) {
            Display.getDefault().beep();
            return false;
        }
        SystemFileEditorInput input = new SystemFileEditorInput(file);
        return SchemaEditor.openEditor((IEditorInput)input);
    }

    private static boolean openEditor(IEditorInput input) {
        IEditorPart part = null;
        try {
            part = PDEPlugin.getActivePage().openEditor(input, "org.eclipse.pde.ui.schemaEditor");
        }
        catch (PartInitException partInitException) {
            Display.getDefault().beep();
            return false;
        }
        if (part == null) {
            Display.getDefault().beep();
            return false;
        }
        return true;
    }

    public static boolean openSchema(File jarFile, String schemaJarFileEntry) {
        ZipFile zipFile;
        if (jarFile == null || !jarFile.exists()) {
            Display.getDefault().beep();
            return false;
        }
        try {
            zipFile = new ZipFile(jarFile);
        }
        catch (ZipException zipException) {
            Display.getDefault().beep();
            return false;
        }
        catch (IOException iOException) {
            Display.getDefault().beep();
            return false;
        }
        if (schemaJarFileEntry == null || zipFile.getEntry(schemaJarFileEntry) == null) {
            Display.getDefault().beep();
            return false;
        }
        JarEntryFile storage = new JarEntryFile(zipFile, schemaJarFileEntry);
        JarEntryEditorInput input = new JarEntryEditorInput(storage);
        return SchemaEditor.openEditor((IEditorInput)input);
    }

    public static void openToElement(IPath path, ISchemaElement element) {
        if (SchemaEditor.openSchema(path)) {
            IEditorPart editorPart = PDEPlugin.getActivePage().getActiveEditor();
            if (!(editorPart instanceof SchemaEditor)) {
                return;
            }
            SchemaEditor schemaEditor = (SchemaEditor)editorPart;
            schemaEditor.selectReveal(element);
        }
    }
}

