/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import java.util.ArrayList;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.schema.Schema;
import org.eclipse.pde.internal.core.schema.SchemaElement;
import org.eclipse.pde.internal.core.schema.SchemaElementReference;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.schema.AbstractSchemaDetails;
import org.eclipse.pde.internal.ui.editor.schema.ElementSection;
import org.eclipse.pde.internal.ui.parts.ComboPart;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SchemaElementDetails
extends AbstractSchemaDetails {
    private SchemaElement fElement;
    private FormEntry fName;
    private ComboPart fLabelProperty;
    private ComboPart fIcon;
    private Button fDepTrue;
    private Button fDepFalse;
    private Button fTransTrue;
    private Button fTransFalse;

    public SchemaElementDetails(ElementSection section) {
        super(section, true);
    }

    public void createDetails(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Color foreground = toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE");
        this.fName = new FormEntry(parent, toolkit, PDEUIMessages.SchemaDetails_name, 0);
        Label label = toolkit.createLabel(parent, PDEUIMessages.SchemaDetails_deprecated);
        label.setForeground(foreground);
        Button[] buttons = this.createTrueFalseButtons(parent, toolkit, 2);
        this.fDepTrue = buttons[0];
        this.fDepFalse = buttons[1];
        label = toolkit.createLabel(parent, PDEUIMessages.SchemaElementDetails_labelProperty);
        label.setForeground(foreground);
        this.fLabelProperty = this.createComboPart(parent, toolkit, new String[0], 2);
        label = toolkit.createLabel(parent, PDEUIMessages.SchemaElementDetails_icon);
        label.setForeground(foreground);
        this.fIcon = this.createComboPart(parent, toolkit, new String[0], 2);
        label = toolkit.createLabel(parent, PDEUIMessages.SchemaDetails_translatable);
        label.setForeground(foreground);
        buttons = this.createTrueFalseButtons(parent, toolkit, 2);
        this.fTransTrue = buttons[0];
        this.fTransFalse = buttons[1];
        this.setText(PDEUIMessages.SchemaElementDetails_title);
    }

    public void updateFields(ISchemaObject object) {
        if (object instanceof SchemaElementReference) {
            object = ((SchemaElementReference)object).getReferencedObject();
        }
        this.fElement = (SchemaElement)object;
        if (this.fElement == null) {
            return;
        }
        this.setDecription(NLS.bind((String)PDEUIMessages.SchemaElementDetails_description, (Object)this.fElement.getName()));
        this.fName.setValue(this.fElement.getName(), true);
        String labProp = this.fElement.getLabelProperty();
        this.fLabelProperty.setItems(this.getLabelItems());
        this.fLabelProperty.setText(labProp != null ? labProp : "");
        String icProp = this.fElement.getIconProperty();
        this.fIcon.setItems(this.getIconItems());
        this.fIcon.setText(icProp != null ? icProp : "");
        this.fDepTrue.setSelection(this.fElement.isDeprecated());
        this.fDepFalse.setSelection(!this.fElement.isDeprecated());
        this.fTransTrue.setSelection(this.fElement.hasTranslatableContent());
        this.fTransFalse.setSelection(!this.fElement.hasTranslatableContent());
        boolean editable = this.isEditableElement();
        this.fIcon.setEnabled(editable);
        this.fLabelProperty.setEnabled(editable);
        this.fName.setEditable(editable);
        this.fDepTrue.setEnabled(editable);
        this.fDepFalse.setEnabled(editable);
        this.fTransTrue.setEnabled(editable);
        this.fTransFalse.setEnabled(editable);
    }

    public void hookListeners() {
        this.fIcon.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SchemaElementDetails.this.blockListeners()) {
                    return;
                }
                String icon = SchemaElementDetails.this.fIcon.getSelection();
                if (icon == null || icon.equals("")) {
                    SchemaElementDetails.this.fElement.setIconProperty(null);
                } else {
                    SchemaElementDetails.this.fElement.setIconProperty(icon);
                }
            }
        });
        this.fLabelProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SchemaElementDetails.this.blockListeners()) {
                    return;
                }
                String label = SchemaElementDetails.this.fLabelProperty.getSelection();
                if (label == null || label.equals("")) {
                    SchemaElementDetails.this.fElement.setLabelProperty(null);
                } else {
                    SchemaElementDetails.this.fElement.setLabelProperty(label);
                }
            }
        });
        this.fName.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry entry) {
                if (SchemaElementDetails.this.blockListeners()) {
                    return;
                }
                SchemaElementDetails.this.fElement.setName(SchemaElementDetails.this.fName.getValue());
                ((Schema)SchemaElementDetails.this.fElement.getSchema()).updateReferencesFor((ISchemaElement)SchemaElementDetails.this.fElement, 3);
                SchemaElementDetails.this.setDecription(NLS.bind((String)PDEUIMessages.SchemaElementDetails_description, (Object)SchemaElementDetails.this.fElement.getName()));
            }
        });
        this.fDepTrue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SchemaElementDetails.this.blockListeners()) {
                    return;
                }
                SchemaElementDetails.this.fElement.setDeprecatedProperty(SchemaElementDetails.this.fDepTrue.getSelection());
            }
        });
        this.fTransTrue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SchemaElementDetails.this.blockListeners()) {
                    return;
                }
                SchemaElementDetails.this.fElement.setTranslatableProperty(SchemaElementDetails.this.fTransTrue.getSelection());
            }
        });
    }

    private String[] getIconItems() {
        ISchemaAttribute[] attribs = this.fElement.getAttributes();
        ArrayList<String> list = new ArrayList<String>();
        list.add("");
        int i = 0;
        while (i < attribs.length) {
            if (attribs[i].getKind() == 2) {
                list.add(attribs[i].getName());
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    private String[] getLabelItems() {
        ISchemaAttribute[] attribs = this.fElement.getAttributes();
        String[] labels = new String[attribs.length + 1];
        labels[0] = "";
        int i = 0;
        while (i < attribs.length) {
            labels[i + 1] = attribs[i].getName();
            ++i;
        }
        return labels;
    }

    public void modelChanged(IModelChangedEvent event) {
        Object[] changedObjs = event.getChangedObjects();
        if (event.getChangeType() == 1 && changedObjs.length > 0 && changedObjs[0] instanceof SchemaElement) {
            this.fName.getText().setFocus();
        }
        super.modelChanged(event);
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
        this.fName.commit();
    }
}

