/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.schema.SchemaElementReference;
import org.eclipse.pde.internal.core.schema.SchemaRootElement;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.schema.AbstractSchemaDetails;
import org.eclipse.pde.internal.ui.editor.schema.ElementSection;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SchemaRootElementDetails
extends AbstractSchemaDetails {
    private SchemaRootElement fElement;
    private FormEntry fName;
    private Button fDepTrue;
    private Button fDepFalse;
    private FormEntry fSuggestion;

    public SchemaRootElementDetails(ElementSection section) {
        super(section, true);
    }

    public void createDetails(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Color foreground = toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE");
        this.fName = new FormEntry(parent, toolkit, PDEUIMessages.SchemaDetails_name, 0);
        Label label = toolkit.createLabel(parent, PDEUIMessages.SchemaDetails_deprecated);
        label.setForeground(foreground);
        Button[] buttons = this.createTrueFalseButtons(parent, toolkit, 2);
        this.fDepTrue = buttons[0];
        this.fDepFalse = buttons[1];
        this.fSuggestion = new FormEntry(parent, toolkit, PDEUIMessages.SchemaRootElementDetails_replacement, null, false, 6);
        this.setText(PDEUIMessages.SchemaElementDetails_title);
    }

    public void updateFields(ISchemaObject element) {
        if (!(element instanceof ISchemaElement)) {
            return;
        }
        if (element instanceof SchemaElementReference) {
            element = ((SchemaElementReference)element).getReferencedObject();
        }
        this.fElement = (SchemaRootElement)element;
        if (this.fElement == null) {
            return;
        }
        this.setDecription(NLS.bind((String)PDEUIMessages.SchemaElementDetails_description, (Object)this.fElement.getName()));
        this.fName.setValue(this.fElement.getName(), true);
        this.fDepTrue.setSelection(this.fElement.isDeprecated());
        this.fDepFalse.setSelection(!this.fElement.isDeprecated());
        this.fSuggestion.setValue(this.fElement.getDeprecatedSuggestion(), true);
        this.fName.setEditable(this.isEditable());
        this.fDepTrue.setEnabled(this.isEditable());
        this.fDepFalse.setEnabled(this.isEditable());
        if (!this.fElement.isDeprecated()) {
            this.fSuggestion.getLabel().setEnabled(false);
            this.fSuggestion.getText().setEditable(false);
        } else {
            this.fSuggestion.setEditable(this.isEditable());
        }
    }

    public void hookListeners() {
        this.fName.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry entry) {
                if (SchemaRootElementDetails.this.blockListeners()) {
                    return;
                }
                SchemaRootElementDetails.this.fElement.setName(SchemaRootElementDetails.this.fName.getValue());
                SchemaRootElementDetails.this.setDecription(NLS.bind((String)PDEUIMessages.SchemaElementDetails_description, (Object)SchemaRootElementDetails.this.fElement.getName()));
            }
        });
        this.fDepTrue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SchemaRootElementDetails.this.blockListeners()) {
                    return;
                }
                boolean deprecated = SchemaRootElementDetails.this.fDepTrue.getSelection();
                SchemaRootElementDetails.this.fElement.setDeprecatedProperty(deprecated);
                SchemaRootElementDetails.this.fSuggestion.getLabel().setEnabled(deprecated);
                SchemaRootElementDetails.this.fSuggestion.getText().setEditable(deprecated);
            }
        });
        this.fSuggestion.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry entry) {
                if (SchemaRootElementDetails.this.blockListeners()) {
                    return;
                }
                SchemaRootElementDetails.this.fElement.setDeprecatedSuggestion(SchemaRootElementDetails.this.fSuggestion.getValue());
            }
        });
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
        this.fName.commit();
        this.fSuggestion.commit();
    }
}

