/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import java.io.File;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.pde.internal.core.isite.ISiteObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.pde.internal.ui.editor.MultiSourceEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.SystemFileEditorInput;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.site.ArchivePage;
import org.eclipse.pde.internal.ui.editor.site.FeaturesPage;
import org.eclipse.pde.internal.ui.editor.site.SiteInputContext;
import org.eclipse.pde.internal.ui.editor.site.SiteInputContextManager;
import org.eclipse.pde.internal.ui.editor.site.SiteOutlinePage;
import org.eclipse.pde.internal.ui.editor.site.SiteSourcePage;
import org.eclipse.pde.internal.ui.editor.site.SiteUndoManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;

public class SiteEditor
extends MultiSourceEditor {
    static /* synthetic */ Class class$0;

    protected String getEditorID() {
        return "org.eclipse.pde.ui.siteEditor";
    }

    protected void createResourceContexts(InputContextManager manager, IFileEditorInput input) {
        IFile file = input.getFile();
        IFile siteFile = null;
        String name = file.getName().toLowerCase(Locale.ENGLISH);
        if (name.equals("site.xml")) {
            siteFile = file;
            if (siteFile.exists()) {
                FileEditorInput in = new FileEditorInput(siteFile);
                manager.putContext((IEditorInput)in, new SiteInputContext(this, (IEditorInput)in, file == siteFile));
            }
            manager.monitorFile(siteFile);
        }
    }

    protected InputContextManager createInputContextManager() {
        SiteInputContextManager contextManager = new SiteInputContextManager(this);
        contextManager.setUndoManager(new SiteUndoManager(this));
        return contextManager;
    }

    public void monitoredFileAdded(IFile file) {
    }

    public boolean monitoredFileRemoved(IFile file) {
        return true;
    }

    public void editorContextAdded(InputContext context) {
        this.addSourcePage(context.getId());
    }

    public void contextRemoved(InputContext context) {
        this.close(false);
    }

    protected void createSystemFileContexts(InputContextManager manager, SystemFileEditorInput input) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.io.File");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        File file = (File)input.getAdapter(clazz);
        File siteFile = null;
        String name = file.getName().toLowerCase(Locale.ENGLISH);
        if (name.equals("site.xml") && (siteFile = file).exists()) {
            SystemFileEditorInput in = new SystemFileEditorInput(siteFile);
            manager.putContext((IEditorInput)in, new SiteInputContext(this, (IEditorInput)in, file == siteFile));
        }
    }

    protected void createStorageContexts(InputContextManager manager, IStorageEditorInput input) {
        String name = input.getName().toLowerCase(Locale.ENGLISH);
        if (name.startsWith("site.xml")) {
            manager.putContext((IEditorInput)input, new SiteInputContext(this, (IEditorInput)input, true));
        }
    }

    protected void contextMenuAboutToShow(IMenuManager manager) {
        super.contextMenuAboutToShow(manager);
    }

    protected void addEditorPages() {
        try {
            this.addPage((IFormPage)new FeaturesPage(this));
            this.addPage((IFormPage)new ArchivePage(this));
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
        this.addSourcePage("site-context");
    }

    protected String computeInitialPageId() {
        return "features";
    }

    protected PDESourcePage createSourcePage(PDEFormEditor editor, String title, String name, String contextId) {
        return new SiteSourcePage(editor, title, name);
    }

    protected ISortableContentOutlinePage createContentOutline() {
        return new SiteOutlinePage(this);
    }

    protected InputContext getInputContext(Object object) {
        InputContext context = null;
        if (object instanceof ISiteObject) {
            context = this.fInputContextManager.findContext("site-context");
        }
        return context;
    }
}

