/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.target;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.pde.internal.core.LoadTargetOperation;
import org.eclipse.pde.internal.core.itarget.ITarget;
import org.eclipse.pde.internal.core.itarget.ITargetModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.target.TargetErrorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.progress.IProgressService;

public abstract class AbstractTargetPage
extends PDEFormPage {
    public AbstractTargetPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected void createFormContent(final IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        ControlContribution save = new ControlContribution("Set"){

            protected Control createControl(Composite parent) {
                ImageHyperlink hyperlink = new ImageHyperlink(parent, 0);
                hyperlink.setText(PDEUIMessages.AbstractTargetPage_setTarget);
                hyperlink.setUnderlined(true);
                hyperlink.setForeground(managedForm.getToolkit().getHyperlinkGroup().getForeground());
                hyperlink.addHyperlinkListener(new IHyperlinkListener(this, hyperlink, managedForm){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ ImageHyperlink val$hyperlink;
                    private final /* synthetic */ IManagedForm val$managedForm;
                    {
                        this.this$1 = var1_1;
                        this.val$hyperlink = imageHyperlink;
                        this.val$managedForm = iManagedForm;
                    }

                    public void linkActivated(HyperlinkEvent e) {
                        AbstractTargetPage.access$0(1.access$0(this.this$1));
                    }

                    public void linkEntered(HyperlinkEvent e) {
                        this.val$hyperlink.setForeground(this.val$managedForm.getToolkit().getHyperlinkGroup().getActiveForeground());
                    }

                    public void linkExited(HyperlinkEvent e) {
                        this.val$hyperlink.setForeground(this.val$managedForm.getToolkit().getHyperlinkGroup().getForeground());
                    }
                });
                return hyperlink;
            }

            static /* synthetic */ AbstractTargetPage access$0(1 var0) {
                return var0.AbstractTargetPage.this;
            }
        };
        form.getToolBarManager().add((IContributionItem)save);
        form.getToolBarManager().update(true);
        super.createFormContent(managedForm);
    }

    private void doLoadTarget() {
        IRunnableWithProgress run = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    ITargetModel model = AbstractTargetPage.this.getTargetModel();
                    if (!model.isLoaded()) {
                        MessageDialog.openError((Shell)AbstractTargetPage.this.getManagedForm().getForm().getShell(), (String)PDEUIMessages.TargetPlatformPreferencePage_invalidTitle, (String)PDEUIMessages.TargetPlatformPreferencePage_invalidDescription);
                        monitor.done();
                        return;
                    }
                    try {
                        LoadTargetOperation op = new LoadTargetOperation(AbstractTargetPage.this.getTarget(), AbstractTargetPage.this.getFilePath());
                        PDEPlugin.getWorkspace().run((IWorkspaceRunnable)op, monitor);
                        Object[] features = op.getMissingFeatures();
                        Object[] plugins = op.getMissingPlugins();
                        if (plugins.length + features.length > 0) {
                            TargetErrorDialog.showDialog(AbstractTargetPage.this.getManagedForm().getForm().getShell(), features, plugins);
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCanceledException e) {
                        throw new InterruptedException(e.getMessage());
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            service.runInUI((IRunnableContext)service, run, (ISchedulingRule)PDEPlugin.getWorkspace().getRoot());
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
    }

    private ITarget getTarget() {
        return this.getTargetModel().getTarget();
    }

    private ITargetModel getTargetModel() {
        return (ITargetModel)this.getPDEEditor().getAggregateModel();
    }

    private IPath getFilePath() {
        IFile file;
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput && (file = ((IFileEditorInput)input).getFile()) != null) {
            return file.getFullPath();
        }
        return null;
    }

    static /* synthetic */ void access$0(AbstractTargetPage abstractTargetPage) {
        abstractTargetPage.doLoadTarget();
    }
}

