/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.target;

import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.itarget.IEnvironmentInfo;
import org.eclipse.pde.internal.core.itarget.ITarget;
import org.eclipse.pde.internal.core.itarget.ITargetModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.parts.ComboPart;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class EnvironmentSection
extends PDESection {
    private ComboPart fOSCombo;
    private ComboPart fWSCombo;
    private ComboPart fNLCombo;
    private ComboPart fArchCombo;
    private TreeSet fNLChoices;
    private TreeSet fOSChoices;
    private TreeSet fWSChoices;
    private TreeSet fArchChoices;
    private boolean LOCALES_INITIALIZED = false;

    public EnvironmentSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128);
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        section.setText(PDEUIMessages.EnvironmentSection_title);
        section.setDescription(PDEUIMessages.EnvironmentSection_description);
        GridData data = new GridData(768);
        data.verticalAlignment = 128;
        data.horizontalSpan = 2;
        section.setLayoutData((Object)data);
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(true, 2));
        client.setLayoutData((Object)new GridData(768));
        Composite left = toolkit.createComposite(client);
        left.setLayout((Layout)new GridLayout(2, false));
        GridLayout layout = FormLayoutFactory.createClearGridLayout(false, 2);
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        left.setLayout((Layout)layout);
        left.setLayoutData((Object)new GridData(768));
        IEnvironmentInfo orgEnv = this.getEnvironment();
        this.initializeChoices(orgEnv);
        Label label = toolkit.createLabel(left, PDEUIMessages.EnvironmentSection_operationSystem);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.fOSCombo = new ComboPart();
        this.fOSCombo.createControl(left, toolkit, 2052);
        this.fOSCombo.getControl().setLayoutData((Object)new GridData(768));
        this.fOSCombo.setItems(this.fOSChoices.toArray(new String[this.fOSChoices.size()]));
        label = toolkit.createLabel(left, PDEUIMessages.EnvironmentSection_windowingSystem);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.fWSCombo = new ComboPart();
        this.fWSCombo.createControl(left, toolkit, 2052);
        this.fWSCombo.getControl().setLayoutData((Object)new GridData(768));
        this.fWSCombo.setItems(this.fWSChoices.toArray(new String[this.fWSChoices.size()]));
        Composite right = toolkit.createComposite(client);
        layout = FormLayoutFactory.createClearGridLayout(false, 2);
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        right.setLayout((Layout)layout);
        right.setLayoutData((Object)new GridData(768));
        label = toolkit.createLabel(right, PDEUIMessages.EnvironmentSection_architecture);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.fArchCombo = new ComboPart();
        this.fArchCombo.createControl(right, toolkit, 2052);
        this.fArchCombo.getControl().setLayoutData((Object)new GridData(768));
        this.fArchCombo.setItems(this.fArchChoices.toArray(new String[this.fArchChoices.size()]));
        label = toolkit.createLabel(right, PDEUIMessages.EnvironmentSection_locale);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.fNLCombo = new ComboPart();
        this.fNLCombo.createControl(right, toolkit, 2308);
        this.fNLCombo.getControl().setLayoutData((Object)new GridData(768));
        this.fNLCombo.setItems(this.fNLChoices.toArray(new String[this.fNLChoices.size()]));
        this.refresh();
        this.fOSCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EnvironmentSection.this.getEnvironment().setOS(EnvironmentSection.this.getText(EnvironmentSection.this.fOSCombo));
            }
        });
        this.fWSCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EnvironmentSection.this.getEnvironment().setWS(EnvironmentSection.this.getText(EnvironmentSection.this.fWSCombo));
            }
        });
        this.fArchCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EnvironmentSection.this.getEnvironment().setArch(EnvironmentSection.this.getText(EnvironmentSection.this.fArchCombo));
            }
        });
        this.fNLCombo.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent event) {
                if (!EnvironmentSection.this.LOCALES_INITIALIZED) {
                    try {
                        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(this){
                            final /* synthetic */ 4 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run(IProgressMonitor monitor) {
                                EnvironmentSection.access$6(4.access$0(this.this$1));
                                EnvironmentSection.access$7(4.access$0(this.this$1), true);
                            }
                        });
                    }
                    catch (InvocationTargetException e) {
                        PDEPlugin.log(e);
                    }
                    catch (InterruptedException e) {
                        PDEPlugin.log(e);
                    }
                }
                if (EnvironmentSection.this.fNLCombo.getItemCount() < 3) {
                    String current = EnvironmentSection.this.fNLCombo.getSelection();
                    if (!EnvironmentSection.this.fNLCombo.getControl().isDisposed()) {
                        EnvironmentSection.this.fNLCombo.setItems(EnvironmentSection.this.fNLChoices.toArray(new String[EnvironmentSection.this.fNLChoices.size()]));
                        EnvironmentSection.this.fNLCombo.setText(current);
                    }
                    EnvironmentSection.this.fNLCombo.addModifyListener(new ModifyListener(this){
                        final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void modifyText(ModifyEvent e) {
                            String value = EnvironmentSection.access$2(4.access$0(this.this$1), EnvironmentSection.access$8(4.access$0(this.this$1)));
                            int index = value.indexOf("-");
                            if (index > 0) {
                                value = value.substring(0, index);
                            }
                            EnvironmentSection.access$0(4.access$0(this.this$1)).setNL(value.trim());
                        }
                    });
                }
            }

            static /* synthetic */ EnvironmentSection access$0(4 var0) {
                return var0.EnvironmentSection.this;
            }
        });
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
        this.getModel().addModelChangedListener((IModelChangedListener)this);
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleModelEventWorldChanged(e);
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        this.refresh();
    }

    public void dispose() {
        ITargetModel model = this.getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    private void initializeChoices(IEnvironmentInfo orgEnv) {
        this.fOSChoices = new TreeSet();
        String[] os = Platform.knownOSValues();
        int i = 0;
        while (i < os.length) {
            this.fOSChoices.add(os[i]);
            ++i;
        }
        this.fOSChoices.add("");
        String fileValue = orgEnv.getOS();
        if (fileValue != null) {
            this.fOSChoices.add(fileValue);
        }
        this.fWSChoices = new TreeSet();
        String[] ws = Platform.knownWSValues();
        int i2 = 0;
        while (i2 < ws.length) {
            this.fWSChoices.add(ws[i2]);
            ++i2;
        }
        this.fWSChoices.add("");
        fileValue = orgEnv.getWS();
        if (fileValue != null) {
            this.fWSChoices.add(fileValue);
        }
        this.fArchChoices = new TreeSet();
        String[] arch = Platform.knownOSArchValues();
        int i3 = 0;
        while (i3 < arch.length) {
            this.fArchChoices.add(arch[i3]);
            ++i3;
        }
        this.fArchChoices.add("");
        fileValue = orgEnv.getArch();
        if (fileValue != null) {
            this.fArchChoices.add(fileValue);
        }
        this.fNLChoices = new TreeSet();
        this.fNLChoices.add("");
    }

    private void initializeAllLocales() {
        String[] nl = EnvironmentSection.getLocales();
        int i = 0;
        while (i < nl.length) {
            this.fNLChoices.add(nl[i]);
            ++i;
        }
        String fileValue = this.getEnvironment().getNL();
        if (fileValue != null) {
            this.fNLChoices.add(this.expandLocaleName(fileValue));
        }
        this.LOCALES_INITIALIZED = true;
    }

    private static String[] getLocales() {
        Locale[] locales = Locale.getAvailableLocales();
        String[] result = new String[locales.length];
        int i = 0;
        while (i < locales.length) {
            Locale locale = locales[i];
            StringBuffer buffer = new StringBuffer();
            buffer.append(locale.toString());
            buffer.append(" - ");
            buffer.append(locale.getDisplayName());
            result[i] = buffer.toString();
            ++i;
        }
        return result;
    }

    private String expandLocaleName(String name) {
        String language = "";
        String country = "";
        String variant = "";
        StringTokenizer tokenizer = new StringTokenizer(name, "_");
        if (tokenizer.hasMoreTokens()) {
            language = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            country = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            variant = tokenizer.nextToken();
        }
        Locale locale = new Locale(language, country, variant);
        return String.valueOf(locale.toString()) + " - " + locale.getDisplayName();
    }

    private String getText(ComboPart combo) {
        Control control = combo.getControl();
        if (control instanceof Combo) {
            return ((Combo)control).getText();
        }
        return ((CCombo)control).getText();
    }

    private IEnvironmentInfo getEnvironment() {
        IEnvironmentInfo info = this.getTarget().getEnvironment();
        if (info == null) {
            info = this.getModel().getFactory().createEnvironment();
            this.getTarget().setEnvironment(info);
        }
        return info;
    }

    private ITarget getTarget() {
        return this.getModel().getTarget();
    }

    private ITargetModel getModel() {
        return (ITargetModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    public void refresh() {
        IEnvironmentInfo orgEnv = this.getEnvironment();
        String presetValue = orgEnv.getOS() == null ? "" : orgEnv.getOS();
        this.fOSCombo.setText(presetValue);
        presetValue = orgEnv.getWS() == null ? "" : orgEnv.getWS();
        this.fWSCombo.setText(presetValue);
        presetValue = orgEnv.getArch() == null ? "" : orgEnv.getArch();
        this.fArchCombo.setText(presetValue);
        presetValue = orgEnv.getNL() == null ? "" : this.expandLocaleName(orgEnv.getNL());
        this.fNLCombo.setText(presetValue);
        super.refresh();
    }

    protected void updateChoices() {
        if (this.LOCALES_INITIALIZED) {
            return;
        }
        if (this.getModel() == null) {
            return;
        }
        new Thread(new Runnable(){

            public void run() {
                EnvironmentSection.this.initializeAllLocales();
            }
        }).start();
    }

    static /* synthetic */ void access$7(EnvironmentSection environmentSection, boolean bl) {
        environmentSection.LOCALES_INITIALIZED = bl;
    }
}

