/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.target;

import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.itarget.ILocationInfo;
import org.eclipse.pde.internal.core.itarget.ITarget;
import org.eclipse.pde.internal.core.itarget.ITargetModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.target.TargetEditor;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class TargetDefinitionSection
extends PDESection {
    private FormEntry fNameEntry;
    private FormEntry fPath;
    private Button fUseDefault;
    private Button fCustomPath;
    private Button fFileSystem;
    private Button fVariable;
    private static int NUM_COLUMNS = 5;

    public TargetDefinitionSection(PDEFormPage page, Composite parent) {
        super(page, parent, 256);
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearTableWrapLayout(false, 1));
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, NUM_COLUMNS));
        IActionBars actionBars = this.getPage().getPDEEditor().getEditorSite().getActionBars();
        this.createNameEntry(client, toolkit, actionBars);
        this.createLocation(client, toolkit, actionBars);
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
        section.setText(PDEUIMessages.TargetDefinitionSection_title);
        TableWrapData data = new TableWrapData(256);
        data.colspan = 2;
        section.setLayoutData((Object)data);
        this.getModel().addModelChangedListener((IModelChangedListener)this);
    }

    public void dispose() {
        ITargetModel model = this.getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleModelEventWorldChanged(e);
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        this.refresh();
        this.getPage().setLastFocusControl((Control)this.fNameEntry.getText());
    }

    private void createNameEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        this.fNameEntry = new FormEntry(client, toolkit, PDEUIMessages.TargetDefinitionSection_name, null, false);
        this.fNameEntry.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            public void textValueChanged(FormEntry entry) {
                TargetDefinitionSection.this.getTarget().setName(entry.getValue());
            }
        });
        GridData gd = (GridData)this.fNameEntry.getText().getLayoutData();
        gd.horizontalSpan = 4;
        this.fNameEntry.setEditable(this.isEditable());
    }

    private void createLocation(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        Label label = toolkit.createLabel(client, PDEUIMessages.TargetDefinitionSection_targetLocation);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.fUseDefault = toolkit.createButton(client, PDEUIMessages.TargetDefinitionSection_sameAsHost, 16);
        GridData gd = new GridData();
        gd.horizontalSpan = 5;
        gd.horizontalIndent = 15;
        this.fUseDefault.setLayoutData((Object)gd);
        this.fUseDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TargetDefinitionSection.this.fUseDefault.getSelection()) {
                    TargetDefinitionSection.this.fPath.getText().setEditable(false);
                    TargetDefinitionSection.this.fPath.setValue("", true);
                    TargetDefinitionSection.this.fFileSystem.setEnabled(false);
                    TargetDefinitionSection.this.fVariable.setEnabled(false);
                    TargetDefinitionSection.this.getLocationInfo().setDefault(true);
                }
            }
        });
        this.fCustomPath = toolkit.createButton(client, PDEUIMessages.TargetDefinitionSection_location, 16);
        gd = new GridData();
        gd.horizontalIndent = 15;
        this.fCustomPath.setLayoutData((Object)gd);
        this.fCustomPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TargetDefinitionSection.this.fCustomPath.getSelection()) {
                    ILocationInfo info = TargetDefinitionSection.this.getLocationInfo();
                    TargetDefinitionSection.this.fPath.getText().setEditable(true);
                    TargetDefinitionSection.this.fPath.setValue(info.getPath(), true);
                    TargetDefinitionSection.this.fFileSystem.setEnabled(true);
                    TargetDefinitionSection.this.fVariable.setEnabled(true);
                    info.setDefault(false);
                }
            }
        });
        this.fPath = new FormEntry(client, toolkit, null, null, false);
        this.fPath.getText().setLayoutData((Object)new GridData(768));
        this.fPath.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            public void textValueChanged(FormEntry entry) {
                TargetDefinitionSection.this.getLocationInfo().setPath(TargetDefinitionSection.this.fPath.getValue());
            }
        });
        this.fFileSystem = toolkit.createButton(client, PDEUIMessages.TargetDefinitionSection_fileSystem, 8);
        this.fFileSystem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetDefinitionSection.this.handleBrowseFileSystem();
            }
        });
        this.fVariable = toolkit.createButton(client, PDEUIMessages.TargetDefinitionSection_variables, 8);
        this.fVariable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetDefinitionSection.this.handleInsertVariable();
            }
        });
    }

    public void commit(boolean onSave) {
        this.fNameEntry.commit();
        this.fPath.commit();
        super.commit(onSave);
    }

    public void cancelEdit() {
        this.fNameEntry.cancelEdit();
        this.fPath.cancelEdit();
        super.cancelEdit();
    }

    public void refresh() {
        ITarget target = this.getTarget();
        this.fNameEntry.setValue(target.getName(), true);
        ILocationInfo info = this.getLocationInfo();
        this.fUseDefault.setSelection(info.useDefault());
        this.fCustomPath.setSelection(!info.useDefault());
        String path = info.useDefault() ? "" : info.getPath();
        this.fPath.setValue(path, true);
        this.fPath.getText().setEditable(!info.useDefault());
        this.fFileSystem.setEnabled(!info.useDefault());
        this.fVariable.setEnabled(!info.useDefault());
        super.refresh();
    }

    public boolean canPaste(Clipboard clipboard) {
        Display d = this.getSection().getDisplay();
        Control c = d.getFocusControl();
        return c instanceof Text;
    }

    protected void handleBrowseFileSystem() {
        DirectoryDialog dialog = new DirectoryDialog(this.getSection().getShell());
        String text = this.fPath.getValue();
        if (text.length() == 0) {
            text = TargetEditor.LAST_PATH;
        }
        dialog.setFilterPath(text);
        dialog.setText(PDEUIMessages.BaseBlock_dirSelection);
        dialog.setMessage(PDEUIMessages.BaseBlock_dirChoose);
        String result = dialog.open();
        if (result != null) {
            this.fPath.setValue(result);
            this.getLocationInfo().setPath(result);
            TargetEditor.LAST_PATH = result;
        }
    }

    private void handleInsertVariable() {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(PDEPlugin.getActiveWorkbenchShell());
        if (dialog.open() == 0) {
            this.fPath.getText().insert(dialog.getVariableExpression());
            this.fPath.setValue(this.fPath.getText().getText());
            this.getLocationInfo().setPath(this.fPath.getText().getText());
        }
    }

    private ILocationInfo getLocationInfo() {
        ILocationInfo info = this.getTarget().getLocationInfo();
        if (info == null) {
            info = this.getModel().getFactory().createLocation();
            this.getTarget().setLocationInfo(info);
        }
        return info;
    }

    private ITarget getTarget() {
        return this.getModel().getTarget();
    }

    private ITargetModel getModel() {
        return (ITargetModel)this.getPage().getPDEEditor().getAggregateModel();
    }
}

