/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.text;

import java.util.Hashtable;
import java.util.Locale;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.text.IDocumentAttribute;
import org.eclipse.pde.internal.core.text.IDocumentNode;
import org.eclipse.pde.internal.core.text.IDocumentRange;
import org.eclipse.pde.internal.core.text.IDocumentTextNode;
import org.eclipse.pde.internal.core.util.PDEJavaHelper;
import org.eclipse.pde.internal.ui.PDEPlugin;

public abstract class XMLUtil {
    /*
     * Unable to fully structure code
     */
    public static IPluginObject getTopLevelParent(IDocumentRange range) {
        block3: {
            block2: {
                block1: {
                    node = null;
                    if (!(range instanceof IDocumentAttribute)) break block1;
                    node = ((IDocumentAttribute)range).getEnclosingElement();
                    ** GOTO lbl17
                }
                if (!(range instanceof IDocumentTextNode)) break block2;
                node = ((IDocumentTextNode)range).getEnclosingElement();
                ** GOTO lbl17
            }
            if (!(range instanceof IPluginElement)) break block3;
            node = (IDocumentNode)range;
            ** GOTO lbl17
        }
        if (!(range instanceof IPluginObject)) ** GOTO lbl17
        return (IPluginObject)range;
lbl-1000:
        // 1 sources

        {
            node = node.getParentNode();
lbl17:
            // 5 sources

            ** while (node != null && !(node instanceof IPluginExtension) && !(node instanceof IPluginExtensionPoint))
        }
lbl18:
        // 1 sources

        return node != null ? (IPluginObject)node : null;
    }

    private static boolean withinRange(int start, int len, int offset) {
        return start <= offset && offset <= start + len;
    }

    public static boolean withinRange(IDocumentRange range, int offset) {
        if (range instanceof IDocumentAttribute) {
            return XMLUtil.withinRange(((IDocumentAttribute)range).getValueOffset(), ((IDocumentAttribute)range).getValueLength(), offset);
        }
        if (range instanceof IDocumentNode) {
            return XMLUtil.withinRange(((IDocumentNode)range).getOffset(), ((IDocumentNode)range).getLength(), offset);
        }
        if (range instanceof IDocumentTextNode) {
            return XMLUtil.withinRange(((IDocumentTextNode)range).getOffset(), ((IDocumentTextNode)range).getLength(), offset);
        }
        return false;
    }

    public static ISchemaElement getSchemaElement(IDocumentNode node, String extensionPoint) {
        ISchema schema;
        if (extensionPoint == null) {
            IPluginObject obj = XMLUtil.getTopLevelParent((IDocumentRange)node);
            if (!(obj instanceof IPluginExtension)) {
                return null;
            }
            extensionPoint = ((IPluginExtension)obj).getPoint();
        }
        if ((schema = PDECore.getDefault().getSchemaRegistry().getSchema(extensionPoint)) == null) {
            return null;
        }
        ISchemaElement sElement = schema.findElement(node.getXMLTagName());
        return sElement;
    }

    public static ISchemaAttribute getSchemaAttribute(IDocumentAttribute attr, String extensionPoint) {
        ISchemaElement ele = XMLUtil.getSchemaElement(attr.getEnclosingElement(), extensionPoint);
        if (ele == null) {
            return null;
        }
        return ele.getAttribute(attr.getAttributeName());
    }

    public static String createDefaultClassName(IProject project, ISchemaAttribute attInfo, int counter) {
        String tag = attInfo.getParent().getName();
        String expectedType = attInfo.getBasedOn();
        String className = "";
        if (expectedType == null) {
            StringBuffer buf = new StringBuffer(tag);
            buf.setCharAt(0, Character.toUpperCase(tag.charAt(0)));
            className = buf.toString();
        } else {
            className = expectedType;
            int dotLoc = className.lastIndexOf(46);
            if (dotLoc != -1) {
                className = className.substring(dotLoc + 1);
            }
            if (className.length() > 2 && className.charAt(0) == 'I' && Character.isUpperCase(className.charAt(1))) {
                className = className.substring(1);
            }
        }
        String packageName = XMLUtil.createDefaultPackageName(project, className);
        className = String.valueOf(className) + counter;
        return String.valueOf(packageName) + "." + className;
    }

    public static String createDefaultPackageName(IProject project, String className) {
        IStatus status;
        String id = project.getName();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < id.length()) {
            char ch = id.charAt(i);
            if (buffer.length() == 0) {
                if (Character.isJavaIdentifierStart(ch)) {
                    buffer.append(Character.toLowerCase(ch));
                }
            } else if (Character.isJavaIdentifierPart(ch)) {
                buffer.append(ch);
            } else if (ch == '.') {
                status = JavaConventions.validatePackageName((String)buffer.toString(), (String)PDEJavaHelper.getJavaSourceLevel((IProject)project), (String)PDEJavaHelper.getJavaComplianceLevel((IProject)project));
                if (status.getSeverity() == 4) {
                    buffer.append(className.toLowerCase(Locale.ENGLISH));
                }
                buffer.append(ch);
            }
            ++i;
        }
        status = JavaConventions.validatePackageName((String)buffer.toString(), (String)PDEJavaHelper.getJavaSourceLevel((IProject)project), (String)PDEJavaHelper.getJavaComplianceLevel((IProject)project));
        if (status.getSeverity() == 4) {
            buffer.append(className.toLowerCase(Locale.ENGLISH));
        }
        return buffer.toString();
    }

    public static String createDefaultName(IProject project, ISchemaAttribute attInfo, int counter) {
        if (attInfo.getType().getName().equals("boolean")) {
            return "true";
        }
        String tag = attInfo.getParent().getName();
        return String.valueOf(project.getName()) + "." + tag + counter;
    }

    public static int getCounterValue(ISchemaElement elementInfo) {
        String counterKey;
        Hashtable counters = PDEPlugin.getDefault().getDefaultNameCounters();
        Integer counter = (Integer)counters.get(counterKey = XMLUtil.getCounterKey(elementInfo));
        counter = counter == null ? new Integer(1) : new Integer(counter + 1);
        counters.put(counterKey, counter);
        return counter;
    }

    public static String getCounterKey(ISchemaElement elementInfo) {
        return String.valueOf(elementInfo.getSchema().getQualifiedPointId()) + "." + elementInfo.getName();
    }
}

