/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.DependencyManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.elements.NamedElement;
import org.eclipse.pde.internal.ui.launcher.LaunchValidationOperation;
import org.eclipse.pde.internal.ui.launcher.PluginStatusDialog;
import org.eclipse.pde.internal.ui.util.PersistablePluginObject;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.ui.launcher.AbstractLauncherTab;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;

public abstract class AbstractPluginBlock {
    protected AbstractLauncherTab fTab;
    protected CheckboxTreeViewer fPluginTreeViewer;
    protected NamedElement fWorkspacePlugins;
    protected NamedElement fExternalPlugins;
    protected IPluginModelBase[] fExternalModels;
    protected IPluginModelBase[] fWorkspaceModels;
    protected int fNumExternalChecked;
    protected int fNumWorkspaceChecked;
    private Button fIncludeOptionalButton;
    protected Button fAddWorkspaceButton;
    private Button fAutoValidate;
    private Button fSelectAllButton;
    private Button fDeselectButton;
    private Button fWorkingSetButton;
    private Button fAddRequiredButton;
    private Button fDefaultsButton;
    private Listener fListener = new Listener();
    private Label fCounter;
    private LaunchValidationOperation fOperation;
    private PluginStatusDialog fDialog;
    private Button fValidateButton;

    public AbstractPluginBlock(AbstractLauncherTab tab) {
        this.fTab = tab;
        PDEPlugin.getDefault().getLabelProvider().connect(this);
        this.fExternalModels = this.getExternalModels();
        this.fWorkspaceModels = PluginRegistry.getWorkspaceModels();
    }

    protected IPluginModelBase[] getExternalModels() {
        Preferences pref = PDECore.getDefault().getPluginPreferences();
        String saved = pref.getString("checkedPlugins");
        if (saved.equals("[savedNone]")) {
            return new IPluginModelBase[0];
        }
        IPluginModelBase[] models = PluginRegistry.getExternalModels();
        if (saved.equals("[savedAll]")) {
            return models;
        }
        ArrayList<IPluginModelBase> list = new ArrayList<IPluginModelBase>(models.length);
        int i = 0;
        while (i < models.length) {
            if (models[i].isEnabled()) {
                list.add(models[i]);
            }
            ++i;
        }
        return list.toArray(new IPluginModelBase[list.size()]);
    }

    protected void updateCounter() {
        if (this.fCounter != null) {
            int checked = this.fNumExternalChecked + this.fNumWorkspaceChecked;
            int total = this.fWorkspaceModels.length + this.fExternalModels.length;
            this.fCounter.setText(NLS.bind((String)PDEUIMessages.AbstractPluginBlock_counter, (Object)new Integer(checked), (Object)new Integer(total)));
        }
    }

    public void createControl(Composite parent, int span, int indent) {
        this.createPluginViewer(parent, span - 1, indent);
        this.createButtonContainer(parent);
        this.fIncludeOptionalButton = this.createButton(parent, span, indent, NLS.bind((String)PDEUIMessages.AdvancedLauncherTab_includeOptional, (Object)this.fTab.getName().toLowerCase(Locale.ENGLISH)));
        this.fAddWorkspaceButton = this.createButton(parent, span, indent, NLS.bind((String)PDEUIMessages.AdvancedLauncherTab_addNew, (Object)this.fTab.getName().toLowerCase(Locale.ENGLISH)));
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        Label label = new Label(parent, 258);
        label.setLayoutData((Object)gd);
        this.fAutoValidate = this.createButton(parent, span - 1, indent, NLS.bind((String)PDEUIMessages.PluginsTabToolBar_auto_validate, (Object)this.fTab.getName().replaceAll("&", "").toLowerCase(Locale.ENGLISH)));
        this.fValidateButton = new Button(parent, 8);
        this.fValidateButton.setLayoutData((Object)new GridData(128));
        this.fValidateButton.setText(NLS.bind((String)PDEUIMessages.PluginsTabToolBar_validate, (Object)this.fTab.getName().replaceAll("&", "")));
        SWTUtil.setButtonDimensionHint(this.fValidateButton);
        this.fValidateButton.addSelectionListener((SelectionListener)this.fListener);
    }

    private Button createButton(Composite parent, int span, int indent, String text) {
        Button button = new Button(parent, 32);
        button.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        gd.horizontalIndent = indent;
        button.setLayoutData((Object)gd);
        button.addSelectionListener((SelectionListener)this.fListener);
        return button;
    }

    protected ILabelProvider getLabelProvider() {
        return PDEPlugin.getDefault().getLabelProvider();
    }

    protected void createPluginViewer(Composite composite, int span, int indent) {
        this.fPluginTreeViewer = new CheckboxTreeViewer(composite, this.getTreeViewerStyle());
        this.fPluginTreeViewer.setContentProvider((IContentProvider)new PluginContentProvider());
        this.fPluginTreeViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.fPluginTreeViewer.setAutoExpandLevel(2);
        this.fPluginTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof IPluginModelBase) {
                    AbstractPluginBlock.this.handleCheckStateChanged(event);
                } else {
                    AbstractPluginBlock.this.handleGroupStateChanged(element, event.getChecked());
                }
                AbstractPluginBlock.this.fTab.updateLaunchConfigurationDialog();
            }
        });
        this.fPluginTreeViewer.setComparator((ViewerComparator)new ListUtil.PluginComparator(){

            public int category(Object obj) {
                if (obj == AbstractPluginBlock.this.fWorkspacePlugins) {
                    return -1;
                }
                return 0;
            }
        });
        GridData gd = new GridData(1808);
        gd.horizontalSpan = span;
        gd.horizontalIndent = indent;
        this.fPluginTreeViewer.getTree().setLayoutData((Object)gd);
        Image siteImage = PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_SITE_OBJ);
        this.fWorkspacePlugins = new NamedElement(PDEUIMessages.AdvancedLauncherTab_workspacePlugins, siteImage);
        this.fExternalPlugins = new NamedElement(PDEUIMessages.PluginsTab_target, siteImage);
    }

    private void createButtonContainer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1040));
        new Label(composite, 0);
        this.fSelectAllButton = this.createButton(composite, PDEUIMessages.AdvancedLauncherTab_selectAll);
        this.fDeselectButton = this.createButton(composite, PDEUIMessages.AdvancedLauncherTab_deselectAll);
        this.fWorkingSetButton = this.createButton(composite, PDEUIMessages.AdvancedLauncherTab_workingSet);
        this.fAddRequiredButton = this.createButton(composite, NLS.bind((String)PDEUIMessages.AdvancedLauncherTab_subset, (Object)this.fTab.getName()));
        this.fDefaultsButton = this.createButton(composite, PDEUIMessages.AdvancedLauncherTab_defaults);
        this.fCounter = new Label(composite, 0);
        this.fCounter.setLayoutData((Object)new GridData(1816));
        this.updateCounter();
    }

    protected int getTreeViewerStyle() {
        return 2048;
    }

    private Button createButton(Composite composite, String text) {
        Button button = new Button(composite, 8);
        button.setText(text);
        button.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(button);
        button.addSelectionListener((SelectionListener)this.fListener);
        return button;
    }

    protected void handleCheckStateChanged(CheckStateChangedEvent event) {
        IPluginModelBase model = (IPluginModelBase)event.getElement();
        if (model.getUnderlyingResource() == null) {
            this.fNumExternalChecked = event.getChecked() ? ++this.fNumExternalChecked : --this.fNumExternalChecked;
        } else {
            this.fNumWorkspaceChecked = event.getChecked() ? ++this.fNumWorkspaceChecked : --this.fNumWorkspaceChecked;
        }
        this.adjustGroupState();
    }

    protected void handleGroupStateChanged(Object group, boolean checked) {
        this.fPluginTreeViewer.setSubtreeChecked(group, checked);
        this.fPluginTreeViewer.setGrayed(group, false);
        if (group == this.fWorkspacePlugins) {
            this.fNumWorkspaceChecked = checked ? this.fWorkspaceModels.length : 0;
        } else if (group == this.fExternalPlugins) {
            this.fNumExternalChecked = checked ? this.fExternalModels.length : 0;
        }
    }

    protected void toggleGroups(boolean select) {
        this.handleGroupStateChanged(this.fWorkspacePlugins, select);
        this.handleGroupStateChanged(this.fExternalPlugins, select);
    }

    private void handleWorkingSets() {
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSetSelectionDialog dialog = workingSetManager.createWorkingSetSelectionDialog(this.getShell(), true);
        if (dialog.open() == 0) {
            String[] ids = this.getPluginIDs(dialog.getSelection());
            int i = 0;
            while (i < ids.length) {
                IPluginModelBase model = PluginRegistry.findModel((String)ids[i]);
                if (model != null && !this.fPluginTreeViewer.getChecked((Object)model)) {
                    this.setChecked(model, true);
                    if (model.getUnderlyingResource() == null) {
                        ++this.fNumExternalChecked;
                    } else {
                        ++this.fNumWorkspaceChecked;
                    }
                }
                ++i;
            }
            this.adjustGroupState();
        }
    }

    protected void setChecked(IPluginModelBase model, boolean checked) {
        this.fPluginTreeViewer.setChecked((Object)model, checked);
    }

    private String[] getPluginIDs(IWorkingSet[] workingSets) {
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < workingSets.length) {
            IAdaptable[] elements = workingSets[i].getElements();
            int j = 0;
            while (j < elements.length) {
                IAdaptable element = elements[j];
                if (element instanceof PersistablePluginObject) {
                    set.add(((PersistablePluginObject)element).getPluginID());
                } else {
                    IPluginModelBase model;
                    if (element instanceof IJavaProject) {
                        element = ((IJavaProject)element).getProject();
                    }
                    if (element instanceof IProject && (model = PluginRegistry.findModel((IProject)((IProject)element))) != null) {
                        set.add(model.getPluginBase().getId());
                    }
                }
                ++j;
            }
            ++i;
        }
        return set.toArray(new String[set.size()]);
    }

    public void initializeFrom(ILaunchConfiguration config) throws CoreException {
        this.fIncludeOptionalButton.setSelection(config.getAttribute("includeOptional", true));
        this.fAddWorkspaceButton.setSelection(config.getAttribute("automaticAdd", true));
        this.fAutoValidate.setSelection(config.getAttribute("automaticValidate", false));
        if (this.fPluginTreeViewer.getInput() == null) {
            this.fPluginTreeViewer.setUseHashlookup(true);
            this.fPluginTreeViewer.setInput((Object)PDEPlugin.getDefault());
            this.fPluginTreeViewer.reveal((Object)this.fWorkspacePlugins);
        }
    }

    protected void computeSubset() {
        Object[] checked = this.fPluginTreeViewer.getCheckedElements();
        ArrayList<Object> toCheck = new ArrayList<Object>(checked.length);
        int i = 0;
        while (i < checked.length) {
            if (checked[i] instanceof IPluginModelBase) {
                toCheck.add(checked[i]);
            }
            ++i;
        }
        Set additionalIds = DependencyManager.getDependencies((Object[])checked, (boolean)this.fIncludeOptionalButton.getSelection());
        Iterator it = additionalIds.iterator();
        while (it.hasNext()) {
            IPluginModelBase model;
            ModelEntry entry;
            String id = (String)it.next();
            if (this.findPlugin(id) != null || (entry = PluginRegistry.findEntry((String)id)) == null || (model = entry.getModel()) == null) continue;
            toCheck.add(model);
        }
        checked = toCheck.toArray();
        this.setCheckedElements(checked);
        this.fNumExternalChecked = 0;
        this.fNumWorkspaceChecked = 0;
        int i2 = 0;
        while (i2 < checked.length) {
            if (((IPluginModelBase)checked[i2]).getUnderlyingResource() != null) {
                ++this.fNumWorkspaceChecked;
            } else {
                ++this.fNumExternalChecked;
            }
            ++i2;
        }
        this.adjustGroupState();
    }

    protected void setCheckedElements(Object[] checked) {
        this.fPluginTreeViewer.setCheckedElements(checked);
    }

    protected IPluginModelBase findPlugin(String id) {
        ModelEntry entry = PluginRegistry.findEntry((String)id);
        if (entry != null) {
            IPluginModelBase model = entry.getModel();
            if (this.fPluginTreeViewer.getChecked((Object)model)) {
                return model;
            }
            IPluginModelBase[] models = entry.getWorkspaceModels();
            int i = 0;
            while (i < models.length) {
                if (this.fPluginTreeViewer.getChecked((Object)models[i])) {
                    return models[i];
                }
                ++i;
            }
            models = entry.getExternalModels();
            i = 0;
            while (i < models.length) {
                if (this.fPluginTreeViewer.getChecked((Object)models[i])) {
                    return models[i];
                }
                ++i;
            }
            return null;
        }
        return null;
    }

    protected void adjustGroupState() {
        this.fPluginTreeViewer.setChecked((Object)this.fExternalPlugins, this.fNumExternalChecked > 0);
        this.fPluginTreeViewer.setGrayed((Object)this.fExternalPlugins, this.fNumExternalChecked > 0 && this.fNumExternalChecked < this.fExternalModels.length);
        this.fPluginTreeViewer.setChecked((Object)this.fWorkspacePlugins, this.fNumWorkspaceChecked > 0);
        this.fPluginTreeViewer.setGrayed((Object)this.fWorkspacePlugins, this.fNumWorkspaceChecked > 0 && this.fNumWorkspaceChecked < this.fWorkspaceModels.length);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("includeOptional", this.fIncludeOptionalButton.getSelection());
        config.setAttribute("automaticAdd", this.fAddWorkspaceButton.getSelection());
        config.setAttribute("automaticValidate", this.fAutoValidate.getSelection());
        this.savePluginState(config);
        this.updateCounter();
    }

    protected abstract void savePluginState(ILaunchConfigurationWorkingCopy var1);

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("includeOptional", true);
        config.setAttribute("automaticAdd", true);
        config.setAttribute("automaticValidate", false);
    }

    public void enableViewer(boolean enable) {
        this.fPluginTreeViewer.getTree().setEnabled(enable);
        this.fAddRequiredButton.setEnabled(enable);
        this.fDefaultsButton.setEnabled(enable);
        this.fWorkingSetButton.setEnabled(enable);
        this.fSelectAllButton.setEnabled(enable);
        this.fDeselectButton.setEnabled(enable);
        this.fIncludeOptionalButton.setEnabled(enable);
        this.fAddWorkspaceButton.setEnabled(enable);
        this.fCounter.setEnabled(enable);
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect(this);
    }

    protected boolean isEnabled() {
        return this.fPluginTreeViewer.getTree().isEnabled();
    }

    protected void handleRestoreDefaults() {
        IPluginModelBase model;
        TreeSet<String> wtable = new TreeSet<String>();
        this.fNumWorkspaceChecked = 0;
        this.fNumExternalChecked = 0;
        int i = 0;
        while (i < this.fWorkspaceModels.length) {
            model = this.fWorkspaceModels[i];
            ++this.fNumWorkspaceChecked;
            String id = model.getPluginBase().getId();
            if (id != null) {
                wtable.add(model.getPluginBase().getId());
            }
            ++i;
        }
        this.fPluginTreeViewer.setSubtreeChecked((Object)this.fWorkspacePlugins, true);
        this.fNumExternalChecked = 0;
        i = 0;
        while (i < this.fExternalModels.length) {
            model = this.fExternalModels[i];
            boolean masked = wtable.contains(model.getPluginBase().getId());
            if (!masked && model.isEnabled()) {
                this.fPluginTreeViewer.setChecked((Object)model, true);
                ++this.fNumExternalChecked;
            }
            ++i;
        }
        this.adjustGroupState();
    }

    protected Shell getShell() {
        try {
            Control c = this.fTab.getControl();
            if (!c.isDisposed()) {
                return c.getShell();
            }
        }
        catch (SWTException sWTException) {}
        return PDEPlugin.getActiveWorkbenchShell();
    }

    public void handleValidate() {
        if (this.fOperation == null) {
            this.fOperation = this.createValidationOperation();
        }
        try {
            this.fOperation.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            PDEPlugin.log(e);
        }
        if (this.fDialog == null) {
            if (this.fOperation.hasErrors()) {
                this.fDialog = new PluginStatusDialog(this.getShell(), 2160);
                this.fDialog.setInput(this.fOperation.getInput());
                this.fDialog.open();
                this.fDialog = null;
            } else if (this.fOperation.isEmpty()) {
                MessageDialog.openInformation((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.PluginStatusDialog_pluginValidation, (String)NLS.bind((String)PDEUIMessages.AbstractLauncherToolbar_noSelection, (Object)this.fTab.getName().toLowerCase(Locale.ENGLISH)));
            } else {
                MessageDialog.openInformation((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.PluginStatusDialog_pluginValidation, (String)PDEUIMessages.AbstractLauncherToolbar_noProblems);
            }
        } else {
            this.fDialog.refresh(this.fOperation.getInput());
        }
    }

    protected abstract LaunchValidationOperation createValidationOperation();

    class Listener
    extends SelectionAdapter {
        Listener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == AbstractPluginBlock.this.fSelectAllButton) {
                AbstractPluginBlock.this.toggleGroups(true);
            } else if (source == AbstractPluginBlock.this.fDeselectButton) {
                AbstractPluginBlock.this.toggleGroups(false);
            } else if (source == AbstractPluginBlock.this.fWorkingSetButton) {
                AbstractPluginBlock.this.handleWorkingSets();
            } else if (source == AbstractPluginBlock.this.fAddRequiredButton) {
                AbstractPluginBlock.this.computeSubset();
            } else if (source == AbstractPluginBlock.this.fDefaultsButton) {
                AbstractPluginBlock.this.handleRestoreDefaults();
            } else if (source == AbstractPluginBlock.this.fValidateButton) {
                AbstractPluginBlock.this.handleValidate();
            }
            AbstractPluginBlock.this.fTab.updateLaunchConfigurationDialog();
        }
    }

    class PluginContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        PluginContentProvider() {
        }

        public boolean hasChildren(Object parent) {
            return !(parent instanceof IPluginModelBase);
        }

        public Object[] getChildren(Object parent) {
            if (parent == AbstractPluginBlock.this.fExternalPlugins) {
                return AbstractPluginBlock.this.fExternalModels;
            }
            if (parent == AbstractPluginBlock.this.fWorkspacePlugins) {
                return AbstractPluginBlock.this.fWorkspaceModels;
            }
            return new Object[0];
        }

        public Object getParent(Object child) {
            if (child instanceof IPluginModelBase) {
                IResource resource = ((IPluginModelBase)child).getUnderlyingResource();
                return resource == null ? AbstractPluginBlock.this.fExternalPlugins : AbstractPluginBlock.this.fWorkspacePlugins;
            }
            return null;
        }

        public Object[] getElements(Object input) {
            ArrayList<NamedElement> list = new ArrayList<NamedElement>();
            if (AbstractPluginBlock.this.fWorkspaceModels.length > 0) {
                list.add(AbstractPluginBlock.this.fWorkspacePlugins);
            }
            if (AbstractPluginBlock.this.fExternalModels.length > 0) {
                list.add(AbstractPluginBlock.this.fExternalPlugins);
            }
            return list.toArray();
        }
    }
}

