/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.launcher.BaseBlock;
import org.eclipse.pde.internal.ui.util.FileNameFilter;
import org.eclipse.pde.ui.launcher.AbstractLauncherTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ConfigurationTemplateBlock
extends BaseBlock {
    private Button fGenerateFileButton;
    private Button fUseTemplateButton;

    public ConfigurationTemplateBlock(AbstractLauncherTab tab) {
        super(tab);
    }

    public void createControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(PDEUIMessages.ConfigurationTab_configFileGroup);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        this.fGenerateFileButton = new Button((Composite)group, 16);
        this.fGenerateFileButton.setText(PDEUIMessages.ConfigurationTab_defaultConfigIni);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.fGenerateFileButton.setLayoutData((Object)gd);
        this.fGenerateFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationTemplateBlock.this.enableBrowseSection(!ConfigurationTemplateBlock.this.fGenerateFileButton.getSelection());
            }
        });
        this.fUseTemplateButton = new Button((Composite)group, 16);
        this.fUseTemplateButton.setText(PDEUIMessages.ConfigurationTab_existingConfigIni);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fUseTemplateButton.setLayoutData((Object)gd);
        this.createText((Composite)group, PDEUIMessages.ConfigurationTab_templateLoc, 20);
        Composite buttons = new Composite((Composite)group, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttons.setLayout((Layout)layout);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        buttons.setLayoutData((Object)gd);
        Label label = new Label(buttons, 0);
        label.setLayoutData((Object)new GridData(768));
        this.createButtons(buttons, new String[]{PDEUIMessages.BaseBlock_workspaceS, PDEUIMessages.BaseBlock_filesystemS, PDEUIMessages.BaseBlock_variablesS});
    }

    public void initializeFrom(ILaunchConfiguration configuration) throws CoreException {
        boolean generateDefault = configuration.getAttribute("useDefaultConfig", true);
        this.fGenerateFileButton.setSelection(generateDefault);
        this.fUseTemplateButton.setSelection(!generateDefault);
        this.enableBrowseSection(!generateDefault);
        this.fLocationText.setText(configuration.getAttribute("templateConfig", ""));
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("useDefaultConfig", this.fGenerateFileButton.getSelection());
        if (!this.fGenerateFileButton.getSelection()) {
            configuration.setAttribute("templateConfig", this.fLocationText.getText().trim());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("useDefaultConfig", true);
        configuration.setAttribute("templateConfig", "${target_home}" + File.separatorChar + "configuration" + File.separatorChar + "config.ini");
    }

    protected String getName() {
        return PDEUIMessages.ConfigurationTemplateBlock_name;
    }

    protected void handleBrowseWorkspace() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.fTab.getControl().getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        IFile file = this.getFile();
        if (file != null) {
            dialog.setInitialSelection((Object)file);
        }
        dialog.setInput((Object)PDEPlugin.getWorkspace().getRoot());
        dialog.addFilter((ViewerFilter)new FileNameFilter("config.ini"));
        dialog.setAllowMultiple(false);
        dialog.setTitle(PDEUIMessages.ConfigurationTab_fileSelection);
        dialog.setMessage(PDEUIMessages.ConfigurationTab_fileDialogMessage);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length > 0 && selection[0] instanceof IFile) {
                    return new Status(0, PDEPlugin.getPluginId(), 0, "", null);
                }
                return new Status(4, PDEPlugin.getPluginId(), 4, "", null);
            }
        });
        if (dialog.open() == 0) {
            file = (IFile)dialog.getFirstResult();
            this.fLocationText.setText("${workspace_loc:" + file.getFullPath().makeRelative() + "}");
        }
    }

    protected IFile getFile() {
        String path = this.getLocation();
        if (path.length() > 0) {
            IResource res = null;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if (path.startsWith("${workspace_loc:")) {
                IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
                try {
                    path = manager.performStringSubstitution(path, false);
                    IFile[] containers = root.findFilesForLocation((IPath)new Path(path));
                    if (containers.length > 0) {
                        res = containers[0];
                    }
                }
                catch (CoreException coreException) {}
            } else {
                res = root.findMember(path);
            }
            if (res instanceof IFile) {
                return (IFile)res;
            }
        }
        return null;
    }

    protected void handleBrowseFileSystem() {
        FileDialog dialog = new FileDialog(this.fTab.getControl().getShell());
        dialog.setFilterExtensions(new String[]{"*.ini"});
        dialog.setFilterPath(this.getLocation());
        dialog.setText(PDEUIMessages.ConfigurationTab_configLocMessage);
        String res = dialog.open();
        if (res != null) {
            this.fLocationText.setText(res);
        }
    }

    protected String getLocation() {
        String path = this.fLocationText.getText().trim();
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        try {
            return manager.performStringSubstitution(path, false);
        }
        catch (CoreException coreException) {
            return path;
        }
    }
}

