/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.SearchablePluginsManager;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.ui.launcher.LaunchValidationOperation;
import org.eclipse.pde.internal.ui.launcher.LauncherUtils;
import org.eclipse.pde.internal.ui.launcher.PluginStatusDialog;
import org.eclipse.swt.widgets.Display;

public class LaunchPluginValidator {
    public static void checkBackwardCompatibility(ILaunchConfiguration configuration, boolean save) throws CoreException {
        boolean upgrade;
        String value2;
        ILaunchConfigurationWorkingCopy wc = null;
        wc = configuration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)configuration : configuration.getWorkingCopy();
        String value = configuration.getAttribute("wsproject", null);
        if (value != null) {
            wc.setAttribute("wsproject", null);
            if (value.indexOf(59) != -1) {
                value = value.replace(';', ',');
            } else if (value.indexOf(58) != -1) {
                value = value.replace(':', ',');
            }
            value = value.length() == 0 || value.equals(",") ? null : value.substring(0, value.length() - 1);
            boolean automatic = configuration.getAttribute("automaticAdd", true);
            String attr = automatic ? "deselected_workspace_plugins" : "selected_workspace_plugins";
            wc.setAttribute(attr, value);
        }
        if ((value2 = configuration.getAttribute("extplugins", null)) != null) {
            wc.setAttribute("extplugins", null);
            if (value2.indexOf(59) != -1) {
                value2 = value2.replace(';', ',');
            } else if (value2.indexOf(58) != -1) {
                value2 = value2.replace(':', ',');
            }
            value2 = value2.length() == 0 || value2.equals(",") ? null : value2.substring(0, value2.length() - 1);
            wc.setAttribute("selected_target_plugins", value2);
        }
        String version = configuration.getAttribute("pde.version", null);
        boolean newApp = TargetPlatformHelper.usesNewApplicationModel();
        boolean bl = upgrade = !"3.3".equals(version) && newApp;
        if (!upgrade) {
            boolean bl2 = upgrade = TargetPlatformHelper.getTargetVersion() >= 3.2 && version == null;
        }
        if (upgrade) {
            wc.setAttribute("pde.version", newApp ? "3.3" : "3.2a");
            boolean usedefault = configuration.getAttribute("default", true);
            boolean useFeatures = configuration.getAttribute("usefeatures", false);
            boolean automaticAdd = configuration.getAttribute("automaticAdd", true);
            if (!usedefault && !useFeatures) {
                ArrayList<String> list = new ArrayList<String>();
                if (version == null) {
                    list.add("org.eclipse.core.contenttype");
                    list.add("org.eclipse.core.jobs");
                    list.add("org.eclipse.equinox.common");
                    list.add("org.eclipse.equinox.preferences");
                    list.add("org.eclipse.equinox.registry");
                    list.add("org.eclipse.core.runtime.compatibility.registry");
                }
                if (!"3.3".equals(version) && newApp) {
                    list.add("org.eclipse.equinox.app");
                }
                StringBuffer extensions = new StringBuffer(configuration.getAttribute("selected_workspace_plugins", ""));
                StringBuffer target = new StringBuffer(configuration.getAttribute("selected_target_plugins", ""));
                int i = 0;
                while (i < list.size()) {
                    String plugin = list.get(i).toString();
                    IPluginModelBase model = PluginRegistry.findModel((String)plugin);
                    if (model != null) {
                        if (model.getUnderlyingResource() != null) {
                            if (!automaticAdd) {
                                if (extensions.length() > 0) {
                                    extensions.append(",");
                                }
                                extensions.append(plugin);
                            }
                        } else {
                            if (target.length() > 0) {
                                target.append(",");
                            }
                            target.append(plugin);
                        }
                    }
                    ++i;
                }
                if (extensions.length() > 0) {
                    wc.setAttribute("selected_workspace_plugins", extensions.toString());
                }
                if (target.length() > 0) {
                    wc.setAttribute("selected_target_plugins", target.toString());
                }
            }
        }
        if (save && (value != null || value2 != null || upgrade)) {
            wc.doSave();
        }
    }

    private static void addToMap(Map map, IPluginModelBase[] models) {
        int i = 0;
        while (i < models.length) {
            LaunchPluginValidator.addToMap(map, models[i]);
            ++i;
        }
    }

    private static void addToMap(Map map, IPluginModelBase model) {
        BundleDescription desc = model.getBundleDescription();
        if (desc != null) {
            String id = desc.getSymbolicName();
            if (!map.containsKey(id)) {
                map.put(id, model);
            } else {
                map.put(String.valueOf(id) + "_" + desc.getBundleId(), model);
            }
        }
    }

    private static IPluginModelBase[] getSelectedWorkspacePlugins(ILaunchConfiguration configuration) throws CoreException {
        boolean usedefault = configuration.getAttribute("default", true);
        boolean useFeatures = configuration.getAttribute("usefeatures", false);
        IPluginModelBase[] models = PluginRegistry.getWorkspaceModels();
        if (usedefault || useFeatures || models.length == 0) {
            return models;
        }
        ArrayList<IPluginModelBase> list = new ArrayList<IPluginModelBase>();
        if (configuration.getAttribute("automaticAdd", true)) {
            TreeSet deselected = LaunchPluginValidator.parsePlugins(configuration, "deselected_workspace_plugins");
            if (deselected.size() == 0) {
                return models;
            }
            int i = 0;
            while (i < models.length) {
                String id = models[i].getPluginBase().getId();
                if (id != null && !deselected.contains(id)) {
                    list.add(models[i]);
                }
                ++i;
            }
        } else {
            TreeSet selected = LaunchPluginValidator.parsePlugins(configuration, "selected_workspace_plugins");
            int i = 0;
            while (i < models.length) {
                String id = models[i].getPluginBase().getId();
                if (id != null && selected.contains(id)) {
                    list.add(models[i]);
                }
                ++i;
            }
        }
        return list.toArray(new IPluginModelBase[list.size()]);
    }

    public static TreeSet parsePlugins(ILaunchConfiguration configuration, String attribute) throws CoreException {
        TreeSet<String> set = new TreeSet<String>();
        String ids = configuration.getAttribute(attribute, null);
        if (ids != null) {
            StringTokenizer tok = new StringTokenizer(ids, ",");
            while (tok.hasMoreTokens()) {
                set.add(tok.nextToken());
            }
        }
        return set;
    }

    public static IPluginModelBase[] getPluginList(ILaunchConfiguration config) throws CoreException {
        Map map = LaunchPluginValidator.getPluginsToRun(config);
        return map.values().toArray(new IPluginModelBase[map.size()]);
    }

    public static Map getPluginsToRun(ILaunchConfiguration config) throws CoreException {
        LaunchPluginValidator.checkBackwardCompatibility(config, true);
        TreeMap map = new TreeMap();
        if (config.getAttribute("default", true)) {
            LaunchPluginValidator.addToMap(map, PluginRegistry.getActiveModels());
            return map;
        }
        if (config.getAttribute("usefeatures", false)) {
            LaunchPluginValidator.addToMap(map, PluginRegistry.getWorkspaceModels());
            return map;
        }
        LaunchPluginValidator.addToMap(map, LaunchPluginValidator.getSelectedWorkspacePlugins(config));
        TreeSet exModels = LaunchPluginValidator.parsePlugins(config, "selected_target_plugins");
        IPluginModelBase[] exmodels = PluginRegistry.getExternalModels();
        int i = 0;
        while (i < exmodels.length) {
            IPluginModelBase existing;
            String id = exmodels[i].getPluginBase().getId();
            if (id != null && exModels.contains(id) && ((existing = (IPluginModelBase)map.get(id)) == null || existing.getUnderlyingResource() == null)) {
                LaunchPluginValidator.addToMap(map, exmodels[i]);
            }
            ++i;
        }
        return map;
    }

    public static IProject[] getAffectedProjects(ILaunchConfiguration config) throws CoreException {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        IPluginModelBase[] models = LaunchPluginValidator.getSelectedWorkspacePlugins(config);
        int i = 0;
        while (i < models.length) {
            IProject project = models[i].getUnderlyingResource().getProject();
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                projects.add(project);
            }
            ++i;
        }
        SearchablePluginsManager manager = PDECore.getDefault().getSearchablePluginsManager();
        IJavaProject proxy = manager.getProxyProject();
        if (proxy != null) {
            projects.add(proxy.getProject());
        }
        return projects.toArray(new IProject[projects.size()]);
    }

    public static void runValidationOperation(final LaunchValidationOperation op, IProgressMonitor monitor) throws CoreException {
        op.run(monitor);
        if (op.hasErrors()) {
            final int[] result = new int[1];
            final Display display = LauncherUtils.getDisplay();
            display.syncExec(new Runnable(){

                public void run() {
                    PluginStatusDialog dialog = new PluginStatusDialog(display.getActiveShell());
                    dialog.showCancelButton(true);
                    dialog.setInput(op.getInput());
                    result[0] = dialog.open();
                }
            });
            if (result[0] == 1) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
        }
    }
}

