/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.DependencyManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.tools.OrganizeManifestsOperation;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class LauncherUtils {
    private static final String TIMESTAMP = "timestamp";
    private static final String FILE_NAME = "dep-timestamp.properties";
    private static Properties fLastRun;

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static final Shell getActiveShell() {
        IWorkbenchWindow window = PDEPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PDEPlugin.getDefault().getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                return windows[0].getShell();
            }
        } else {
            return window.getShell();
        }
        return LauncherUtils.getDisplay().getActiveShell();
    }

    public static boolean clearWorkspace(ILaunchConfiguration configuration, String workspace, IProgressMonitor monitor) throws CoreException {
        if (workspace.length() == 0) {
            monitor.done();
            return true;
        }
        File workspaceFile = new Path(workspace).toFile().getAbsoluteFile();
        if (configuration.getAttribute("clearws", false) && workspaceFile.exists()) {
            boolean doClear;
            boolean bl = doClear = !configuration.getAttribute("askclear", true);
            if (!doClear) {
                int result = LauncherUtils.confirmDeleteWorkspace(workspaceFile);
                if (result == 2 || result == -1) {
                    monitor.done();
                    return false;
                }
                boolean bl2 = doClear = result == 0;
            }
            if (doClear) {
                if (configuration.getAttribute("clearwslog", false)) {
                    LauncherUtils.clearWorkspaceLog(workspace);
                } else {
                    CoreUtility.deleteContent((File)workspaceFile);
                }
            }
        }
        monitor.done();
        return true;
    }

    private static int confirmDeleteWorkspace(File workspaceFile) {
        String message = NLS.bind((String)PDEUIMessages.WorkbenchLauncherConfigurationDelegate_confirmDeleteWorkspace, (Object)workspaceFile.getPath());
        return LauncherUtils.generateDialog(message);
    }

    public static boolean generateConfigIni() {
        String message = PDEUIMessages.LauncherUtils_generateConfigIni;
        return LauncherUtils.generateDialog(message) == 0;
    }

    private static int generateDialog(final String message) {
        final int[] result = new int[1];
        LauncherUtils.getDisplay().syncExec(new Runnable(){

            public void run() {
                String title = PDEUIMessages.LauncherUtils_title;
                MessageDialog dialog = new MessageDialog(LauncherUtils.getActiveShell(), title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                result[0] = dialog.open();
            }
        });
        return result[0];
    }

    public static void validateProjectDependencies(ILaunchConfiguration launch, final IProgressMonitor monitor) {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        if (!store.getBoolean("Preferences.MainPage.automanageDependencies")) {
            return;
        }
        try {
            String timeStamp = launch.getAttribute(TIMESTAMP, "0");
            String selected = launch.getAttribute("selected_workspace_plugins", "");
            String deSelected = launch.getAttribute("deselected_workspace_plugins", "");
            boolean autoAdd = launch.getAttribute("automaticAdd", true);
            boolean useDefault = launch.getAttribute("default", true);
            final ArrayList projects = new ArrayList();
            if (useDefault |= launch.getAttribute("usefeatures", false)) {
                LauncherUtils.handleUseDefault(timeStamp, projects);
            } else if (autoAdd) {
                LauncherUtils.handleDeselectedPlugins(timeStamp, deSelected, projects);
            } else {
                LauncherUtils.handleSelectedPlugins(timeStamp, selected, projects);
            }
            if (!projects.isEmpty()) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        OrganizeManifestsOperation op = new OrganizeManifestsOperation(projects);
                        op.setOperations(LauncherUtils.getSettings());
                        try {
                            op.run(monitor);
                            Properties table = LauncherUtils.getLastRun();
                            String ts = Long.toString(System.currentTimeMillis());
                            Iterator it = projects.iterator();
                            while (it.hasNext()) {
                                table.put(((IProject)it.next()).getName(), ts);
                            }
                        }
                        catch (InvocationTargetException invocationTargetException) {
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                });
            }
            ILaunchConfigurationWorkingCopy wc = null;
            wc = launch.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)launch : launch.getWorkingCopy();
            wc.setAttribute(TIMESTAMP, Long.toString(System.currentTimeMillis()));
            wc.doSave();
        }
        catch (CoreException coreException) {}
    }

    private static IDialogSettings getSettings() {
        DialogSettings settings = new DialogSettings("");
        settings.put("OrganizeManifests.ExportedPackages.addMissing", true);
        settings.put("OrganizeManifests.ExportedPackages.makeInternal", true);
        settings.put("OrganizeManifests.ExportedPackages.removeUnresolved", true);
        settings.put("OrganizeManifests.RequireImport.modifyDep", true);
        settings.put("OrganizeManifests.RequireImport.resolve:markOptional", true);
        settings.put("OrganizeManifests.General.cleanup", true);
        settings.put("OrganizeManifests.AddDependencies", true);
        return settings;
    }

    private static String getTimeStamp(IProject project) {
        IJavaProject jp = JavaCore.create((IProject)project);
        try {
            long timeStamp = 0L;
            IClasspathEntry[] entries = jp.getResolvedClasspath(true);
            int i = 0;
            while (i < entries.length) {
                if (entries[i].getEntryKind() == 3) {
                    IResource res;
                    IPath path;
                    IPath location = entries[i].getOutputLocation();
                    if (location == null) {
                        location = jp.getOutputLocation();
                    }
                    IPath iPath = path = (res = project.getWorkspace().getRoot().findMember(location)) == null ? null : res.getLocation();
                    if (path != null) {
                        File file = path.toFile();
                        Stack<File> files = new Stack<File>();
                        files.push(file);
                        while (!files.isEmpty()) {
                            file = (File)files.pop();
                            if (file.isDirectory()) {
                                File[] children = file.listFiles();
                                int j = 0;
                                while (j < children.length) {
                                    files.push(children[j]);
                                    ++j;
                                }
                                continue;
                            }
                            if (!file.getName().endsWith(".class") || timeStamp >= file.lastModified()) continue;
                            timeStamp = file.lastModified();
                        }
                    }
                }
                ++i;
            }
            String[] otherFiles = new String[]{"META-INF/MANIFEST.MF", "build.properties"};
            int i2 = 0;
            while (i2 < otherFiles.length) {
                long fileTimeStamp;
                IFile file = project.getFile(otherFiles[i2]);
                if (file != null && timeStamp < (fileTimeStamp = file.getRawLocation().toFile().lastModified())) {
                    timeStamp = fileTimeStamp;
                }
                ++i2;
            }
            return Long.toString(timeStamp);
        }
        catch (JavaModelException javaModelException) {
            return "0";
        }
    }

    private static void handleUseDefault(String launcherTimeStamp, ArrayList projects) {
        IProject[] projs = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projs.length) {
            String timestamp;
            if (WorkspaceModelManager.isPluginProject((IProject)projs[i]) && (timestamp = LauncherUtils.getTimeStamp(projs[i])).compareTo(launcherTimeStamp) > 0 && LauncherUtils.shouldAdd(projs[i], launcherTimeStamp, timestamp)) {
                projects.add(projs[i]);
            }
            ++i;
        }
    }

    private static void handleSelectedPlugins(String timeStamp, String value, ArrayList projects) {
        StringTokenizer tokenizer = new StringTokenizer(value, ",");
        while (tokenizer.hasMoreTokens()) {
            IProject project;
            String projTimeStamp;
            IResource res;
            value = tokenizer.nextToken();
            int index = value.indexOf(64);
            String id = index > 0 ? value.substring(0, index) : value;
            IPluginModelBase base = PluginRegistry.findModel((String)id);
            if (base == null || (res = base.getUnderlyingResource()) == null || (projTimeStamp = LauncherUtils.getTimeStamp(project = res.getProject())).compareTo(timeStamp) <= 0 || !LauncherUtils.shouldAdd(project, timeStamp, projTimeStamp)) continue;
            projects.add(project);
        }
    }

    private static void handleDeselectedPlugins(String launcherTimeStamp, String value, ArrayList projects) {
        StringTokenizer tokenizer = new StringTokenizer(value, ",");
        HashSet<String> deSelectedProjs = new HashSet<String>();
        while (tokenizer.hasMoreTokens()) {
            deSelectedProjs.add(tokenizer.nextToken());
        }
        IProject[] projs = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projs.length) {
            String timestamp;
            IPluginModelBase base;
            if (WorkspaceModelManager.isPluginProject((IProject)projs[i]) && (base = PluginRegistry.findModel((IProject)projs[i])) != null && (base == null || !deSelectedProjs.contains(base.getPluginBase().getId())) && (timestamp = LauncherUtils.getTimeStamp(projs[i])).compareTo(launcherTimeStamp) > 0 && LauncherUtils.shouldAdd(projs[i], launcherTimeStamp, timestamp)) {
                projects.add(projs[i]);
            }
            ++i;
        }
    }

    public static final void shutdown() {
        block15: {
            if (fLastRun == null) {
                return;
            }
            FileOutputStream stream = null;
            try {
                try {
                    stream = new FileOutputStream(new File(LauncherUtils.getDirectory(), FILE_NAME));
                    fLastRun.store(stream, "Cached timestamps");
                    stream.flush();
                    stream.close();
                }
                catch (IOException e) {
                    PDECore.logException((Throwable)e);
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException) {}
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static File getDirectory() {
        IPath path = PDECore.getDefault().getStateLocation().append(".cache");
        File directory = new File(path.toOSString());
        if (!directory.exists() || !directory.isDirectory()) {
            directory.mkdirs();
        }
        return directory;
    }

    private static Properties getLastRun() {
        block16: {
            if (fLastRun == null) {
                fLastRun = new Properties();
                FileInputStream fis = null;
                try {
                    try {
                        File file = new File(LauncherUtils.getDirectory(), FILE_NAME);
                        if (file.exists()) {
                            fis = new FileInputStream(file);
                            fLastRun.load(fis);
                            fis.close();
                        }
                    }
                    catch (IOException e) {
                        PDECore.logException((Throwable)e);
                        try {
                            if (fis != null) {
                                fis.close();
                            }
                            break block16;
                        }
                        catch (IOException iOException) {}
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return fLastRun;
    }

    private static boolean shouldAdd(IProject proj, String launcherTS, String fileSystemTS) {
        String projTS = (String)LauncherUtils.getLastRun().get(proj.getName());
        if (projTS == null) {
            return true;
        }
        return projTS.compareTo(launcherTS) < 0 || projTS.compareTo(fileSystemTS) < 0;
    }

    public static boolean requiresUI(ILaunchConfiguration configuration) {
        try {
            IPluginModelBase model;
            IResource project;
            String projectID = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
            if (projectID.length() > 0 && (project = PDEPlugin.getWorkspace().getRoot().findMember(projectID)) instanceof IProject && (model = PluginRegistry.findModel((IProject)((IProject)project))) != null) {
                Set plugins = DependencyManager.getSelfAndDependencies((IPluginModelBase)model);
                return plugins.contains("org.eclipse.swt");
            }
        }
        catch (CoreException coreException) {}
        return true;
    }

    public static boolean clearWorkspaceLog(String workspace) {
        File logFile = new File(workspace, ".metadata" + File.separator + ".log");
        if (logFile != null && logFile.exists()) {
            return logFile.delete();
        }
        return true;
    }

    public static IStatus createErrorStatus(String message) {
        return new Status(4, PDEPlugin.getPluginId(), 0, message, null);
    }
}

