/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.WorkspaceSourceContainer;
import org.eclipse.debug.ui.sourcelookup.WorkingSetSourceContainer;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.launching.sourcelookup.containers.JavaSourceLookupParticipant;
import org.eclipse.pde.internal.ui.launcher.PDESourceLookupQuery;

public class PDESourceLookupDirector
extends AbstractSourceLookupDirector {
    private static Set fFilteredTypes = new HashSet(3);

    static {
        fFilteredTypes.add(ProjectSourceContainer.TYPE_ID);
        fFilteredTypes.add(WorkspaceSourceContainer.TYPE_ID);
        fFilteredTypes.add(WorkingSetSourceContainer.TYPE_ID);
    }

    public void initializeParticipants() {
        this.addParticipants(new ISourceLookupParticipant[]{new JavaSourceLookupParticipant()});
    }

    public boolean supportsSourceContainerType(ISourceContainerType type) {
        return !fFilteredTypes.contains(type.getId());
    }

    public Object getSourceElement(Object element) {
        PDESourceLookupQuery query = new PDESourceLookupQuery(element);
        SafeRunner.run((ISafeRunnable)query);
        Object result = query.getResult();
        return result != null ? result : super.getSourceElement(element);
    }

    public Object[] findSourceElements(Object object) throws CoreException {
        Object[] sourceElements = null;
        if (object instanceof IJavaStackFrame || object instanceof IJavaObject || object instanceof IJavaReferenceType) {
            sourceElements = new Object[]{this.getSourceElement(object)};
        }
        if (sourceElements == null) {
            sourceElements = super.findSourceElements(object);
        }
        return sourceElements;
    }
}

