/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.nls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModel;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.ui.nls.ModelChange;
import org.eclipse.pde.internal.ui.nls.ModelChangeElement;
import org.eclipse.pde.internal.ui.nls.ModelChangeFile;
import org.eclipse.pde.internal.ui.nls.StringHelper;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ExternalizeStringsOperation
extends WorkspaceModifyOperation {
    private Object[] fChangeFiles;

    public ExternalizeStringsOperation(Object[] changeFiles) {
        this.fChangeFiles = changeFiles;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        int i = 0;
        while (i < this.fChangeFiles.length) {
            block10: {
                if (this.fChangeFiles[i] instanceof ModelChangeFile) {
                    ModelChangeFile changeFile = (ModelChangeFile)this.fChangeFiles[i];
                    ModelChange change = changeFile.getModel();
                    IFile pFile = change.getPropertiesFile();
                    ExternalizeStringsOperation.checkPropertiesFile(pFile);
                    if (!change.localizationSet()) {
                        this.addBundleLocalization(change, monitor);
                    }
                    ITextFileBufferManager pManager = FileBuffers.getTextFileBufferManager();
                    try {
                        pManager.connect(pFile.getFullPath(), monitor);
                        ITextFileBuffer pBuffer = pManager.getTextFileBuffer(pFile.getFullPath());
                        IDocument pDoc = pBuffer.getDocument();
                        MultiTextEdit pEdit = new MultiTextEdit();
                        this.doReplace(changeFile, pDoc, pEdit, monitor);
                        pEdit.apply(pDoc);
                        pBuffer.commit(monitor, true);
                    }
                    catch (MalformedTreeException malformedTreeException) {
                        pManager.disconnect(pFile.getFullPath(), monitor);
                        break block10;
                    }
                    catch (BadLocationException badLocationException) {
                        try {
                            break block10;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            pManager.disconnect(pFile.getFullPath(), monitor);
                        }
                    }
                    pManager.disconnect(pFile.getFullPath(), monitor);
                }
            }
            ++i;
        }
    }

    /*
     * Exception decompiling
     */
    private void doReplace(ModelChangeFile changeFile, IDocument pDoc, MultiTextEdit pEdit, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index: 0, Size: 0
         *     at java.base/java.util.LinkedList.checkElementIndex(LinkedList.java:566)
         *     at java.base/java.util.LinkedList.get(LinkedList.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.combineInlineable(Block.java:226)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:560)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredCatch.transformStructuredChildren(StructuredCatch.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.transformStructuredChildren(StructuredTry.java:129)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.transformStructuredChildren(StructuredTry.java:127)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.inlinePossibles(Op04StructuredStatement.java:709)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:855)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addBundleLocalization(ModelChange change, IProgressMonitor mon) {
        IPluginModelBase base = change.getParentModel();
        IFile manifest = base.getUnderlyingResource().getProject().getFile("META-INF/MANIFEST.MF");
        final String localiz = change.getBundleLocalization();
        PDEModelUtility.modifyModel(new ModelModification(manifest){

            protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                if (model instanceof IBundlePluginModel) {
                    IBundlePluginModel bundleModel = (IBundlePluginModel)model;
                    IBundle bundle = bundleModel.getBundleModel().getBundle();
                    bundle.setLocalization(localiz);
                }
            }
        }, mon);
    }

    public static InsertEdit getPropertiesInsertEdit(IDocument doc, ModelChangeElement element) {
        String nl = TextUtilities.getDefaultLineDelimiter((IDocument)doc);
        StringBuffer sb = new StringBuffer(nl);
        sb.append(element.getKey());
        sb.append(" = ");
        sb.append(StringHelper.preparePropertiesString(element.getValue(), nl.toCharArray()));
        return new InsertEdit(doc.getLength(), sb.toString());
    }

    public static void checkPropertiesFile(IFile file) {
        if (!file.exists()) {
            String propertiesFileComment = NLS.bind((String)"#Properties file for {0}", (Object)file.getProject().getName());
            ByteArrayInputStream pStream = new ByteArrayInputStream(propertiesFileComment.getBytes());
            try {
                IContainer container = file.getParent();
                if (!container.exists()) {
                    CoreUtility.createFolder((IFolder)((IFolder)container));
                }
                file.create((InputStream)pStream, true, (IProgressMonitor)new NullProgressMonitor());
                pStream.close();
            }
            catch (CoreException coreException) {
            }
            catch (IOException iOException) {}
        }
    }
}

