/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.parts;

import org.eclipse.pde.internal.ui.parts.SharedPart;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class SharedPartWithButtons
extends SharedPart {
    private String[] fButtonLabels;
    private Button[] fButtons;
    protected Composite fButtonContainer;

    public SharedPartWithButtons(String[] buttonLabels) {
        this.fButtonLabels = buttonLabels;
    }

    public void setButtonEnabled(int index, boolean enabled) {
        if (this.fButtons != null && index >= 0 && this.fButtons.length > index) {
            this.fButtons[index].setEnabled(enabled);
        }
    }

    protected abstract void createMainControl(Composite var1, int var2, int var3, FormToolkit var4);

    protected abstract void buttonSelected(Button var1, int var2);

    public void createControl(Composite parent, int style, int span, FormToolkit toolkit) {
        this.createMainLabel(parent, span, toolkit);
        this.createMainControl(parent, style, span - 1, toolkit);
        this.createButtons(parent, toolkit);
    }

    protected void createButtons(Composite parent, FormToolkit toolkit) {
        if (this.fButtonLabels != null && this.fButtonLabels.length > 0) {
            this.fButtonContainer = this.createComposite(parent, toolkit);
            GridData gd = new GridData(1040);
            this.fButtonContainer.setLayoutData((Object)gd);
            this.fButtonContainer.setLayout((Layout)this.createButtonsLayout());
            this.fButtons = new Button[this.fButtonLabels.length];
            SelectionHandler listener = new SelectionHandler();
            int i = 0;
            while (i < this.fButtonLabels.length) {
                String label = this.fButtonLabels[i];
                if (label != null) {
                    Button button = this.createButton(this.fButtonContainer, label, i, toolkit);
                    button.addSelectionListener((SelectionListener)listener);
                    this.fButtons[i] = button;
                } else {
                    this.createEmptySpace(this.fButtonContainer, 1, toolkit);
                }
                ++i;
            }
        }
    }

    protected GridLayout createButtonsLayout() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        return layout;
    }

    protected Button createButton(Composite parent, String label, int index, FormToolkit toolkit) {
        Button button;
        if (toolkit != null) {
            button = toolkit.createButton(parent, label, 8);
        } else {
            button = new Button(parent, 8);
            button.setText(label);
        }
        GridData gd = new GridData(770);
        button.setLayoutData((Object)gd);
        button.setData((Object)new Integer(index));
        return button;
    }

    protected void updateEnabledState() {
        int i = 0;
        while (i < this.fButtons.length) {
            this.fButtons[i].setEnabled(this.isEnabled());
            ++i;
        }
    }

    protected void createMainLabel(Composite parent, int span, FormToolkit toolkit) {
    }

    public Button getButton(int index) {
        if (this.fButtons == null || index < 0 || index >= this.fButtons.length) {
            return null;
        }
        return this.fButtons[index];
    }

    private class SelectionHandler
    implements SelectionListener {
        private SelectionHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            this.buttonSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.buttonSelected(e);
        }

        private void buttonSelected(SelectionEvent e) {
            Integer index = (Integer)e.widget.getData();
            SharedPartWithButtons.this.buttonSelected((Button)e.widget, index);
        }
    }
}

