/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelProviderEvent;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.DependencyManager;
import org.eclipse.pde.internal.core.ExternalFeatureModelManager;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.ModelProviderEvent;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.PluginPathFinder;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.TargetPlatformResetJob;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.itarget.ITarget;
import org.eclipse.pde.internal.core.itarget.ITargetFeature;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.target.TargetErrorDialog;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.SharedPartWithButtons;
import org.eclipse.pde.internal.ui.preferences.TargetPlatformPreferencePage;
import org.eclipse.pde.internal.ui.util.PersistablePluginObject;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.internal.ui.wizards.provisioner.AddTargetPluginsWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.progress.IProgressConstants;

public class TargetPluginsTab
extends SharedPartWithButtons {
    private CheckboxTableViewer fPluginListViewer;
    private TargetPlatformPreferencePage fPage;
    private boolean fReloaded;
    private CheckboxTreeViewer fPluginTreeViewer;
    private HashSet fChangedModels;
    private PDEState fCurrentState;
    private PageBook fBook;
    private Button fGroupPlugins;
    private HashMap fTreeViewerContents;
    private Label fCounterLabel;
    private int fCounter;
    private Map fCurrentFeatures;
    private ArrayList fAdditionalLocations;

    public TargetPluginsTab(TargetPlatformPreferencePage page) {
        String[] stringArray = new String[8];
        stringArray[0] = PDEUIMessages.ExternalPluginsBlock_reload;
        stringArray[1] = PDEUIMessages.TargetPluginsTab_add;
        stringArray[4] = PDEUIMessages.WizardCheckboxTablePart_selectAll;
        stringArray[5] = PDEUIMessages.WizardCheckboxTablePart_deselectAll;
        stringArray[6] = PDEUIMessages.ExternalPluginsBlock_workingSet;
        stringArray[7] = PDEUIMessages.ExternalPluginsBlock_addRequired;
        super(stringArray);
        this.fChangedModels = new HashSet();
        this.fAdditionalLocations = new ArrayList();
        this.fPage = page;
        Preferences preferences = PDECore.getDefault().getPluginPreferences();
        String additional = preferences.getString("additional_locations");
        StringTokenizer tokenizer = new StringTokenizer(additional, ",");
        while (tokenizer.hasMoreTokens()) {
            this.fAdditionalLocations.add(tokenizer.nextToken().trim());
        }
        PDEPlugin.getDefault().getLabelProvider().connect(this);
    }

    void computeDelta() {
        int type = 0;
        IModel[] changedArray = null;
        if (this.fChangedModels.size() > 0) {
            type |= 4;
            changedArray = this.fChangedModels.toArray(new IModel[this.fChangedModels.size()]);
        }
        this.fChangedModels.clear();
        if (type != 0) {
            ExternalModelManager registry = PDECore.getDefault().getModelManager().getExternalModelManager();
            ModelProviderEvent event = new ModelProviderEvent((Object)registry, type, null, null, changedArray);
            registry.fireModelProviderEvent((IModelProviderEvent)event);
        }
    }

    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 5;
        container.setLayout((Layout)layout);
        super.createControl(container, 0, 2, null);
        this.fCounterLabel = new Label(container, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fCounterLabel.setLayoutData((Object)gd);
        this.fGroupPlugins = new Button(container, 32);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fGroupPlugins.setLayoutData((Object)gd);
        this.fGroupPlugins.setText(PDEUIMessages.TargetPluginsTab_groupPlugins);
        this.fGroupPlugins.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetPluginsTab.this.handleSwitchView();
            }
        });
        this.initializeView();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.target_plugins_preference_page");
        return container;
    }

    protected void initializeView() {
        Preferences preferences = PDECore.getDefault().getPluginPreferences();
        boolean groupPlugins = preferences.getBoolean("group_plugins");
        this.fGroupPlugins.setSelection(groupPlugins);
        if (groupPlugins) {
            this.fBook.showPage(this.fPluginTreeViewer.getControl());
        } else {
            this.fBook.showPage(this.fPluginListViewer.getControl());
        }
    }

    protected void createMainControl(Composite parent, int style, int span, FormToolkit toolkit) {
        this.fBook = new PageBook(parent, 0);
        GridData gd = new GridData(1808);
        gd.heightHint = 100;
        gd.widthHint = 250;
        this.fBook.setLayoutData((Object)gd);
        this.createTableViewer((Composite)this.fBook);
        this.createTreeViewer((Composite)this.fBook);
    }

    private void createTableViewer(Composite container) {
        this.fPluginListViewer = CheckboxTableViewer.newCheckList((Composite)container, (int)2816);
        GridData gd = new GridData(1808);
        gd.heightHint = 100;
        gd.widthHint = 250;
        this.fPluginListViewer.getControl().setLayoutData((Object)gd);
        this.fPluginListViewer.setContentProvider((IContentProvider)new PluginContentProvider());
        this.fPluginListViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.fPluginListViewer.setComparator(ListUtil.PLUGIN_COMPARATOR);
        this.fPluginListViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                IPluginModelBase model = (IPluginModelBase)event.getElement();
                boolean checked = event.getChecked();
                if (TargetPluginsTab.this.fChangedModels.contains(model) && model.isEnabled() == checked) {
                    TargetPluginsTab.this.fChangedModels.remove(model);
                } else if (model.isEnabled() != checked) {
                    TargetPluginsTab.this.fChangedModels.add(model);
                }
                TargetPluginsTab.this.fPluginTreeViewer.setChecked((Object)model, checked);
                String path = model.getInstallLocation();
                if (path != null) {
                    File parent = new File(path).getParentFile();
                    if (checked) {
                        TargetPluginsTab.this.fPluginTreeViewer.setChecked((Object)parent, true);
                        TargetPluginsTab.this.handleGrayChecked(parent, false);
                    } else {
                        TargetPluginsTab.this.handleGrayChecked(parent, true);
                    }
                }
                if (checked) {
                    TargetPluginsTab.this.setCounter(TargetPluginsTab.this.fCounter + 1);
                } else {
                    TargetPluginsTab.this.setCounter(TargetPluginsTab.this.fCounter - 1);
                }
            }
        });
    }

    private void createTreeViewer(Composite container) {
        this.fPluginTreeViewer = new CheckboxTreeViewer(container, 2816);
        GridData gd = new GridData(1808);
        gd.heightHint = 100;
        gd.widthHint = 250;
        this.fPluginTreeViewer.getControl().setLayoutData((Object)gd);
        this.fPluginTreeViewer.setContentProvider((IContentProvider)new TreePluginContentProvider());
        this.fPluginTreeViewer.setComparator(ListUtil.PLUGIN_COMPARATOR);
        this.fPluginTreeViewer.setLabelProvider((IBaseLabelProvider)new PDELabelProvider(){

            public Image getImage(Object obj) {
                if (obj instanceof File) {
                    return this.get(PDEPluginImages.DESC_SITE_OBJ);
                }
                return super.getImage(obj);
            }
        });
        this.fPluginTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                boolean checked = event.getChecked();
                if (element instanceof IPluginModelBase) {
                    IPluginModelBase model = (IPluginModelBase)event.getElement();
                    if (TargetPluginsTab.this.fChangedModels.contains(model) && model.isEnabled() == checked) {
                        TargetPluginsTab.this.fChangedModels.remove(model);
                    } else if (model.isEnabled() != checked) {
                        TargetPluginsTab.this.fChangedModels.add(model);
                    }
                    TargetPluginsTab.this.fPluginListViewer.setChecked((Object)model, checked);
                    String path = model.getInstallLocation();
                    if (path != null) {
                        File parent = new File(path).getParentFile();
                        if (checked) {
                            TargetPluginsTab.this.fPluginTreeViewer.setChecked((Object)parent, true);
                            TargetPluginsTab.this.handleGrayChecked(parent, false);
                        } else {
                            TargetPluginsTab.this.handleGrayChecked(parent, true);
                        }
                    }
                    if (checked) {
                        TargetPluginsTab.this.setCounter(TargetPluginsTab.this.fCounter + 1);
                    } else {
                        TargetPluginsTab.this.setCounter(TargetPluginsTab.this.fCounter - 1);
                    }
                } else if (element instanceof File) {
                    int changedCount = 0;
                    Set plugins = (Set)TargetPluginsTab.this.fTreeViewerContents.get(element);
                    IPluginModelBase[] models = plugins.toArray(new IPluginModelBase[plugins.size()]);
                    int i = 0;
                    while (i < models.length) {
                        if (TargetPluginsTab.this.fChangedModels.contains(models[i]) && models[i].isEnabled() == checked) {
                            TargetPluginsTab.this.fChangedModels.remove(models[i]);
                        } else if (models[i].isEnabled() != checked) {
                            TargetPluginsTab.this.fChangedModels.add(models[i]);
                        }
                        if (checked && !TargetPluginsTab.this.fPluginTreeViewer.getChecked((Object)models[i])) {
                            ++changedCount;
                        } else if (!checked && TargetPluginsTab.this.fPluginTreeViewer.getChecked((Object)models[i])) {
                            --changedCount;
                        }
                        TargetPluginsTab.this.fPluginListViewer.setChecked((Object)models[i], checked);
                        ++i;
                    }
                    TargetPluginsTab.this.fPluginTreeViewer.setSubtreeChecked(element, checked);
                    TargetPluginsTab.this.fPluginTreeViewer.setGrayed(element, false);
                    TargetPluginsTab.this.fPluginTreeViewer.setChecked(element, checked);
                    TargetPluginsTab.this.setCounter(TargetPluginsTab.this.fCounter + changedCount);
                }
            }
        });
        this.fPluginTreeViewer.setAutoExpandLevel(2);
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect(this);
    }

    /*
     * Unable to fully structure code
     */
    protected void loadTargetProfile(ITarget target) {
        if (target.useAllPlugins()) {
            this.handleSelectAll(true);
            return;
        }
        required = new HashMap<String, Object>();
        missingFeatures = new HashMap<String, ITargetFeature>();
        optional = new HashSet<String>();
        targetFeatures = target.getFeatures();
        features = new Stack<IFeature>();
        featureManager = null;
        if (this.fCurrentFeatures == null) {
            featureManager = PDECore.getDefault().getFeatureModelManager();
        }
        i = 0;
        while (i < targetFeatures.length) {
            block29: {
                v0 = model = featureManager != null ? featureManager.findFeatureModel(targetFeatures[i].getId()) : (IFeatureModel)this.fCurrentFeatures.get(targetFeatures[i].getId());
                if (model == null) break block29;
                features.push(model.getFeature());
                ** GOTO lbl53
            }
            if (targetFeatures[i].isOptional()) ** GOTO lbl53
            missingFeatures.put(targetFeatures[i].getId(), targetFeatures[i]);
            break;
lbl-1000:
            // 1 sources

            {
                feature = (IFeature)features.pop();
                plugins = feature.getPlugins();
                j = 0;
                while (j < plugins.length) {
                    if (target.isValidFeatureObject((Object)plugins[j])) {
                        if (targetFeatures[i].isOptional() || plugins[j].isFragment()) {
                            optional.add(plugins[j].getId());
                        } else {
                            required.put(plugins[j].getId(), plugins[j]);
                        }
                    }
                    ++j;
                }
                children = feature.getIncludedFeatures();
                j = 0;
                while (j < children.length) {
                    if (target.isValidFeatureObject((Object)children[j])) {
                        v1 = model = featureManager != null ? featureManager.findFeatureModel(children[j].getId()) : (IFeatureModel)this.fCurrentFeatures.get(children[j].getId());
                        if (model != null) {
                            features.push(model.getFeature());
                        } else if (!targetFeatures[i].isOptional() && !missingFeatures.containsKey(children[j].getId())) {
                            missingFeature = target.getModel().getFactory().createFeature();
                            missingFeature.setId(children[j].getId());
                            missingFeatures.put(children[j].getId(), missingFeature);
                        }
                    }
                    ++j;
                }
lbl53:
                // 3 sources

                ** while (!features.isEmpty())
            }
lbl54:
            // 1 sources

            ++i;
        }
        plugins = target.getPlugins();
        i = 0;
        while (i < plugins.length) {
            if (plugins[i].isOptional()) {
                optional.add(plugins[i].getId());
            } else {
                required.put(plugins[i].getId(), plugins[i]);
            }
            ++i;
        }
        workspacePlugins = PDECore.getDefault().getModelManager().getWorkspaceModels();
        i = 0;
        while (i < workspacePlugins.length) {
            if (workspacePlugins[i].isEnabled()) {
                required.remove(workspacePlugins[i].getBundleDescription().getSymbolicName());
            }
            ++i;
        }
        models = this.getCurrentModels();
        counter = 0;
        i = 0;
        while (i < models.length) {
            id = models[i].getPluginBase().getId();
            if (id != null) {
                if (required.containsKey(id) || optional.contains(id)) {
                    ++counter;
                    if (!this.fPluginListViewer.getChecked((Object)models[i])) {
                        this.fPluginTreeViewer.setChecked((Object)models[i], true);
                        this.fPluginListViewer.setChecked((Object)models[i], true);
                        if (!models[i].isEnabled()) {
                            this.fChangedModels.add(models[i]);
                        }
                        if ((path = models[i].getInstallLocation()) != null) {
                            parent = new File(path).getParentFile();
                            this.fPluginTreeViewer.setChecked((Object)parent, true);
                            this.handleGrayChecked(parent, false);
                        }
                    }
                    required.remove(id);
                } else if (this.fPluginListViewer.getChecked((Object)models[i])) {
                    this.fPluginTreeViewer.setChecked((Object)models[i], false);
                    this.fPluginListViewer.setChecked((Object)models[i], false);
                    if (models[i].isEnabled()) {
                        this.fChangedModels.add(models[i]);
                    }
                    if ((path = models[i].getInstallLocation()) != null) {
                        parent = new File(path).getParentFile();
                        this.handleGrayChecked(parent, true);
                    }
                }
            }
            ++i;
        }
        this.setCounter(counter);
        if (!required.isEmpty() || !missingFeatures.isEmpty()) {
            TargetErrorDialog.showDialog(this.fPage.getShell(), missingFeatures.values().toArray(), required.values().toArray());
        }
    }

    protected void handleReload() {
        String platformPath = this.fPage.getPlatformPath();
        if (platformPath != null && platformPath.length() > 0) {
            ReloadOperation op = new ReloadOperation(platformPath);
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, false, (IRunnableWithProgress)op);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
            this.fPluginListViewer.setInput((Object)PDECore.getDefault().getModelManager().getExternalModelManager());
            this.fPluginTreeViewer.setInput((Object)PDECore.getDefault().getModelManager().getExternalModelManager());
            this.fChangedModels.clear();
            this.handleSelectAll(true);
            if (this.fTreeViewerContents.size() > 1) {
                this.fPluginTreeViewer.collapseAll();
            }
            this.fReloaded = true;
            this.fPage.getSourceBlock().resetExtensionLocations(this.getCurrentModels());
        }
        this.fPage.resetNeedsReload();
    }

    protected void handleReload(ArrayList additionalLocations) {
        this.fAdditionalLocations = additionalLocations;
        this.handleReload();
    }

    public void initialize() {
        String platformPath = this.fPage.getPlatformPath();
        if (platformPath != null && platformPath.length() == 0) {
            return;
        }
        this.fPluginTreeViewer.setUseHashlookup(true);
        ExternalModelManager manager = PDECore.getDefault().getModelManager().getExternalModelManager();
        this.fPluginListViewer.setInput((Object)manager);
        this.fPluginTreeViewer.setInput((Object)manager);
        IPluginModelBase[] allModels = this.getCurrentModels();
        Vector<IPluginModelBase> selection = new Vector<IPluginModelBase>();
        HashSet<File> parentsToCheck = new HashSet<File>();
        int i = 0;
        while (i < allModels.length) {
            String path;
            IPluginModelBase model = allModels[i];
            if (model.isEnabled()) {
                selection.add(model);
            }
            if ((path = model.getInstallLocation()) != null) {
                File installFile = new File(path);
                File parentFile = installFile.getParentFile();
                if (model.isEnabled()) {
                    parentsToCheck.add(parentFile);
                }
            }
            ++i;
        }
        Object[] elements = selection.toArray();
        this.fPluginListViewer.setCheckedElements(elements);
        Object[] parents = parentsToCheck.toArray();
        Object[] checkedValues = new Object[parents.length + elements.length];
        System.arraycopy(parents, 0, checkedValues, 0, parents.length);
        System.arraycopy(elements, 0, checkedValues, parents.length, elements.length);
        this.fPluginTreeViewer.setCheckedElements(checkedValues);
        int i2 = 0;
        while (i2 < parents.length) {
            this.handleGrayChecked((File)parents[i2], false);
            ++i2;
        }
        this.setCounter(elements.length);
    }

    public Set initializeTreeContents(IPluginModelBase[] allModels) {
        HashSet<File> parents = new HashSet<File>();
        if (this.fTreeViewerContents == null) {
            this.fTreeViewerContents = new HashMap();
        }
        int i = 0;
        while (i < allModels.length) {
            IPluginModelBase model = allModels[i];
            String path = model.getInstallLocation();
            if (path != null) {
                File installFile = new File(path);
                File parentFile = installFile.getParentFile();
                HashSet<IPluginModelBase> models = (HashSet<IPluginModelBase>)this.fTreeViewerContents.get(parentFile);
                if (models == null) {
                    models = new HashSet<IPluginModelBase>();
                    models.add(model);
                    this.fTreeViewerContents.put(parentFile, models);
                    parents.add(parentFile);
                } else {
                    models.add(model);
                }
            }
            ++i;
        }
        return parents;
    }

    public void performOk() {
        this.savePreferences();
        if (this.fReloaded) {
            this.updateModels();
            TargetPlatformResetJob job = new TargetPlatformResetJob(this.fCurrentState);
            job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)PDEPluginImages.DESC_PLUGIN_OBJ);
            job.schedule();
            this.fReloaded = false;
            this.fChangedModels.clear();
        } else {
            this.updateModels();
            this.computeDelta();
        }
    }

    private void savePreferences() {
        int i;
        Path defaultPath;
        Preferences preferences = PDECore.getDefault().getPluginPreferences();
        Path newPath = new Path(this.fPage.getPlatformPath());
        String mode = newPath.equals((Object)(defaultPath = new Path(TargetPlatform.getDefaultLocation()))) ? "useThis" : "useOther";
        preferences.setValue("target_mode", mode);
        preferences.setValue("platform_path", this.fPage.getPlatformPath());
        if (this.fCounter == 0) {
            preferences.setValue("checkedPlugins", "[savedNone]");
        } else if (this.fCounter == this.fPluginListViewer.getTable().getItemCount()) {
            preferences.setValue("checkedPlugins", "[savedAll]");
        } else {
            StringBuffer saved = new StringBuffer();
            TableItem[] models = this.fPluginListViewer.getTable().getItems();
            i = 0;
            while (i < models.length) {
                if (!models[i].getChecked()) {
                    IPluginModelBase model = (IPluginModelBase)models[i].getData();
                    if (saved.length() > 0) {
                        saved.append(" ");
                    }
                    saved.append(model.getPluginBase().getId());
                }
                ++i;
            }
            preferences.setValue("checkedPlugins", saved.toString());
        }
        String[] locations = this.fPage.getPlatformLocations();
        int i2 = 0;
        while (i2 < locations.length && i2 < 5) {
            preferences.setValue("saved_platform" + i2, locations[i2]);
            ++i2;
        }
        preferences.setValue("group_plugins", this.fGroupPlugins.getSelection());
        StringBuffer buffer = new StringBuffer();
        i = 0;
        while (i < this.fAdditionalLocations.size()) {
            if (buffer.length() > 0) {
                buffer.append(",");
            }
            buffer.append(this.fAdditionalLocations.get(i).toString());
            ++i;
        }
        preferences.setValue("additional_locations", buffer.toString());
        PDECore.getDefault().savePluginPreferences();
    }

    private void updateModels() {
        Iterator iter = this.fChangedModels.iterator();
        while (iter.hasNext()) {
            IPluginModelBase model = (IPluginModelBase)iter.next();
            model.setEnabled(this.fPluginListViewer.getChecked((Object)model));
        }
    }

    public void handleSelectAll(boolean selected) {
        this.fPluginListViewer.setAllChecked(selected);
        this.fPluginTreeViewer.setAllChecked(selected);
        IPluginModelBase[] allModels = this.getCurrentModels();
        int i = 0;
        while (i < allModels.length) {
            IPluginModelBase model = allModels[i];
            if (model.isEnabled() != selected) {
                this.fChangedModels.add(model);
            } else if (this.fChangedModels.contains(model) && model.isEnabled() == selected) {
                this.fChangedModels.remove(model);
            }
            ++i;
        }
        if (selected) {
            this.setCounter(this.fPluginListViewer.getTable().getItemCount());
        } else {
            this.setCounter(0);
        }
    }

    private void handleWorkingSets() {
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSetSelectionDialog dialog = manager.createWorkingSetSelectionDialog(this.fPluginListViewer.getControl().getShell(), true);
        if (dialog.open() == 0) {
            HashSet set = this.getPluginIDs(dialog.getSelection());
            IPluginModelBase[] models = this.getCurrentModels();
            int counter = 0;
            int i = 0;
            while (i < models.length) {
                String id = models[i].getPluginBase().getId();
                if (id != null) {
                    if (set.contains(id)) {
                        if (!this.fPluginListViewer.getChecked((Object)models[i])) {
                            this.fPluginListViewer.setChecked((Object)models[i], true);
                            ++counter;
                            if (!models[i].isEnabled()) {
                                this.fChangedModels.add(models[i]);
                            }
                        }
                        if (!this.fPluginTreeViewer.getChecked((Object)models[i])) {
                            this.fPluginTreeViewer.setChecked((Object)models[i], true);
                            String path = models[i].getInstallLocation();
                            if (path != null) {
                                File parent = new File(path).getParentFile();
                                this.fPluginTreeViewer.setChecked((Object)parent, true);
                                this.handleGrayChecked(parent, false);
                            }
                        }
                        set.remove(id);
                    }
                    if (set.isEmpty()) break;
                }
                ++i;
            }
            this.setCounter(this.fCounter + counter);
        }
    }

    protected void handleGrayChecked(File parent, boolean handleCheck) {
        boolean gray = false;
        boolean check = false;
        boolean allChecked = true;
        Set models = (Set)this.fTreeViewerContents.get(parent);
        Iterator it = models.iterator();
        while (it.hasNext()) {
            Object model = it.next();
            boolean checked = this.fPluginTreeViewer.getChecked(model);
            check = check || checked;
            boolean bl = allChecked = allChecked && checked;
            if (!gray && checked) {
                gray = true;
                continue;
            }
            if (!gray || checked) continue;
            allChecked = false;
            break;
        }
        if (!allChecked && gray) {
            this.fPluginTreeViewer.setGrayed((Object)parent, true);
        } else {
            this.fPluginTreeViewer.setGrayed((Object)parent, false);
        }
        if (handleCheck) {
            if (check) {
                this.fPluginTreeViewer.setChecked((Object)parent, true);
            } else {
                this.fPluginTreeViewer.setChecked((Object)parent, false);
            }
        }
    }

    private HashSet getPluginIDs(IWorkingSet[] workingSets) {
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < workingSets.length) {
            IAdaptable[] elements = workingSets[i].getElements();
            int j = 0;
            while (j < elements.length) {
                IAdaptable element = elements[j];
                if (element instanceof PersistablePluginObject) {
                    set.add(((PersistablePluginObject)element).getPluginID());
                } else {
                    IPluginModelBase model;
                    if (element instanceof IJavaProject) {
                        element = ((IJavaProject)element).getProject();
                    }
                    if (element instanceof IProject && (model = PluginRegistry.findModel((IProject)((IProject)element))) != null) {
                        set.add(model.getPluginBase().getId());
                    }
                }
                ++j;
            }
            ++i;
        }
        return set;
    }

    private void handleAddRequired() {
        Object[] checked = this.fPluginListViewer.getCheckedElements();
        if (checked.length == 0) {
            return;
        }
        String[] implicit = this.fPage.getImplicitPlugins();
        State state = this.getCurrentState().getState();
        Set set = DependencyManager.getDependencies((Object[])checked, (String[])implicit, (State)state);
        HashSet<File> parents = new HashSet<File>();
        IPluginModelBase[] models = this.getCurrentModels();
        int counter = 0;
        int i = 0;
        while (i < models.length) {
            if (set.contains(models[i].getPluginBase().getId())) {
                this.fPluginListViewer.setChecked((Object)models[i], true);
                this.fPluginTreeViewer.setChecked((Object)models[i], true);
                this.fChangedModels.add(models[i]);
                ++counter;
                String path = models[i].getInstallLocation();
                if (path != null) {
                    parents.add(new File(path).getParentFile());
                }
            }
            ++i;
        }
        Iterator it = parents.iterator();
        while (it.hasNext()) {
            this.handleGrayChecked((File)it.next(), true);
        }
        this.setCounter(this.fCounter + counter);
    }

    protected IPluginModelBase[] getCurrentModels() {
        if (this.fCurrentState != null) {
            return this.fCurrentState.getTargetModels();
        }
        return PDECore.getDefault().getModelManager().getExternalModels();
    }

    protected PDEState getCurrentState() {
        return this.fCurrentState != null ? this.fCurrentState : TargetPlatformHelper.getPDEState();
    }

    protected void handleSwitchView() {
        if (this.fGroupPlugins.getSelection()) {
            this.fBook.showPage(this.fPluginTreeViewer.getControl());
        } else {
            this.fBook.showPage(this.fPluginListViewer.getControl());
        }
    }

    private void setCounter(int value) {
        this.fCounter = value;
        int total = this.fPluginListViewer.getTable().getItemCount();
        String message = NLS.bind((String)PDEUIMessages.WizardCheckboxTablePart_counter, (Object[])new String[]{Integer.toString(this.fCounter), Integer.toString(total)});
        this.fCounterLabel.setText(message);
    }

    protected void buttonSelected(Button button, int index) {
        switch (index) {
            case 0: {
                this.handleReload();
                this.fPage.resetTargetProfile();
                break;
            }
            case 1: {
                this.handleAdd();
                break;
            }
            case 4: {
                this.handleSelectAll(true);
                break;
            }
            case 5: {
                this.handleSelectAll(false);
                break;
            }
            case 6: {
                this.handleWorkingSets();
                break;
            }
            case 7: {
                this.handleAddRequired();
            }
        }
    }

    private void handleAdd() {
        AddTargetPluginsWizard wizard = new AddTargetPluginsWizard();
        WizardDialog dialog = new WizardDialog(this.fPage.getShell(), (IWizard)wizard);
        dialog.create();
        SWTUtil.setDialogSize((Dialog)dialog, 400, 450);
        dialog.open();
        File[] dirs = wizard.getDirectories();
        if (dirs.length == 0) {
            return;
        }
        int i = 0;
        while (i < dirs.length) {
            this.fAdditionalLocations.add(dirs[i].getPath());
            File temp = new File(dirs[i], "plugins");
            if (temp.exists()) {
                dirs[i] = temp;
            }
            ++i;
        }
        URL[] pluginLocs = PluginPathFinder.scanLocations((File[])dirs);
        Object[] checkedPlugins = null;
        if (this.fCurrentState == null) {
            checkedPlugins = this.fPluginListViewer.getCheckedElements();
            this.createCopyState();
        }
        BundleDescription[] descriptions = this.fCurrentState.addAdditionalBundles(pluginLocs);
        this.addNewBundles(descriptions, checkedPlugins);
    }

    private void createCopyState() {
        this.fCurrentState = new PDEState(TargetPlatformHelper.getPDEState());
        IPluginModelBase[] bases = this.fCurrentState.getTargetModels();
        int j = 0;
        while (j < bases.length) {
            long bundleId = bases[j].getBundleDescription().getBundleId();
            BundleDescription newDesc = this.fCurrentState.getState().getBundle(bundleId);
            bases[j].setBundleDescription(newDesc);
            ++j;
        }
    }

    private void addNewBundles(BundleDescription[] descriptions, Object[] checkedPlugins) {
        if (descriptions.length > 0) {
            IPluginModelBase[] models = this.fCurrentState.createTargetModels(descriptions);
            Set parents = this.initializeTreeContents(models);
            this.fPluginListViewer.setInput((Object)PDECore.getDefault().getModelManager().getExternalModelManager());
            this.fPluginTreeViewer.setInput((Object)PDECore.getDefault().getModelManager().getExternalModelManager());
            if (checkedPlugins == null) {
                int i = 0;
                while (i < models.length) {
                    this.fPluginListViewer.setChecked((Object)models[i], true);
                    this.fPluginTreeViewer.setChecked((Object)models[i], true);
                    ++i;
                }
            } else {
                Object[] newCheckedPlugins = new Object[checkedPlugins.length + models.length];
                System.arraycopy(checkedPlugins, 0, newCheckedPlugins, 0, checkedPlugins.length);
                System.arraycopy(models, 0, newCheckedPlugins, checkedPlugins.length, models.length);
                this.fPluginListViewer.setCheckedElements(newCheckedPlugins);
                this.fPluginTreeViewer.setCheckedElements(newCheckedPlugins);
            }
            int i = 0;
            while (i < models.length) {
                this.fChangedModels.add(models[i]);
                ++i;
            }
            Iterator it = parents.iterator();
            while (it.hasNext()) {
                this.fPluginTreeViewer.setChecked(it.next(), true);
            }
            this.setCounter(this.fPluginListViewer.getCheckedElements().length);
            this.fPage.getSourceBlock().resetExtensionLocations(this.getCurrentModels());
            this.fReloaded = true;
        }
    }

    public class PluginContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object parent) {
            return TargetPluginsTab.this.getCurrentModels();
        }
    }

    class ReloadOperation
    implements IRunnableWithProgress {
        private String location;

        public ReloadOperation(String platformPath) {
            this.location = platformPath;
        }

        private URL[] computePluginURLs() {
            URL[] base = PluginPathFinder.getPluginPaths((String)this.location);
            if (TargetPluginsTab.this.fAdditionalLocations.size() == 0) {
                return base;
            }
            File[] extraLocations = new File[TargetPluginsTab.this.fAdditionalLocations.size() * 2];
            int i = 0;
            while (i < extraLocations.length) {
                File dir;
                String location = TargetPluginsTab.this.fAdditionalLocations.get(i / 2).toString();
                extraLocations[i] = dir = new File(location);
                dir = new File(dir, "plugins");
                extraLocations[++i] = dir;
                ++i;
            }
            URL[] additional = PluginPathFinder.scanLocations((File[])extraLocations);
            if (additional.length == 0) {
                return base;
            }
            URL[] result = new URL[base.length + additional.length];
            System.arraycopy(base, 0, result, 0, base.length);
            System.arraycopy(additional, 0, result, base.length, additional.length);
            return result;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(PDEUIMessages.TargetPluginsTab_readingPlatform, 10);
            SubProgressMonitor parsePluginMonitor = new SubProgressMonitor(monitor, 9);
            TargetPluginsTab.this.fCurrentState = new PDEState(this.computePluginURLs(), true, (IProgressMonitor)parsePluginMonitor);
            this.loadFeatures((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            monitor.done();
            TargetPluginsTab.this.fTreeViewerContents.clear();
            TargetPluginsTab.this.initializeTreeContents(TargetPluginsTab.this.getCurrentModels());
        }

        private void loadFeatures(IProgressMonitor monitor) {
            String id;
            IFeatureModel[] externalModels = ExternalFeatureModelManager.createModels((String)this.location, (ArrayList)TargetPluginsTab.this.fAdditionalLocations, (IProgressMonitor)monitor);
            IFeatureModel[] workspaceModels = PDECore.getDefault().getFeatureModelManager().getWorkspaceModels();
            int numFeatures = externalModels.length + workspaceModels.length;
            TargetPluginsTab.this.fCurrentFeatures = new HashMap(1 * numFeatures + 1);
            int i = 0;
            while (i < externalModels.length) {
                id = externalModels[i].getFeature().getId();
                if (id != null) {
                    TargetPluginsTab.this.fCurrentFeatures.put(id, externalModels[i]);
                }
                ++i;
            }
            i = 0;
            while (i < workspaceModels.length) {
                id = workspaceModels[i].getFeature().getId();
                if (id != null) {
                    TargetPluginsTab.this.fCurrentFeatures.put(id, workspaceModels[i]);
                }
                ++i;
            }
            monitor.done();
        }
    }

    public class TreePluginContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object parentElement) {
            Set files;
            if (parentElement instanceof File && (files = (Set)TargetPluginsTab.this.fTreeViewerContents.get(parentElement)) != null) {
                Object[] result = files.toArray();
                return result;
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            IPluginModelBase model;
            String installPath;
            if (element instanceof IPluginModelBase && (installPath = (model = (IPluginModelBase)element).getInstallLocation()) != null) {
                return new File(installPath).getParentFile();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof File) {
                return TargetPluginsTab.this.fTreeViewerContents.containsKey(element);
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (TargetPluginsTab.this.fTreeViewerContents == null) {
                return TargetPluginsTab.this.initializeTreeContents(TargetPluginsTab.this.getCurrentModels()).toArray();
            }
            return TargetPluginsTab.this.fTreeViewerContents.keySet().toArray();
        }
    }
}

