/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEStateHelper;
import org.eclipse.pde.internal.core.SourceLocation;
import org.eclipse.pde.internal.core.SourceLocationManager;
import org.eclipse.pde.internal.core.itarget.ITarget;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.search.ShowDescriptionAction;
import org.eclipse.pde.internal.ui.util.OverlayIcon;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;

public class TargetSourceTab {
    private Image fFolderImage;
    private TreeViewer fTreeViewer;
    private Image fExtensionImage;
    private Image fUserImage;
    private SourceLocation[] fExtensionLocations = new SourceLocation[0];
    private ArrayList fUserLocations = new ArrayList();
    private NamedElement fSystemNode;
    private NamedElement fUserNode;
    private Button fAddButton;
    private Button fRemoveButton;
    private String fLastUserPath = null;
    private DialogPage fPage = null;

    public TargetSourceTab(DialogPage page) {
        this.initializeImages();
        this.fSystemNode = new NamedElement(PDEUIMessages.SourceBlock_target);
        this.fUserNode = new NamedElement(PDEUIMessages.SourceBlock_additional);
        SourceLocationManager manager = PDECore.getDefault().getSourceLocationManager();
        this.fExtensionLocations = manager.getExtensionLocations();
        this.fUserLocations.addAll(Arrays.asList(manager.getUserLocations()));
        this.fPage = page;
    }

    private void initializeImages() {
        this.fExtensionImage = PDEPluginImages.DESC_SOURCE_ATTACHMENT_OBJ.createImage();
        OverlayIcon userDesc = new OverlayIcon(PDEPluginImages.DESC_SOURCE_ATTACHMENT_OBJ, new ImageDescriptor[][]{{PDEPluginImages.DESC_DOC_CO}});
        this.fUserImage = userDesc.createImage();
        this.fFolderImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    }

    public void resetExtensionLocations(IPluginModelBase[] models) {
        this.fExtensionLocations = SourceLocationManager.computeSourceLocations((IPluginModelBase[])models);
        this.fTreeViewer.refresh((Object)this.fSystemNode);
    }

    private String encodeSourceLocations() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.fUserLocations.size()) {
            if (i > 0) {
                buf.append(File.pathSeparatorChar);
            }
            buf.append(((SourceLocation)this.fUserLocations.get(i)).getPath().toOSString());
            ++i;
        }
        return buf.toString();
    }

    public void dispose() {
        this.fExtensionImage.dispose();
        this.fUserImage.dispose();
    }

    public boolean performOk() {
        Preferences preferences = PDECore.getDefault().getPluginPreferences();
        preferences.setValue("source_locations", this.encodeSourceLocations());
        PDECore.getDefault().getSourceLocationManager().setExtensionLocations(this.fExtensionLocations);
        PDECore.getDefault().getJavadocLocationManager().reset();
        return true;
    }

    public void performDefaults() {
        this.fUserLocations.clear();
        this.fTreeViewer.refresh();
    }

    protected void loadTargetProfile(ITarget target) {
    }

    protected void handleAdd() {
        String path = this.getDirectoryDialog(this.fLastUserPath).open();
        if (path != null) {
            SourceLocation location = new SourceLocation((IPath)new Path(path));
            this.fUserLocations.add(location);
            this.fTreeViewer.add((Object)this.fUserNode, (Object)location);
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)location));
            this.fLastUserPath = path;
        }
    }

    private DirectoryDialog getDirectoryDialog(String filterPath) {
        DirectoryDialog dialog = new DirectoryDialog(this.fPage.getShell());
        dialog.setMessage(PDEUIMessages.SourcePreferencePage_dialogMessage);
        if (filterPath != null) {
            dialog.setFilterPath(filterPath);
        }
        return dialog;
    }

    protected void handleRemove() {
        SourceLocation location;
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        Object object = selection.getFirstElement();
        if (object instanceof SourceLocation && (location = (SourceLocation)object).isUserDefined()) {
            this.fUserLocations.remove(location);
            this.fTreeViewer.remove((Object)location);
        }
    }

    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        Link text = new Link(container, 64);
        text.setText(PDEUIMessages.SourceBlock_desc);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.widthHint = 400;
        text.setLayoutData((Object)gd);
        text.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPluginExtensionPoint point = PDEStateHelper.findExtensionPoint((String)"org.eclipse.pde.core.source");
                if (point != null) {
                    new ShowDescriptionAction(point, true).run();
                }
            }
        });
        this.fTreeViewer = new TreeViewer(container, 2048);
        this.fTreeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.fTreeViewer.setContentProvider((IContentProvider)new SourceProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new SourceLabelProvider());
        this.fTreeViewer.setInput((Object)this);
        this.fTreeViewer.expandAll();
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ssel = (IStructuredSelection)event.getSelection();
                boolean removeEnabled = false;
                if (ssel != null && ssel.size() > 0) {
                    Object object = ssel.getFirstElement();
                    removeEnabled = object instanceof SourceLocation && ((SourceLocation)object).isUserDefined();
                }
                TargetSourceTab.this.fRemoveButton.setEnabled(removeEnabled);
            }
        });
        this.fTreeViewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    TargetSourceTab.this.handleRemove();
                }
            }
        });
        Composite buttonContainer = new Composite(container, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonContainer.setLayout((Layout)layout);
        buttonContainer.setLayoutData((Object)new GridData(1040));
        this.fAddButton = new Button(buttonContainer, 8);
        this.fAddButton.setText(PDEUIMessages.SourceBlock_add);
        this.fAddButton.setLayoutData((Object)new GridData(6));
        SWTUtil.setButtonDimensionHint(this.fAddButton);
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetSourceTab.this.handleAdd();
            }
        });
        this.fRemoveButton = new Button(buttonContainer, 8);
        this.fRemoveButton.setText(PDEUIMessages.SourceBlock_remove);
        this.fRemoveButton.setLayoutData((Object)new GridData(6));
        SWTUtil.setButtonDimensionHint(this.fRemoveButton);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetSourceTab.this.handleRemove();
            }
        });
        this.fRemoveButton.setEnabled(false);
        Dialog.applyDialogFont((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.source_preference_page");
        return container;
    }

    class NamedElement {
        String text;

        public NamedElement(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }

    class SourceLabelProvider
    extends LabelProvider {
        SourceLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof SourceLocation) {
                SourceLocation location = (SourceLocation)obj;
                return location.getPath().toOSString();
            }
            return super.getText(obj);
        }

        public Image getImage(Object obj) {
            if (obj instanceof SourceLocation) {
                return TargetSourceTab.this.fFolderImage;
            }
            return obj.equals(TargetSourceTab.this.fUserNode) ? TargetSourceTab.this.fUserImage : TargetSourceTab.this.fExtensionImage;
        }
    }

    class SourceProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        SourceProvider() {
        }

        public Object[] getElements(Object input) {
            return new Object[]{TargetSourceTab.this.fSystemNode, TargetSourceTab.this.fUserNode};
        }

        public Object[] getChildren(Object element) {
            if (element.equals(TargetSourceTab.this.fUserNode)) {
                return TargetSourceTab.this.fUserLocations.toArray();
            }
            if (element.equals(TargetSourceTab.this.fSystemNode)) {
                return TargetSourceTab.this.fExtensionLocations;
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof SourceLocation) {
                SourceLocation loc = (SourceLocation)element;
                return loc.isUserDefined() ? TargetSourceTab.this.fUserNode : TargetSourceTab.this.fSystemNode;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element.equals(TargetSourceTab.this.fSystemNode)) {
                return TargetSourceTab.this.fExtensionLocations.length > 0;
            }
            if (element.equals(TargetSourceTab.this.fUserNode)) {
                return TargetSourceTab.this.fUserLocations.size() > 0;
            }
            return false;
        }
    }
}

