/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.refactoring;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.pde.internal.core.util.IdUtil;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.refactoring.RenamePluginInfo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RenamePluginWizardPage
extends UserInputWizardPage {
    private Text fNewId;
    private Button fUpdateReferences;
    private Button fRenameProject;
    private RenamePluginInfo fInfo;
    private static final String RENAME_PROJECT = "renameProject";

    protected RenamePluginWizardPage(RenamePluginInfo info) {
        super("RenamePluginWizardPage");
        this.fInfo = info;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Dialog.applyDialogFont((Control)composite);
        this.createNewID(composite);
        this.createRenameProject(composite);
        this.createUpdateReferences(composite);
        this.setPageComplete(false);
        this.setControl((Control)composite);
    }

    private void createNewID(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(PDEUIMessages.RenamePluginWizardPage_newId);
        this.fNewId = new Text(composite, 2048);
        this.fNewId.setText(this.fInfo.getCurrentID());
        this.fNewId.setLayoutData((Object)new GridData(768));
        this.fNewId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RenamePluginWizardPage.this.fInfo.setNewID(RenamePluginWizardPage.this.fNewId.getText());
                RenamePluginWizardPage.this.validatePage();
            }
        });
    }

    private void createRenameProject(Composite composite) {
        this.fRenameProject = new Button(composite, 32);
        this.fRenameProject.setText(PDEUIMessages.RenamePluginWizardPage_renameProject);
        this.fRenameProject.setLayoutData((Object)new GridData(1, 2, true, false, 2, 1));
        this.fRenameProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RenamePluginWizardPage.this.fInfo.setRenameProject(RenamePluginWizardPage.this.fRenameProject.getSelection());
            }
        });
        boolean checked = this.getRefactoringSettings().getBoolean(RENAME_PROJECT);
        this.fRenameProject.setSelection(checked);
        this.fInfo.setRenameProject(checked);
    }

    private void createUpdateReferences(Composite composite) {
        this.fUpdateReferences = new Button(composite, 32);
        this.fUpdateReferences.setText(PDEUIMessages.RenamePluginWizardPage_updateReferences);
        this.fUpdateReferences.setLayoutData((Object)new GridData(1, 2, true, false, 2, 1));
        this.fUpdateReferences.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RenamePluginWizardPage.this.fInfo.setUpdateReferences(RenamePluginWizardPage.this.fUpdateReferences.getSelection());
            }
        });
        this.fUpdateReferences.setSelection(true);
    }

    public void dispose() {
        this.getRefactoringSettings().put(RENAME_PROJECT, this.fRenameProject.getSelection());
    }

    protected void validatePage() {
        String text = this.fNewId.getText();
        String errorMessage = null;
        if (text.length() == 0) {
            errorMessage = PDEUIMessages.RenamePluginWizardPage_idNotSet;
        } else if (!IdUtil.isValidCompositeID((String)text)) {
            errorMessage = PDEUIMessages.RenamePluginWizardPage_invalidId;
        }
        if (errorMessage == null && text.equals(this.fInfo.getCurrentID())) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(errorMessage == null ? new RefactoringStatus() : RefactoringStatus.createFatalErrorStatus((String)errorMessage));
        }
    }
}

