/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.refactoring;

import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.ui.refactoring.BuildPropertiesChange;
import org.eclipse.pde.internal.ui.refactoring.PDEMoveParticipant;
import org.eclipse.pde.internal.ui.refactoring.PluginManifestChange;

public abstract class ResourceMoveParticipant
extends PDEMoveParticipant {
    protected boolean isInterestingForExtensions() {
        return true;
    }

    protected boolean initialize(Object element) {
        IProject project;
        if (element instanceof IResource && WorkspaceModelManager.isPluginProject((IProject)(project = ((IResource)element).getProject()))) {
            this.fProject = project;
            this.fElements = new HashMap();
            this.fElements.put(element, this.getNewName(this.getArguments().getDestination(), element));
            return true;
        }
        return false;
    }

    protected void addChange(CompositeChange result, String filename, IProgressMonitor pm) throws CoreException {
        Change change;
        IFile file = this.fProject.getFile(filename);
        if (file.exists() && (change = PluginManifestChange.createRenameChange(file, this.fElements.keySet().toArray(), this.getNewNames(), this.getTextChange(file), pm)) != null) {
            result.add(change);
        }
    }

    protected String getNewName(Object destination, Object element) {
        if (destination instanceof IContainer && element instanceof IResource) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(((IContainer)destination).getProjectRelativePath().toString());
            if (buffer.length() > 0) {
                buffer.append('/');
            }
            return buffer.append(((IResource)element).getName()).toString();
        }
        return super.getNewName(destination, element);
    }

    protected void addChange(CompositeChange result, IProgressMonitor pm) throws CoreException {
        Change change;
        IFile file = this.fProject.getFile("build.properties");
        if (file.exists() && (change = BuildPropertiesChange.createRenameChange(file, this.fElements.keySet().toArray(), this.getNewNames(), pm)) != null) {
            result.add(change);
        }
    }
}

