/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.util;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.util.PersistablePluginObject;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.IWorkingSetPage;
import org.eclipse.ui.dialogs.PatternFilter;

public class PluginWorkingSet
extends WizardPage
implements IWorkingSetPage {
    private IWorkingSet fWorkingSet;
    private Text fWorkingSetName;
    private CheckboxFilteredTree fTree;
    private boolean fFirstCheck;

    public PluginWorkingSet() {
        super("page1", PDEUIMessages.PluginWorkingSet_title, PDEPluginImages.DESC_DEFCON_WIZ);
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    public void finish() {
        Object[] checked = this.fTree.getCheckboxTreeViewer().getCheckedElements();
        ArrayList<PersistablePluginObject> list = new ArrayList<PersistablePluginObject>();
        int i = 0;
        while (i < checked.length) {
            String id = ((IPluginModelBase)checked[i]).getPluginBase().getId();
            if (id != null && id.length() > 0) {
                list.add(new PersistablePluginObject(id));
            }
            ++i;
        }
        PersistablePluginObject[] objects = list.toArray(new PersistablePluginObject[list.size()]);
        String workingSetName = this.fWorkingSetName.getText().trim();
        if (this.fWorkingSet == null) {
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            this.fWorkingSet = workingSetManager.createWorkingSet(workingSetName, (IAdaptable[])objects);
        } else {
            this.fWorkingSet.setName(workingSetName);
            this.fWorkingSet.setElements((IAdaptable[])objects);
        }
    }

    public IWorkingSet getSelection() {
        return this.fWorkingSet;
    }

    public void setSelection(IWorkingSet workingSet) {
        this.fWorkingSet = workingSet;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)composite);
        Label label = new Label(composite, 64);
        label.setText(PDEUIMessages.PluginWorkingSet_setName);
        label.setLayoutData((Object)new GridData(768));
        this.fWorkingSetName = new Text(composite, 2052);
        this.fWorkingSetName.setLayoutData((Object)new GridData(768));
        this.fWorkingSetName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PluginWorkingSet.this.validatePage();
            }
        });
        this.fWorkingSetName.setFocus();
        label = new Label(composite, 64);
        label.setText(PDEUIMessages.PluginWorkingSet_setContent);
        label.setLayoutData((Object)new GridData(768));
        this.fTree = new CheckboxFilteredTree(composite, 2048, new PatternFilter());
        GridData gd = new GridData(1808);
        gd.heightHint = 250;
        this.fTree.getViewer().getControl().setLayoutData((Object)gd);
        ContentProvider fTableContentProvider = new ContentProvider();
        this.fTree.getCheckboxTreeViewer().setContentProvider((IContentProvider)fTableContentProvider);
        this.fTree.getCheckboxTreeViewer().setLabelProvider((IBaseLabelProvider)new WorkingSetLabelProvider());
        this.fTree.getCheckboxTreeViewer().setUseHashlookup(true);
        this.fTree.getCheckboxTreeViewer().setInput((Object)PDECore.getDefault());
        this.fTree.getCheckboxTreeViewer().addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                PluginWorkingSet.this.validatePage();
            }
        });
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayout((Layout)new GridLayout(2, true));
        buttonComposite.setLayoutData((Object)new GridData(256));
        Button selectAllButton = new Button(buttonComposite, 8);
        selectAllButton.setText(PDEUIMessages.PluginWorkingSet_selectAll_label);
        selectAllButton.setToolTipText(PDEUIMessages.PluginWorkingSet_selectAll_toolTip);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter((IStructuredContentProvider)fTableContentProvider){
            private final /* synthetic */ IStructuredContentProvider val$fTableContentProvider;
            {
                this.val$fTableContentProvider = iStructuredContentProvider;
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                PluginWorkingSet.this.fTree.getCheckboxTreeViewer().setCheckedElements(this.val$fTableContentProvider.getElements(PluginWorkingSet.this.fTree.getCheckboxTreeViewer().getInput()));
                PluginWorkingSet.this.validatePage();
            }
        });
        selectAllButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(selectAllButton);
        Button deselectAllButton = new Button(buttonComposite, 8);
        deselectAllButton.setText(PDEUIMessages.PluginWorkingSet_deselectAll_label);
        deselectAllButton.setToolTipText(PDEUIMessages.PluginWorkingSet_deselectAll_toolTip);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PluginWorkingSet.this.fTree.getCheckboxTreeViewer().setCheckedElements(new Object[0]);
                PluginWorkingSet.this.validatePage();
            }
        });
        deselectAllButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(deselectAllButton);
        this.setPageComplete(false);
        this.setMessage(PDEUIMessages.PluginWorkingSet_message);
        this.initialize();
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.pde.doc.user.plugin_working_set");
    }

    private void initialize() {
        if (this.fWorkingSet != null) {
            HashSet<String> set = new HashSet<String>();
            IAdaptable[] elements = this.fWorkingSet.getElements();
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof PersistablePluginObject) {
                    set.add(((PersistablePluginObject)elements[i]).getPluginID());
                }
                ++i;
            }
            IPluginModelBase[] bases = PluginRegistry.getAllModels();
            int i2 = 0;
            while (i2 < bases.length) {
                String id = bases[i2].getPluginBase().getId();
                if (id != null) {
                    if (set.contains(id)) {
                        this.fTree.getCheckboxTreeViewer().setChecked((Object)bases[i2], true);
                        set.remove(id);
                    }
                    if (set.isEmpty()) break;
                }
                ++i2;
            }
            this.fWorkingSetName.setText(this.fWorkingSet.getName());
        }
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
    }

    private void validatePage() {
        String errorMessage = null;
        String newText = this.fWorkingSetName.getText();
        if (newText.trim().length() == 0) {
            errorMessage = PDEUIMessages.PluginWorkingSet_emptyName;
            if (this.fFirstCheck) {
                this.setPageComplete(false);
                this.fFirstCheck = false;
                return;
            }
        }
        if (errorMessage == null && this.fTree.getCheckboxTreeViewer().getCheckedElements().length == 0) {
            errorMessage = PDEUIMessages.PluginWorkingSet_noPluginsChecked;
        }
        if (errorMessage == null && this.fWorkingSet == null) {
            IWorkingSet[] workingSets = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
            int i = 0;
            while (i < workingSets.length) {
                if (newText.equals(workingSets[i].getName())) {
                    errorMessage = PDEUIMessages.PluginWorkingSet_nameInUse;
                    break;
                }
                ++i;
            }
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    class CheckboxFilteredTree
    extends FilteredTree {
        public CheckboxFilteredTree(Composite parent, int treeStyle, PatternFilter filter) {
            super(parent, treeStyle, filter);
        }

        protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
            return new CheckboxTreeViewer(parent, style);
        }

        public CheckboxTreeViewer getCheckboxTreeViewer() {
            return (CheckboxTreeViewer)this.getViewer();
        }
    }

    class ContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return PluginRegistry.getAllModels();
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    class WorkingSetLabelProvider
    extends LabelProvider {
        Preferences pref = PDEPlugin.getDefault().getPluginPreferences();

        public WorkingSetLabelProvider() {
            PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
        }

        public String getText(Object element) {
            if (element instanceof IPluginModelBase) {
                IPluginBase plugin = ((IPluginModelBase)element).getPluginBase();
                String showType = this.pref.getString("Preferences.MainPage.showObjects");
                if (showType.equals("useIds")) {
                    return plugin.getId();
                }
                return plugin.getTranslatedName();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            return PDEPlugin.getDefault().getLabelProvider().getImage(element);
        }

        public void dispose() {
            super.dispose();
            PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        }
    }
}

