/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.dependencies;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Version;

public class DependenciesLabelProvider
extends LabelProvider {
    private PDELabelProvider fSharedProvider;
    private boolean fShowReexport;

    public DependenciesLabelProvider(boolean showRexport) {
        this.fShowReexport = showRexport;
        this.fSharedProvider = PDEPlugin.getDefault().getLabelProvider();
        this.fSharedProvider.connect((Object)this);
    }

    public void dispose() {
        this.fSharedProvider.disconnect((Object)this);
        super.dispose();
    }

    public String getText(Object obj) {
        if (obj instanceof IPluginImport) {
            return ((IPluginImport)obj).getId();
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof IPluginModelBase) {
            return ((IPluginModelBase)obj).getPluginBase(false).getId();
        }
        if (obj instanceof IPluginBase) {
            return this.fSharedProvider.getObjectText((IPluginBase)obj);
        }
        if (obj instanceof BundleDescription) {
            return this.getObjectText((BundleDescription)obj);
        }
        if (obj instanceof VersionConstraint) {
            BaseDescription desc = ((VersionConstraint)obj).getSupplier();
            if (desc instanceof BundleDescription) {
                return this.getObjectText((BundleDescription)desc);
            }
            if (desc instanceof ExportPackageDescription) {
                return this.getObjectText(((ExportPackageDescription)desc).getExporter());
            }
            return ((VersionConstraint)obj).getName();
        }
        return this.fSharedProvider.getText(obj);
    }

    public String getObjectText(BundleDescription obj) {
        String name = this.fSharedProvider.getObjectText(obj);
        Version version = obj.getVersion();
        return String.valueOf(name) + " (" + version.toString() + ")";
    }

    public Image getImage(Object obj) {
        IPluginModelBase model;
        int flags = 0;
        String id = null;
        if (obj instanceof IPluginImport) {
            IPluginImport iobj = (IPluginImport)obj;
            id = iobj.getId();
            if (this.fShowReexport && iobj.isReexported()) {
                flags = 4;
            }
        } else if (obj instanceof String) {
            id = (String)obj;
        }
        if (id != null) {
            model = PluginRegistry.findModel((String)id);
            if (model != null && model.getUnderlyingResource() == null) {
                flags |= 0x20;
            }
            if (model == null) {
                flags = 1;
            }
            if (model != null && model instanceof IFragmentModel) {
                return this.fSharedProvider.get(PDEPluginImages.DESC_FRAGMENT_OBJ, flags);
            }
            return this.fSharedProvider.get(PDEPluginImages.DESC_PLUGIN_OBJ, flags);
        }
        if (obj instanceof IPluginModelBase) {
            if (((IPluginModelBase)obj).getUnderlyingResource() == null) {
                flags |= 0x20;
            }
            if (obj instanceof IFragmentModel) {
                return this.fSharedProvider.get(PDEPluginImages.DESC_FRAGMENT_OBJ, flags);
            }
            return this.fSharedProvider.get(PDEPluginImages.DESC_PLUGIN_OBJ, flags);
        }
        if (obj instanceof IPluginBase) {
            if (((IPluginBase)obj).getPluginModel().getUnderlyingResource() == null) {
                flags |= 0x20;
            }
            if (obj instanceof IFragment) {
                return this.fSharedProvider.get(PDEPluginImages.DESC_FRAGMENT_OBJ, flags);
            }
            return this.fSharedProvider.get(PDEPluginImages.DESC_PLUGIN_OBJ, flags);
        }
        if (obj instanceof BundleDescription) {
            id = ((BundleDescription)obj).getSymbolicName();
        } else if (obj instanceof BundleSpecification) {
            id = ((VersionConstraint)obj).getName();
            if (this.fShowReexport && ((BundleSpecification)obj).isExported()) {
                flags |= 4;
            }
        } else if (obj instanceof ImportPackageSpecification) {
            BaseDescription export = ((ImportPackageSpecification)obj).getSupplier();
            id = ((ExportPackageDescription)export).getExporter().getSymbolicName();
        }
        if (id != null) {
            model = PluginRegistry.findModel((String)id);
            if (model != null && model.getUnderlyingResource() == null) {
                flags |= 0x20;
            }
            if (model == null) {
                flags = 1;
            }
            if (model != null && model instanceof IFragmentModel) {
                return this.fSharedProvider.get(PDEPluginImages.DESC_FRAGMENT_OBJ, flags);
            }
            return this.fSharedProvider.get(PDEPluginImages.DESC_PLUGIN_OBJ, flags);
        }
        return this.fSharedProvider.getImage(obj);
    }
}

