/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.plugins;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.SearchablePluginsManager;
import org.eclipse.pde.internal.core.util.CoreUtility;

public class JavaSearchOperation
implements IRunnableWithProgress {
    private IPluginModelBase[] fModels;
    private boolean fAdd;

    public JavaSearchOperation(IPluginModelBase[] models, boolean add) {
        this.fModels = models;
        this.fAdd = add;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        try {
            try {
                this.createProxyProject(monitor);
                SearchablePluginsManager manager = PDECore.getDefault().getSearchablePluginsManager();
                if (this.fAdd) {
                    manager.addToJavaSearch(this.fModels);
                } else {
                    manager.removeFromJavaSearch(this.fModels);
                }
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    public IProject createProxyProject(IProgressMonitor monitor) throws CoreException {
        IWorkspaceRoot root = PDECore.getWorkspace().getRoot();
        IProject project = root.getProject("External Plug-in Libraries");
        if (project.exists()) {
            return project;
        }
        monitor.beginTask("", 5);
        project.create((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        project.open((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.jdt.core.javanature", (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        IJavaProject jProject = JavaCore.create((IProject)project);
        jProject.setOutputLocation(project.getFullPath(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.computeClasspath(jProject, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        return project;
    }

    private void computeClasspath(IJavaProject project, IProgressMonitor monitor) throws CoreException {
        IClasspathEntry[] classpath = new IClasspathEntry[]{JavaCore.newContainerEntry((IPath)JavaRuntime.newDefaultJREContainerPath()), JavaCore.newContainerEntry((IPath)PDECore.JAVA_SEARCH_CONTAINER_PATH)};
        try {
            project.setRawClasspath(classpath, monitor);
        }
        catch (JavaModelException javaModelException) {}
    }
}

