/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.cheatsheet;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.pde.internal.core.cheatsheet.comp.CompCSWorkspaceModel;
import org.eclipse.pde.internal.core.icheatsheet.comp.ICompCS;
import org.eclipse.pde.internal.core.icheatsheet.comp.ICompCSIntro;
import org.eclipse.pde.internal.core.icheatsheet.comp.ICompCSModelFactory;
import org.eclipse.pde.internal.core.icheatsheet.comp.ICompCSObject;
import org.eclipse.pde.internal.core.icheatsheet.comp.ICompCSOnCompletion;
import org.eclipse.pde.internal.core.icheatsheet.comp.ICompCSTask;
import org.eclipse.pde.internal.core.icheatsheet.comp.ICompCSTaskGroup;
import org.eclipse.pde.internal.core.icheatsheet.comp.ICompCSTaskObject;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.cheatsheet.BaseCSCreationOperation;

public class CompCSCreationOperation
extends BaseCSCreationOperation
implements IRunnableWithProgress {
    public CompCSCreationOperation(IFile file) {
        super(file);
    }

    public CompCSCreationOperation(ISchedulingRule rule) {
        super(rule);
    }

    protected void createContent() {
        CompCSWorkspaceModel model = new CompCSWorkspaceModel(this.fFile, false);
        this.initializeCS(model.getCompCS());
        model.save();
        model.dispose();
    }

    private void initializeCS(ICompCS compCS) {
        ICompCSTaskGroup taskGroup = CompCSCreationOperation.createBasicGroup((ICompCSObject)compCS);
        ICompCSTask task = CompCSCreationOperation.createBasicTask((ICompCSObject)taskGroup);
        taskGroup.addFieldTaskObject((ICompCSTaskObject)task);
        compCS.setFieldName(PDEUIMessages.CompCSCreationOperation_title);
        compCS.setFieldTaskObject((ICompCSTaskObject)taskGroup);
    }

    public static ICompCSTask createBasicTask(ICompCSObject parent) {
        ICompCSModelFactory factory = parent.getModel().getFactory();
        ICompCSTask task = factory.createCompCSTask(parent);
        ICompCSIntro taskIntro = factory.createCompCSIntro((ICompCSObject)task);
        taskIntro.setFieldContent(CompCSCreationOperation.formatTextBold(PDEUIMessages.CompCSCreationOperation_introduction));
        ICompCSOnCompletion taskConclusion = factory.createCompCSOnCompletion((ICompCSObject)task);
        taskConclusion.setFieldContent(CompCSCreationOperation.formatTextBold(PDEUIMessages.CompCSCreationOperation_conclusion));
        task.setFieldName(PDEUIMessages.CompCSCreationOperation_task);
        task.setFieldKind("cheatsheet");
        task.setFieldIntro(taskIntro);
        task.setFieldOnCompletion(taskConclusion);
        return task;
    }

    public static ICompCSTaskGroup createBasicGroup(ICompCSObject parent) {
        ICompCSModelFactory factory = parent.getModel().getFactory();
        ICompCSTaskGroup taskGroup = factory.createCompCSTaskGroup(parent);
        ICompCSIntro taskGroupIntro = factory.createCompCSIntro((ICompCSObject)taskGroup);
        taskGroupIntro.setFieldContent(CompCSCreationOperation.formatTextBold(PDEUIMessages.CompCSCreationOperation_introduction));
        ICompCSOnCompletion taskGroupConclusion = factory.createCompCSOnCompletion((ICompCSObject)taskGroup);
        taskGroupConclusion.setFieldContent(CompCSCreationOperation.formatTextBold(PDEUIMessages.CompCSCreationOperation_conclusion));
        taskGroup.setFieldName(PDEUIMessages.CompCSCreationOperation_group);
        taskGroup.setFieldKind("set");
        taskGroup.setFieldIntro(taskGroupIntro);
        taskGroup.setFieldOnCompletion(taskGroupConclusion);
        return taskGroup;
    }
}

