/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.exports.FeatureExportInfo;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.build.PluginExportJob;
import org.eclipse.pde.internal.ui.wizards.exports.AntGeneratingExportWizard;
import org.eclipse.pde.internal.ui.wizards.exports.BaseExportWizardPage;
import org.eclipse.pde.internal.ui.wizards.exports.PluginExportWizardPage;
import org.eclipse.ui.progress.IProgressConstants;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PluginExportWizard
extends AntGeneratingExportWizard {
    private static final String STORE_SECTION = "PluginExportWizard";

    public PluginExportWizard() {
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_PLUGIN_EXPORT_WIZ);
    }

    protected BaseExportWizardPage createPage1() {
        return new PluginExportWizardPage(this.getSelection());
    }

    protected String getSettingsSectionName() {
        return STORE_SECTION;
    }

    protected void scheduleExportJob() {
        FeatureExportInfo info = new FeatureExportInfo();
        info.toDirectory = this.fPage.doExportToDirectory();
        info.useJarFormat = this.fPage.useJARFormat();
        info.exportSource = this.fPage.doExportSource();
        info.destinationDirectory = this.fPage.getDestination();
        info.zipFileName = this.fPage.getFileName();
        info.items = this.fPage.getSelectedItems();
        info.signingInfo = this.fPage.useJARFormat() ? this.fPage.getSigningInfo() : null;
        info.qualifier = this.fPage.getQualifier();
        PluginExportJob job = new PluginExportJob(info);
        job.setUser(true);
        job.schedule();
        job.setProperty(IProgressConstants.ICON_PROPERTY, PDEPluginImages.DESC_PLUGIN_OBJ);
    }

    protected Document generateAntTask() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document doc = factory.newDocumentBuilder().newDocument();
            Element root = doc.createElement("project");
            root.setAttribute("name", "build");
            root.setAttribute("default", "plugin_export");
            doc.appendChild(root);
            Element target = doc.createElement("target");
            target.setAttribute("name", "plugin_export");
            root.appendChild(target);
            Element export = doc.createElement("pde.exportPlugins");
            export.setAttribute("plugins", this.getPluginIDs());
            export.setAttribute("destination", this.fPage.getDestination());
            String filename = this.fPage.getFileName();
            if (filename != null) {
                export.setAttribute("filename", filename);
            }
            export.setAttribute("exportType", this.getExportOperation());
            export.setAttribute("useJARFormat", Boolean.toString(this.fPage.useJARFormat()));
            export.setAttribute("exportSource", Boolean.toString(this.fPage.doExportSource()));
            String qualifier = this.fPage.getQualifier();
            if (qualifier != null) {
                export.setAttribute("qualifier", qualifier);
            }
            target.appendChild(export);
            return doc;
        }
        catch (DOMException dOMException) {
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
        }
        catch (ParserConfigurationException parserConfigurationException) {}
        return null;
    }

    private String getPluginIDs() {
        StringBuffer buffer = new StringBuffer();
        Object[] objects = this.fPage.getSelectedItems();
        int i = 0;
        while (i < objects.length) {
            Object object = objects[i];
            if (object instanceof IPluginModelBase) {
                buffer.append(((IPluginModelBase)object).getPluginBase().getId());
                if (i < objects.length - 1) {
                    buffer.append(",");
                }
            }
            ++i;
        }
        return buffer.toString();
    }
}

