/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.pde.internal.ui.IPDEUIConstants;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.exports.ExportDestinationTab;
import org.eclipse.pde.internal.ui.wizards.exports.ProductExportWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class ProductDestinationGroup
extends ExportDestinationTab {
    public ProductDestinationGroup(ProductExportWizardPage page) {
        super(page);
    }

    public Control createControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(PDEUIMessages.ExportWizard_destination);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(768));
        this.fDirectoryButton = new Button((Composite)group, 16);
        this.fDirectoryButton.setText(PDEUIMessages.ExportWizard_directory);
        this.fDirectoryCombo = new Combo((Composite)group, 2048);
        this.fDirectoryCombo.setLayoutData((Object)new GridData(768));
        this.fBrowseDirectory = new Button((Composite)group, 8);
        this.fBrowseDirectory.setText(PDEUIMessages.ExportWizard_browse);
        this.fBrowseDirectory.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.fBrowseDirectory);
        this.fArchiveFileButton = new Button((Composite)group, 16);
        this.fArchiveFileButton.setText(PDEUIMessages.ExportWizard_archive);
        this.fArchiveCombo = new Combo((Composite)group, 2048);
        this.fArchiveCombo.setLayoutData((Object)new GridData(768));
        this.fBrowseFile = new Button((Composite)group, 8);
        this.fBrowseFile.setText(PDEUIMessages.ExportWizard_browse);
        this.fBrowseFile.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.fBrowseFile);
        return group;
    }

    protected void initialize(IDialogSettings settings, IFile file) {
        try {
            String toDirectory;
            String string = toDirectory = file != null ? file.getPersistentProperty(IPDEUIConstants.DEFAULT_PRODUCT_EXPORT_DIR) : null;
            if (toDirectory == null) {
                toDirectory = settings.get("exportDirectory");
            }
            boolean useDirectory = toDirectory == null || "true".equals(toDirectory);
            this.fDirectoryButton.setSelection(useDirectory);
            this.fArchiveFileButton.setSelection(!useDirectory);
            this.toggleDestinationGroup(useDirectory);
            this.initializeCombo(settings, "destination", this.fDirectoryCombo);
            this.initializeCombo(settings, "zipFileName", this.fArchiveCombo);
            this.updateDestination(file);
            this.hookListeners();
        }
        catch (CoreException coreException) {}
    }

    protected void updateDestination(IFile file) {
        try {
            if (file == null) {
                return;
            }
            String toDirectory = file.getPersistentProperty(IPDEUIConstants.DEFAULT_PRODUCT_EXPORT_DIR);
            if (toDirectory == null) {
                return;
            }
            boolean useDirectory = "true".equals(toDirectory);
            this.fArchiveFileButton.setSelection(!useDirectory);
            this.fDirectoryButton.setSelection(useDirectory);
            this.toggleDestinationGroup(useDirectory);
            Combo combo = useDirectory ? this.fDirectoryCombo : this.fArchiveCombo;
            String destination = file.getPersistentProperty(IPDEUIConstants.DEFAULT_PRODUCT_EXPORT_LOCATION);
            if (destination != null) {
                if (combo.indexOf(destination) == -1) {
                    combo.add(destination, 0);
                }
                combo.setText(destination);
            }
        }
        catch (CoreException coreException) {}
    }

    protected void saveSettings(IDialogSettings settings) {
        super.saveSettings(settings);
        IFile file = ((ProductExportWizardPage)this.fPage).getProductFile();
        try {
            if (file != null && file.exists()) {
                file.setPersistentProperty(IPDEUIConstants.DEFAULT_PRODUCT_EXPORT_DIR, Boolean.toString(this.doExportToDirectory()));
                file.setPersistentProperty(IPDEUIConstants.DEFAULT_PRODUCT_EXPORT_LOCATION, this.doExportToDirectory() ? this.fDirectoryCombo.getText().trim() : this.fArchiveCombo.getText().trim());
            }
        }
        catch (CoreException coreException) {}
    }
}

