/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.feature;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.util.IdUtil;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.feature.FeatureData;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public abstract class AbstractFeatureSpecPage
extends WizardNewProjectCreationPage {
    protected Text fFeatureNameText;
    protected Text fFeatureVersionText;
    protected Text fLibraryText;
    protected String fInitialId;
    protected String fInitialName;
    protected IFeatureModel fFeatureToPatch;
    protected boolean fSelfModification;
    private boolean fUpdateName = true;

    public AbstractFeatureSpecPage() {
        super("specPage");
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite comp = (Composite)this.getControl();
        this.createContents(comp);
        this.initialize();
        this.attachListeners();
        Dialog.applyDialogFont((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, this.getHelpId());
    }

    protected abstract void createContents(Composite var1);

    protected abstract void initialize();

    protected abstract void attachListeners(ModifyListener var1);

    protected abstract String getHelpId();

    protected void createCommonInput(Composite common) {
        Label label = new Label(common, 0);
        label.setText(PDEUIMessages.NewFeatureWizard_SpecPage_name);
        this.fFeatureNameText = new Text(common, 2048);
        this.fFeatureNameText.setLayoutData((Object)new GridData(768));
        label = new Label(common, 0);
        label.setText(PDEUIMessages.NewFeatureWizard_SpecPage_version);
        this.fFeatureVersionText = new Text(common, 2048);
        this.fFeatureVersionText.setLayoutData((Object)new GridData(768));
    }

    protected void createInstallHandlerText(Composite parent) {
        Label libraryLabel = new Label(parent, 0);
        libraryLabel.setText(PDEUIMessages.NewFeatureWizard_SpecPage_library);
        this.fLibraryText = new Text(parent, 2052);
        this.fLibraryText.setLayoutData((Object)new GridData(768));
    }

    protected abstract void updateNameRelativeFields();

    protected boolean validatePage() {
        boolean valid = super.validatePage();
        if (!valid) {
            return valid;
        }
        if (this.fUpdateName) {
            this.updateNameRelativeFields();
        }
        return this.validateBaseContent(false);
    }

    private boolean validateBaseContent(boolean validateSuper) {
        if (validateSuper && !super.validatePage()) {
            return false;
        }
        if (!this.setValidationMessage(this.verifyIdRules())) {
            return false;
        }
        if (!this.setValidationMessage(this.verifyVersion())) {
            return false;
        }
        if (!this.setValidationMessage(this.validateContent())) {
            return false;
        }
        this.setPageComplete(true);
        this.setErrorMessage(null);
        return true;
    }

    private boolean setValidationMessage(String message) {
        if (message == null) {
            return true;
        }
        this.setPageComplete(false);
        this.setErrorMessage(message);
        return false;
    }

    protected abstract String validateContent();

    public String getInitialName() {
        return this.fInitialName;
    }

    public void setInitialName(String initialName) {
        this.fInitialName = initialName;
    }

    public void setInitialId(String initialId) {
        this.fInitialId = initialId;
    }

    public String getInitialId() {
        return this.fInitialId;
    }

    protected String verifyVersion() {
        String value = this.fFeatureVersionText.getText();
        if (VersionUtil.validateVersion((String)value).getSeverity() != 0) {
            return PDEUIMessages.NewFeatureWizard_SpecPage_versionFormat;
        }
        return null;
    }

    protected abstract String getFeatureId();

    protected String verifyIdRules() {
        String id = this.getFeatureId();
        if (id == null || id.length() == 0) {
            return PDEUIMessages.NewFeatureWizard_SpecPage_missing;
        }
        if (!IdUtil.isValidCompositeID((String)id)) {
            return PDEUIMessages.NewFeatureWizard_SpecPage_invalidId;
        }
        return null;
    }

    public IFeatureModel getFeatureToPatch() {
        return this.fFeatureToPatch;
    }

    protected String getInstallHandlerLibrary() {
        String library = this.fLibraryText.getText();
        if (library == null || library.length() == 0) {
            return null;
        }
        if (!(library.endsWith(".jar") || library.endsWith("/") || library.equals("."))) {
            library = String.valueOf(library) + "/";
        }
        return library;
    }

    private void attachListeners() {
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!AbstractFeatureSpecPage.this.fSelfModification) {
                    AbstractFeatureSpecPage.this.fUpdateName = false;
                    AbstractFeatureSpecPage.this.setPageComplete(AbstractFeatureSpecPage.this.validateBaseContent(true));
                }
            }
        };
        this.attachListeners(listener);
        this.fFeatureNameText.addModifyListener(listener);
        this.fFeatureVersionText.addModifyListener(listener);
        this.fLibraryText.addModifyListener(listener);
    }

    public abstract FeatureData getFeatureData();
}

