/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.imports.BaseImportWizardSecondPage;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportOperation;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportWizardDetailedPage;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportWizardExpressPage;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportWizardFirstPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class PluginImportWizard
extends Wizard
implements IImportWizard {
    private static final String STORE_SECTION = "PluginImportWizard";
    private IStructuredSelection selection;
    private PluginImportWizardFirstPage page1;
    private BaseImportWizardSecondPage page2;
    private BaseImportWizardSecondPage page3;

    public PluginImportWizard() {
        IDialogSettings masterSettings = PDEPlugin.getDefault().getDialogSettings();
        this.setDialogSettings(this.getSettingsSection(masterSettings));
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_PLUGIN_IMPORT_WIZ);
        this.setWindowTitle(PDEUIMessages.ImportWizard_title);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public void addPages() {
        this.setNeedsProgressMonitor(true);
        this.page1 = new PluginImportWizardFirstPage("first");
        this.addPage((IWizardPage)this.page1);
        this.page2 = new PluginImportWizardExpressPage("express", this.page1, this.selection);
        this.addPage((IWizardPage)this.page2);
        this.page3 = new PluginImportWizardDetailedPage("detailed", this.page1);
        this.addPage((IWizardPage)this.page3);
    }

    private IDialogSettings getSettingsSection(IDialogSettings master) {
        IDialogSettings setting = master.getSection(STORE_SECTION);
        if (setting == null) {
            setting = master.addNewSection(STORE_SECTION);
        }
        return setting;
    }

    private IPluginModelBase[] getModelsToImport() {
        if (this.page1.getNextPage().equals((Object)this.page2)) {
            return this.page2.getModelsToImport();
        }
        return this.page3.getModelsToImport();
    }

    public boolean performFinish() {
        this.page1.storeSettings();
        ((BaseImportWizardSecondPage)this.page1.getNextPage()).storeSettings();
        IPluginModelBase[] models = this.getModelsToImport();
        PluginImportWizard.doImportOperation(this.getShell(), this.page1.getImportType(), models, this.page2.forceAutoBuild());
        return true;
    }

    public static void doImportOperation(Shell shell, int importType, IPluginModelBase[] models, boolean forceAutobuild) {
        ImportQuery query = new ImportQuery(shell);
        ImportQuery executionQuery = new ImportQuery(shell);
        final PluginImportOperation op = new PluginImportOperation(models, importType, query, executionQuery, forceAutobuild);
        Job job = new Job(PDEUIMessages.ImportWizard_title){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    PDEPlugin.getWorkspace().run((IWorkspaceRunnable)op, monitor);
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page.equals((Object)this.page1)) {
            if (this.page1.getScanAllPlugins()) {
                return this.page3;
            }
            return this.page2;
        }
        return null;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        return page.equals((Object)this.page1) ? null : this.page1;
    }

    public boolean canFinish() {
        return !this.page1.isCurrentPage() && this.page1.getNextPage().isPageComplete();
    }

    public static class ImportQuery
    implements PluginImportOperation.IImportQuery {
        private int yesToAll = 0;
        private int[] RETURNCODES;

        public ImportQuery(Shell shell) {
            int[] nArray = new int[5];
            nArray[0] = 2;
            nArray[1] = 2;
            nArray[2] = 1;
            nArray[3] = 1;
            this.RETURNCODES = nArray;
        }

        public int doQuery(String message) {
            if (this.yesToAll != 0) {
                return this.yesToAll > 0 ? 2 : 1;
            }
            int[] result = new int[1];
            Display.getDefault().syncExec(new Runnable(this, message, result){
                final /* synthetic */ ImportQuery this$1;
                private final /* synthetic */ String val$message;
                private final /* synthetic */ int[] val$result;
                {
                    this.this$1 = importQuery;
                    this.val$message = string;
                    this.val$result = nArray;
                }

                public void run() {
                    ReplaceDialog dialog = new ReplaceDialog(Display.getDefault().getActiveShell(), this.val$message);
                    int retVal = dialog.open();
                    if (retVal >= 0) {
                        this.val$result[0] = ImportQuery.access$0(this.this$1)[retVal];
                        if (retVal == 1) {
                            ImportQuery.access$1(this.this$1, 1);
                        } else if (retVal == 3) {
                            ImportQuery.access$1(this.this$1, -1);
                        }
                    }
                }
            });
            return result[0];
        }

        static /* synthetic */ int[] access$0(ImportQuery importQuery) {
            return importQuery.RETURNCODES;
        }

        static /* synthetic */ void access$1(ImportQuery importQuery, int n) {
            importQuery.yesToAll = n;
        }
    }

    private static class ReplaceDialog
    extends MessageDialog {
        public ReplaceDialog(Shell parentShell, String dialogMessage) {
            super(parentShell, PDEUIMessages.ImportWizard_messages_title, null, dialogMessage, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, PDEUIMessages.ImportWizard_noToAll, IDialogConstants.CANCEL_LABEL}, 0);
        }
    }
}

