/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.util.PatternConstructor;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.internal.ui.wizards.imports.BaseImportWizardSecondPage;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportWizardFirstPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PluginImportWizardDetailedPage
extends BaseImportWizardSecondPage {
    private Label fCountLabel;
    private TableViewer fAvailableListViewer;
    private Text fFilterText;

    public PluginImportWizardDetailedPage(String pageName, PluginImportWizardFirstPage firstPage) {
        super(pageName, firstPage);
        this.setTitle(PDEUIMessages.ImportWizard_DetailedPage_title);
        this.setMessage(PDEUIMessages.ImportWizard_DetailedPage_desc);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        this.createScrollArea(container);
        this.createAvailableList(container).setLayoutData((Object)new GridData(1808));
        this.createButtonArea(container);
        this.createImportList(container).setLayoutData((Object)new GridData(1808));
        this.updateCount();
        this.createComputationsOption(container, 3);
        this.addViewerListeners();
        this.initialize();
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.plugin_import_second_page");
    }

    private void initialize() {
        this.setPageComplete(false);
    }

    private void addViewerListeners() {
        this.fAvailableListViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PluginImportWizardDetailedPage.this.handleAdd();
            }
        });
        this.fImportListViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PluginImportWizardDetailedPage.this.handleRemove();
            }
        });
        this.fFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PluginImportWizardDetailedPage.this.handleFilter();
            }
        });
    }

    private Composite createAvailableList(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData());
        Label label = new Label(container, 0);
        label.setText(PDEUIMessages.ImportWizard_DetailedPage_availableList);
        Table table = new Table(container, 2562);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        gd.widthHint = 225;
        table.setLayoutData((Object)gd);
        this.fAvailableListViewer = new TableViewer(table);
        this.fAvailableListViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.fAvailableListViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.fAvailableListViewer.setInput((Object)PDECore.getDefault().getModelManager());
        this.fAvailableListViewer.setComparator(ListUtil.PLUGIN_COMPARATOR);
        return container;
    }

    private Composite createButtonArea(Composite parent) {
        ScrolledComposite comp = new ScrolledComposite(parent, 768);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayoutData((Object)new GridData(1040));
        Composite container = new Composite((Composite)comp, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1040);
        gd.verticalIndent = 15;
        container.setLayoutData((Object)gd);
        Button button = new Button(container, 8);
        button.setText(PDEUIMessages.ImportWizard_DetailedPage_existing);
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardDetailedPage.this.handleExistingProjects();
            }
        });
        SWTUtil.setButtonDimensionHint(button);
        button = new Button(container, 8);
        button.setText(PDEUIMessages.ImportWizard_DetailedPage_existingUnshared);
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardDetailedPage.this.handleExistingUnshared();
            }
        });
        SWTUtil.setButtonDimensionHint(button);
        button = new Button(container, 8);
        button.setText(PDEUIMessages.ImportWizard_DetailedPage_add);
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardDetailedPage.this.handleAdd();
            }
        });
        SWTUtil.setButtonDimensionHint(button);
        button = new Button(container, 8);
        button.setText(PDEUIMessages.ImportWizard_DetailedPage_addAll);
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardDetailedPage.this.handleAddAll();
            }
        });
        SWTUtil.setButtonDimensionHint(button);
        button = new Button(container, 8);
        button.setText(PDEUIMessages.ImportWizard_DetailedPage_remove);
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardDetailedPage.this.handleRemove();
            }
        });
        SWTUtil.setButtonDimensionHint(button);
        button = new Button(container, 8);
        button.setText(PDEUIMessages.ImportWizard_DetailedPage_removeAll);
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardDetailedPage.this.handleRemoveAll();
            }
        });
        SWTUtil.setButtonDimensionHint(button);
        button = new Button(container, 8);
        button.setText(PDEUIMessages.ImportWizard_DetailedPage_swap);
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardDetailedPage.this.handleSwap();
            }
        });
        SWTUtil.setButtonDimensionHint(button);
        button = new Button(container, 8);
        button.setText(PDEUIMessages.ImportWizard_DetailedPage_addRequired);
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardDetailedPage.this.handleAddRequiredPlugins();
            }
        });
        SWTUtil.setButtonDimensionHint(button);
        this.fCountLabel = new Label(container, 0);
        this.fCountLabel.setLayoutData((Object)new GridData(64));
        comp.setContent((Control)container);
        comp.setMinHeight(250);
        comp.setExpandHorizontal(true);
        comp.setExpandVertical(true);
        return container;
    }

    private Composite createScrollArea(Composite parent) {
        Group container = new Group(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 6;
        layout.marginWidth = 6;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        container.setLayoutData((Object)gd);
        container.setText(PDEUIMessages.ImportWizard_DetailedPage_locate);
        Label filterLabel = new Label((Composite)container, 0);
        filterLabel.setText(PDEUIMessages.ImportWizard_DetailedPage_search);
        this.fFilterText = new Text((Composite)container, 2048);
        this.fFilterText.setText("");
        gd = new GridData(768);
        this.fFilterText.setLayoutData((Object)gd);
        return container;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fFilterText.setFocus();
        }
        this.setPageComplete(visible && this.fImportListViewer.getTable().getItemCount() > 0);
    }

    protected void refreshPage() {
        this.fAvailableListViewer.refresh();
        this.fImportListViewer.getTable().removeAll();
        this.pageChanged();
    }

    protected void pageChanged() {
        this.updateCount();
        this.handleFilter();
        this.setPageComplete(this.fImportListViewer.getTable().getItemCount() > 0);
    }

    private void updateCount() {
        this.fCountLabel.setText(NLS.bind((String)PDEUIMessages.ImportWizard_DetailedPage_count, (Object[])new String[]{new Integer(this.fImportListViewer.getTable().getItemCount()).toString(), new Integer(this.fModels.length).toString()}));
        this.fCountLabel.getParent().layout();
    }

    private void handleAdd() {
        IStructuredSelection ssel = (IStructuredSelection)this.fAvailableListViewer.getSelection();
        if (ssel.size() > 0) {
            Table table = this.fAvailableListViewer.getTable();
            int index = table.getSelectionIndices()[0];
            this.fAvailableListViewer.remove(ssel.toArray());
            this.fImportListViewer.add(ssel.toArray());
            table.setSelection(index < table.getItemCount() ? index : table.getItemCount() - 1);
            this.pageChanged();
        }
    }

    private void handleAddAll() {
        TableItem[] items = this.fAvailableListViewer.getTable().getItems();
        ArrayList<Object> data = new ArrayList<Object>();
        int i = 0;
        while (i < items.length) {
            data.add(items[i].getData());
            ++i;
        }
        if (data.size() > 0) {
            this.fImportListViewer.add(data.toArray());
            this.fAvailableListViewer.remove(data.toArray());
            this.pageChanged();
        }
    }

    private void handleFilter() {
        if (this.fFilterText == null || this.fFilterText.getText().trim().length() == 0) {
            return;
        }
        String text = this.fFilterText.getText().trim();
        if (!text.endsWith("*")) {
            text = String.valueOf(text) + "*";
        }
        Pattern pattern = PatternConstructor.createPattern((String)text, (boolean)true);
        TableItem[] tableItems = this.fAvailableListViewer.getTable().getItems();
        ArrayList<TableItem> results = new ArrayList<TableItem>();
        int i = 0;
        while (i < tableItems.length) {
            IPluginModelBase model;
            Object data = tableItems[i].getData();
            if (data instanceof IPluginModelBase && pattern.matcher((model = (IPluginModelBase)data).getPluginBase().getId()).matches()) {
                results.add(tableItems[i]);
            }
            ++i;
        }
        if (results.size() > 0) {
            TableItem[] selectionList = results.toArray(new TableItem[results.size()]);
            this.fAvailableListViewer.getTable().setSelection(selectionList);
        } else {
            this.fAvailableListViewer.setSelection(null);
        }
    }

    private void handleRemove() {
        IStructuredSelection ssel = (IStructuredSelection)this.fImportListViewer.getSelection();
        if (ssel.size() > 0) {
            Table table = this.fImportListViewer.getTable();
            int index = table.getSelectionIndices()[0];
            this.fImportListViewer.remove(ssel.toArray());
            this.fAvailableListViewer.add(ssel.toArray());
            table.setSelection(index < table.getItemCount() ? index : table.getItemCount() - 1);
            this.pageChanged();
        }
    }

    private void handleRemoveAll() {
        this.handleRemoveAll(true);
    }

    private void handleRemoveAll(boolean refresh) {
        TableItem[] items = this.fImportListViewer.getTable().getItems();
        ArrayList<Object> data = new ArrayList<Object>();
        int i = 0;
        while (i < items.length) {
            data.add(items[i].getData());
            ++i;
        }
        if (data.size() > 0) {
            this.fAvailableListViewer.add(data.toArray());
            this.fImportListViewer.remove(data.toArray());
            this.pageChanged();
        }
    }

    private void handleSwap() {
        TableItem[] aItems = this.fAvailableListViewer.getTable().getItems();
        TableItem[] iItems = this.fImportListViewer.getTable().getItems();
        ArrayList<Object> data = new ArrayList<Object>();
        int i = 0;
        while (i < iItems.length) {
            data.add(iItems[i].getData());
            ++i;
        }
        if (data.size() > 0) {
            this.fAvailableListViewer.add(data.toArray());
            this.fImportListViewer.remove(data.toArray());
        }
        data.clear();
        i = 0;
        while (i < aItems.length) {
            data.add(aItems[i].getData());
            ++i;
        }
        if (data.size() > 0) {
            this.fImportListViewer.add(data.toArray());
            this.fAvailableListViewer.remove(data.toArray());
        }
        this.pageChanged();
    }

    private void handleExistingProjects() {
        this.handleRemoveAll(false);
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
        int i = 0;
        while (i < this.fModels.length) {
            String id = this.fModels[i].getPluginBase().getId();
            IProject project = (IProject)PDEPlugin.getWorkspace().getRoot().findMember(id);
            if (project != null && project.isOpen() && WorkspaceModelManager.isPluginProject((IProject)project)) {
                result.add(this.fModels[i]);
            }
            ++i;
        }
        if (result.size() > 0) {
            this.fImportListViewer.add(result.toArray());
            this.fAvailableListViewer.remove(result.toArray());
        }
        this.pageChanged();
    }

    private void handleExistingUnshared() {
        this.handleRemoveAll(false);
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
        int i = 0;
        while (i < this.fModels.length) {
            String id = this.fModels[i].getPluginBase().getId();
            IProject project = (IProject)PDEPlugin.getWorkspace().getRoot().findMember(id);
            if (project != null && WorkspaceModelManager.isUnsharedProject((IProject)project) && WorkspaceModelManager.isPluginProject((IProject)project)) {
                result.add(this.fModels[i]);
            }
            ++i;
        }
        if (result.size() > 0) {
            this.fImportListViewer.add(result.toArray());
            this.fAvailableListViewer.remove(result.toArray());
        }
        this.pageChanged();
    }

    private void handleAddRequiredPlugins() {
        IPluginModelBase model;
        TableItem[] items = this.fImportListViewer.getTable().getItems();
        if (items.length == 0) {
            return;
        }
        if (items.length == 1 && (model = (IPluginModelBase)items[0].getData()).getPluginBase().getId().equals("org.eclipse.core.boot")) {
            return;
        }
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < items.length) {
            this.addPluginAndDependencies((IPluginModelBase)items[i].getData(), result, this.fAddFragmentsButton.getSelection());
            ++i;
        }
        this.handleRemoveAll(false);
        this.fImportListViewer.add(result.toArray());
        this.fAvailableListViewer.remove(result.toArray());
        this.pageChanged();
    }

    class ContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object element) {
            return PluginImportWizardDetailedPage.this.fModels;
        }
    }
}

