/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.plugin;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.parts.PluginVersionPart;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.PluginSelectionDialog;
import org.eclipse.pde.internal.ui.wizards.plugin.AbstractFieldData;
import org.eclipse.pde.internal.ui.wizards.plugin.ContentPage;
import org.eclipse.pde.internal.ui.wizards.plugin.FragmentFieldData;
import org.eclipse.pde.internal.ui.wizards.plugin.NewProjectCreationPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Version;

public class FragmentContentPage
extends ContentPage {
    private Text fPluginIdText_newV;
    private Text fPluginIdText_oldV;
    private Text fPluginVersion;
    private Combo fMatchCombo;
    private boolean fNewVersion;
    private Composite fNotebook;
    private StackLayout fNotebookLayout;
    private Composite fOldComp;
    private Composite fNewComp;
    private PluginVersionPart fVersionPart;
    protected ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            FragmentContentPage.this.validatePage();
        }
    };

    public FragmentContentPage(String pageName, IProjectProvider provider, NewProjectCreationPage page, AbstractFieldData data) {
        super(pageName, provider, page, data);
        this.setTitle(PDEUIMessages.ContentPage_ftitle);
        this.setDescription(PDEUIMessages.ContentPage_fdesc);
        this.updateVersion(false);
        this.fVersionPart = new PluginVersionPart(this.fNewVersion);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 15;
        container.setLayout((Layout)layout);
        this.createFragmentPropertiesGroup(container);
        this.createParentPluginGroup(container);
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.pde.doc.user.new_fragment_required_data");
    }

    public void createFragmentPropertiesGroup(Composite container) {
        Group propertiesGroup = new Group(container, 0);
        propertiesGroup.setLayout((Layout)new GridLayout(2, false));
        propertiesGroup.setLayoutData((Object)new GridData(768));
        propertiesGroup.setText(PDEUIMessages.ContentPage_fGroup);
        Label label = new Label((Composite)propertiesGroup, 0);
        label.setText(PDEUIMessages.ContentPage_fid);
        this.fIdText = this.createText((Composite)propertiesGroup, this.propertiesListener);
        label = new Label((Composite)propertiesGroup, 0);
        label.setText(PDEUIMessages.ContentPage_fversion);
        this.fVersionText = this.createText((Composite)propertiesGroup, this.propertiesListener);
        label = new Label((Composite)propertiesGroup, 0);
        label.setText(PDEUIMessages.ContentPage_fname);
        this.fNameText = this.createText((Composite)propertiesGroup, this.propertiesListener);
        label = new Label((Composite)propertiesGroup, 0);
        label.setText(PDEUIMessages.ContentPage_fprovider);
        this.fProviderText = this.createText((Composite)propertiesGroup, this.propertiesListener);
        this.fLibraryLabel = new Label((Composite)propertiesGroup, 0);
        this.fLibraryLabel.setText(PDEUIMessages.ProjectStructurePage_library);
        this.fLibraryText = this.createText((Composite)propertiesGroup, this.propertiesListener);
    }

    private void createParentPluginGroup(Composite container) {
        Group parentGroup = new Group(container, 0);
        parentGroup.setLayout((Layout)new GridLayout(2, false));
        parentGroup.setLayoutData((Object)new GridData(768));
        parentGroup.setText(PDEUIMessages.ContentPage_parentPluginGroup);
        this.fNotebook = new Composite((Composite)parentGroup, 0);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.fNotebook.setLayoutData((Object)gd);
        this.fNotebookLayout = new StackLayout();
        this.fNotebook.setLayout((Layout)this.fNotebookLayout);
        this.fNewComp = this.createNewVersionComp(this.fNotebook);
        this.fOldComp = this.createOldVersionComp(this.fNotebook);
        this.fNotebookLayout.topControl = this.fNewVersion ? this.fNewComp : this.fOldComp;
    }

    private Composite createNewVersionComp(Composite notebook) {
        Composite comp = new Composite(notebook, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        Label label = new Label(comp, 0);
        label.setText(PDEUIMessages.FragmentContentPage_pid);
        this.fPluginIdText_newV = this.createPluginIdContainer(comp, true, 2);
        this.fVersionPart.createVersionFields(comp, false, true);
        this.fVersionPart.addListeners(this.listener, this.listener);
        return comp;
    }

    private Composite createOldVersionComp(Composite notebook) {
        Composite comp = new Composite(notebook, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        Label label = new Label(comp, 0);
        label.setText(PDEUIMessages.FragmentContentPage_pid);
        Composite container = new Composite(comp, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(768));
        this.fPluginIdText_oldV = this.createPluginIdContainer(container, false, 1);
        label = new Label(comp, 0);
        label.setText(PDEUIMessages.FragmentContentPage_pversion);
        this.fPluginVersion = this.createText(comp, this.listener);
        label = new Label(comp, 0);
        label.setText(PDEUIMessages.ContentPage_matchRule);
        this.fMatchCombo = new Combo(comp, 2056);
        this.fMatchCombo.setLayoutData((Object)new GridData(768));
        this.fMatchCombo.setItems(new String[]{"", PDEUIMessages.ManifestEditor_MatchSection_equivalent, PDEUIMessages.ManifestEditor_MatchSection_compatible, PDEUIMessages.ManifestEditor_MatchSection_perfect, PDEUIMessages.ManifestEditor_MatchSection_greater});
        this.fMatchCombo.setText(this.fMatchCombo.getItem(0));
        return comp;
    }

    private Text createPluginIdContainer(Composite parent, final boolean validateRange, int span) {
        final Text pluginText = this.createText(parent, this.listener);
        Button browse = new Button(parent, 8);
        browse.setText(PDEUIMessages.ContentPage_browse);
        browse.setLayoutData((Object)new GridData());
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BusyIndicator.showWhile((Display)pluginText.getDisplay(), (Runnable)new Runnable(this, pluginText, validateRange){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ Text val$pluginText;
                    private final /* synthetic */ boolean val$validateRange;
                    {
                        this.this$1 = var1_1;
                        this.val$pluginText = text;
                        this.val$validateRange = bl;
                    }

                    public void run() {
                        PluginSelectionDialog dialog = new PluginSelectionDialog(this.val$pluginText.getShell(), false, false);
                        dialog.create();
                        if (dialog.open() == 0) {
                            IPluginModel model = (IPluginModel)dialog.getFirstResult();
                            IPlugin plugin = model.getPlugin();
                            String version = FragmentContentPage.access$0(2.access$0(this.this$1), plugin.getVersion());
                            if (this.val$validateRange) {
                                FragmentContentPage.access$1(2.access$0(this.this$1)).setVersion(version);
                                FragmentContentPage.access$1(2.access$0(this.this$1)).preloadFields();
                            } else {
                                FragmentContentPage.access$2(2.access$0(this.this$1)).setText(version);
                            }
                            this.val$pluginText.setText(plugin.getId());
                        }
                    }
                });
            }

            static /* synthetic */ FragmentContentPage access$0(2 var0) {
                return var0.FragmentContentPage.this;
            }
        });
        SWTUtil.setButtonDimensionHint(browse);
        return pluginText;
    }

    private String computeInitialPluginVersion(String pluginVersion) {
        if (pluginVersion != null && VersionUtil.validateVersion((String)pluginVersion).isOK()) {
            Version pvi = Version.parseVersion((String)pluginVersion);
            return String.valueOf(pvi.getMajor()) + "." + pvi.getMinor() + "." + pvi.getMicro();
        }
        return pluginVersion;
    }

    public void updateData() {
        String version;
        super.updateData();
        if (this.fNewVersion) {
            version = this.fVersionPart.getVersion();
            ((FragmentFieldData)this.fData).setPluginId(this.fPluginIdText_newV.getText().trim());
        } else {
            version = this.fPluginVersion.getText().trim();
            ((FragmentFieldData)this.fData).setPluginId(this.fPluginIdText_oldV.getText().trim());
            ((FragmentFieldData)this.fData).setMatch(this.fMatchCombo.getSelectionIndex());
        }
        ((FragmentFieldData)this.fData).setPluginVersion(version);
    }

    protected void validatePage() {
        String errorMessage = this.validateProperties();
        if (errorMessage == null) {
            String pluginID;
            String string = pluginID = this.fNewVersion ? this.fPluginIdText_newV.getText().trim() : this.fPluginIdText_oldV.getText().trim();
            if (pluginID.length() == 0) {
                errorMessage = PDEUIMessages.ContentPage_nopid;
            } else if (!(PluginRegistry.findModel((String)pluginID) instanceof IPluginModel)) {
                errorMessage = PDEUIMessages.ContentPage_pluginNotFound;
            } else if (this.fNewVersion) {
                IStatus status = this.fVersionPart.validateFullVersionRangeText(false);
                if (status.getSeverity() != 0) {
                    errorMessage = status.getMessage();
                }
            } else {
                errorMessage = this.validateVersion(this.fPluginVersion);
            }
        }
        if (this.fInitialized) {
            this.setErrorMessage(errorMessage);
        }
        this.setPageComplete(errorMessage == null);
    }

    protected String getNameFieldQualifier() {
        return PDEUIMessages.ContentPage_fragment;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.fMainPage.updateData();
            this.updateVersion(true);
        }
        super.setVisible(visible);
    }

    private void updateVersion(boolean updateComposite) {
        boolean bl = this.fNewVersion = Double.parseDouble(this.fData.getTargetVersion()) > 3.0;
        if (updateComposite) {
            Control oldPage = this.fNotebookLayout.topControl;
            this.fNotebookLayout.topControl = this.fNewVersion ? this.fNewComp : this.fOldComp;
            if (oldPage != this.fNotebookLayout.topControl) {
                this.fNotebook.layout();
            }
        }
    }

    static /* synthetic */ String access$0(FragmentContentPage fragmentContentPage, String string) {
        return fragmentContentPage.computeInitialPluginVersion(string);
    }

    static /* synthetic */ PluginVersionPart access$1(FragmentContentPage fragmentContentPage) {
        return fragmentContentPage.fVersionPart;
    }

    static /* synthetic */ Text access$2(FragmentContentPage fragmentContentPage) {
        return fragmentContentPage.fPluginVersion;
    }
}

