/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.Stack;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModelFactory;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ISharedPluginModel;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.bundle.BundlePluginBase;
import org.eclipse.pde.internal.core.converter.PluginConverter;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModelBase;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.search.dependencies.AddNewBinaryDependenciesOperation;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.plugin.LibraryPluginFieldData;
import org.eclipse.pde.internal.ui.wizards.plugin.NewProjectCreationOperation;
import org.eclipse.pde.ui.IFieldData;
import org.eclipse.pde.ui.IPluginContentWizard;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;
import org.osgi.framework.BundleException;

public class NewLibraryPluginCreationOperation
extends NewProjectCreationOperation {
    private LibraryPluginFieldData fData;

    public NewLibraryPluginCreationOperation(LibraryPluginFieldData data, IProjectProvider provider, IPluginContentWizard contentWizard) {
        super(data, provider, contentWizard);
        this.fData = data;
    }

    private void addJar(File jarFile, IProject project, IProgressMonitor monitor) throws CoreException {
        block14: {
            String jarName = jarFile.getName();
            IFile file = project.getFile(jarName);
            monitor.subTask(NLS.bind((String)PDEUIMessages.NewProjectCreationOperation_copyingJar, (Object)jarName));
            FileInputStream in = null;
            try {
                try {
                    in = new FileInputStream(jarFile);
                    file.create((InputStream)in, true, monitor);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void adjustExportRoot(IProject project, IBundle bundle) throws CoreException {
        IResource[] resources = project.members(false);
        int j = 0;
        while (j < resources.length) {
            if (!(!(resources[j] instanceof IFile) || ".project".equals(resources[j].getName()) || ".classpath".equals(resources[j].getName()) || "plugin.xml".equals(resources[j].getName()) || "build.properties".equals(resources[j].getName()))) {
                return;
            }
            ++j;
        }
        this.removeExportRoot(bundle);
    }

    protected void adjustManifests(IProgressMonitor monitor, IProject project, IPluginBase base) throws CoreException {
        IBundle bundle;
        super.adjustManifests(monitor, project, base);
        monitor.beginTask(new String(), this.fData.doFindDependencies() ? 4 : 2);
        IBundle iBundle = bundle = base instanceof BundlePluginBase ? ((BundlePluginBase)base).getBundle() : null;
        if (bundle != null) {
            this.adjustExportRoot(project, bundle);
            monitor.worked(1);
            this.addExportedPackages(project, bundle);
            monitor.worked(1);
            if (this.fData.doFindDependencies()) {
                this.addDependencies(project, base.getModel(), (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            }
        }
        monitor.done();
    }

    protected void createContents(IProgressMonitor monitor, IProject project) throws CoreException, JavaModelException, InvocationTargetException, InterruptedException {
        String[] paths = this.fData.getLibraryPaths();
        int i = paths.length - 1;
        while (i >= 0) {
            File jarFile = new File(paths[i]);
            if (this.fData.isUnzipLibraries()) {
                this.importJar(jarFile, (IResource)project, monitor);
            } else {
                this.addJar(jarFile, project, monitor);
            }
            monitor.worked(1);
            --i;
        }
        IFile importedManifest = project.getFile("META-INF/MANIFEST.MF");
        if (importedManifest.exists()) {
            IFolder meta_inf;
            importedManifest.delete(true, false, monitor);
            if (!this.fData.hasBundleStructure() && (meta_inf = project.getFolder("META-INF")).members().length == 0) {
                meta_inf.delete(true, false, monitor);
            }
        }
    }

    protected void fillBinIncludes(IProject project, IBuildEntry binEntry) throws CoreException {
        if (this.fData.hasBundleStructure()) {
            binEntry.addToken("META-INF/");
        } else {
            binEntry.addToken("plugin.xml");
        }
        if (this.fData.isUnzipLibraries()) {
            IResource[] resources = project.members(false);
            int j = 0;
            while (j < resources.length) {
                if (resources[j] instanceof IFolder) {
                    if (!binEntry.contains(String.valueOf(resources[j].getName()) + "/")) {
                        binEntry.addToken(String.valueOf(resources[j].getName()) + "/");
                    }
                } else if (!(".project".equals(resources[j].getName()) || ".classpath".equals(resources[j].getName()) || "build.properties".equals(resources[j].getName()) || binEntry.contains(resources[j].getName()))) {
                    binEntry.addToken(resources[j].getName());
                }
                ++j;
            }
        } else {
            String[] libraryPaths = this.fData.getLibraryPaths();
            int j = 0;
            while (j < libraryPaths.length) {
                File jarFile = new File(libraryPaths[j]);
                String name = jarFile.getName();
                if (!binEntry.contains(name)) {
                    binEntry.addToken(name);
                }
                ++j;
            }
        }
    }

    protected IClasspathEntry[] getInternalClassPathEntries(IProject project, IFieldData data) {
        String[] libraryPaths = this.fData.isUnzipLibraries() ? new String[]{""} : this.fData.getLibraryPaths();
        IClasspathEntry[] entries = new IClasspathEntry[libraryPaths.length];
        int j = 0;
        while (j < libraryPaths.length) {
            File jarFile = new File(libraryPaths[j]);
            String jarName = jarFile.getName();
            IPath path = project.getFullPath().append(jarName);
            entries[j] = JavaCore.newLibraryEntry((IPath)path, null, null, (boolean)true);
            ++j;
        }
        return entries;
    }

    protected int getNumberOfWorkUnits() {
        int numUnits = super.getNumberOfWorkUnits();
        return numUnits += this.fData.getLibraryPaths().length;
    }

    private void importJar(File jar, IResource destination, IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        ZipFile input = null;
        try {
            try {
                input = new ZipFile(jar);
                ZipFileStructureProvider provider = new ZipFileStructureProvider(input);
                ImportOperation op = new ImportOperation(destination.getFullPath(), (Object)provider.getRoot(), (IImportStructureProvider)provider, new IOverwriteQuery(){

                    public String queryOverwrite(String pathString) {
                        return "ALL";
                    }
                });
                op.run(monitor);
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.ui", 0, NLS.bind((String)PDEUIMessages.NewProjectCreationOperation_errorImportingJar, (Object)jar), (Throwable)e));
        }
    }

    private void removeExportRoot(IBundle bundle) {
        String value = bundle.getHeader("Bundle-ClassPath");
        if (value == null) {
            value = ".";
        }
        try {
            ManifestElement[] elems = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)value);
            StringBuffer buff = new StringBuffer(value.length());
            int i = 0;
            while (i < elems.length) {
                if (!elems[i].getValue().equals(".")) {
                    buff.append(elems[i].getValue());
                }
                ++i;
            }
            bundle.setHeader("Bundle-ClassPath", buff.toString());
        }
        catch (BundleException bundleException) {}
    }

    protected void setPluginLibraries(WorkspacePluginModelBase model) throws CoreException {
        IPluginBase pluginBase = model.getPluginBase();
        if (this.fData.isUnzipLibraries()) {
            IPluginLibrary library = model.getPluginFactory().createLibrary();
            library.setName(".");
            library.setExported(true);
            pluginBase.add(library);
        } else {
            String[] paths = this.fData.getLibraryPaths();
            int i = 0;
            while (i < paths.length) {
                File jarFile = new File(paths[i]);
                IPluginLibrary library = model.getPluginFactory().createLibrary();
                library.setName(jarFile.getName());
                library.setExported(true);
                pluginBase.add(library);
                ++i;
            }
        }
    }

    protected void createSourceOutputBuildEntries(WorkspaceBuildModel model, IBuildModelFactory factory) throws CoreException {
        if (this.fData.isUnzipLibraries()) {
            IBuildEntry entry = factory.createEntry("source..");
            entry.addToken(".");
            model.getBuild().add(entry);
            entry = factory.createEntry("output..");
            entry.addToken(".");
            model.getBuild().add(entry);
        }
    }

    private void addExportedPackages(IProject project, IBundle bundle) {
        String value = bundle.getHeader("Bundle-ClassPath");
        if (value == null) {
            value = ".";
        }
        try {
            ManifestElement[] elems = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)value);
            HashMap map = new HashMap();
            int i = 0;
            while (i < elems.length) {
                ArrayList<String> filter = new ArrayList<String>();
                filter.add("*");
                map.put(elems[i].getValue(), filter);
                ++i;
            }
            Set packages = PluginConverter.getDefault().getExports(project, map);
            String pkgValue = this.getCommaValueFromSet(packages);
            bundle.setHeader("Export-Package", pkgValue);
        }
        catch (BundleException bundleException) {}
    }

    private void addDependencies(IProject project, ISharedPluginModel model, IProgressMonitor monitor) {
        if (!(model instanceof IBundlePluginModelBase)) {
            monitor.done();
            return;
        }
        final boolean unzip = this.fData.isUnzipLibraries();
        try {
            new AddNewBinaryDependenciesOperation(project, (IBundlePluginModelBase)model){

                protected String[] findSecondaryBundles(IBundle bundle, Set ignorePkgs) {
                    IPluginModelBase[] bases = PluginRegistry.getActiveModels();
                    String[] ids = new String[bases.length];
                    int i = 0;
                    while (i < bases.length) {
                        BundleDescription desc = bases[i].getBundleDescription();
                        ids[i] = desc == null ? bases[i].getPluginBase().getId() : desc.getSymbolicName();
                        ++i;
                    }
                    return ids;
                }

                protected void addProjectPackages(IBundle bundle, Set ignorePkgs) {
                    if (!unzip) {
                        super.addProjectPackages(bundle, ignorePkgs);
                    }
                    Stack<Object> stack = new Stack<Object>();
                    stack.push(this.fProject);
                    try {
                        while (!stack.isEmpty()) {
                            IContainer folder = (IContainer)stack.pop();
                            IResource[] children = folder.members();
                            int i = 0;
                            while (i < children.length) {
                                if (children[i] instanceof IContainer) {
                                    stack.push(children[i]);
                                } else if ("class".equals(((IFile)children[i]).getFileExtension())) {
                                    String path = folder.getProjectRelativePath().toString();
                                    ignorePkgs.add(path.replace('/', '.'));
                                }
                                ++i;
                            }
                        }
                    }
                    catch (CoreException coreException) {}
                }
            }.run(monitor);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
    }
}

