/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.plugin;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.NewWizard;
import org.eclipse.pde.internal.ui.wizards.WizardElement;
import org.eclipse.pde.internal.ui.wizards.plugin.LibraryPluginFieldData;
import org.eclipse.pde.internal.ui.wizards.plugin.LibraryPluginJarsPage;
import org.eclipse.pde.internal.ui.wizards.plugin.NewLibraryPluginCreationOperation;
import org.eclipse.pde.internal.ui.wizards.plugin.NewLibraryPluginCreationPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class NewLibraryPluginProjectWizard
extends NewWizard
implements IExecutableExtension {
    public static final String DEF_PROJECT_NAME = "project_name";
    public static final String DEF_TEMPLATE_ID = "template-id";
    public static final String PLUGIN_POINT = "pluginContent";
    public static final String TAG_WIZARD = "wizard";
    private IConfigurationElement fConfig;
    private LibraryPluginJarsPage fJarsPage;
    private NewLibraryPluginCreationPage fMainPage;
    private LibraryPluginFieldData fPluginData;
    private IProjectProvider fProjectProvider;

    public NewLibraryPluginProjectWizard() {
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_JAR_TO_PLUGIN_WIZ);
        this.setDialogSettings(PDEPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(PDEUIMessages.NewLibraryPluginProjectWizard_title);
        this.setNeedsProgressMonitor(true);
        PDEPlugin.getDefault().getLabelProvider().connect(this);
        this.fPluginData = new LibraryPluginFieldData();
    }

    public void addPages() {
        this.fJarsPage = new LibraryPluginJarsPage("jars", this.fPluginData);
        this.addPage((IWizardPage)this.fJarsPage);
        this.fMainPage = new NewLibraryPluginCreationPage("main", this.fPluginData);
        String pname = this.getDefaultValue(DEF_PROJECT_NAME);
        if (pname != null) {
            this.fMainPage.setInitialProjectName(pname);
        }
        this.fProjectProvider = new IProjectProvider(){

            public IPath getLocationPath() {
                return NewLibraryPluginProjectWizard.this.fMainPage.getLocationPath();
            }

            public IProject getProject() {
                return NewLibraryPluginProjectWizard.this.fMainPage.getProjectHandle();
            }

            public String getProjectName() {
                return NewLibraryPluginProjectWizard.this.fMainPage.getProjectName();
            }
        };
        this.addPage((IWizardPage)this.fMainPage);
    }

    protected WizardElement createWizardElement(IConfigurationElement config) {
        String name = config.getAttribute("name");
        String id = config.getAttribute("id");
        String className = config.getAttribute("class");
        if (name == null || id == null || className == null) {
            return null;
        }
        WizardElement element = new WizardElement(config);
        String imageName = config.getAttribute("icon");
        if (imageName != null) {
            String pluginID = config.getNamespaceIdentifier();
            Image image = PDEPlugin.getDefault().getLabelProvider().getImageFromPlugin(pluginID, imageName);
            element.setImage(image);
        }
        return element;
    }

    public void dispose() {
        super.dispose();
        PDEPlugin.getDefault().getLabelProvider().disconnect(this);
    }

    public boolean performFinish() {
        try {
            this.fJarsPage.updateData();
            this.fMainPage.updateData();
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfig);
            this.getContainer().run(false, true, (IRunnableWithProgress)new NewLibraryPluginCreationOperation(this.fPluginData, this.fProjectProvider, null));
            return true;
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
        }
        catch (InterruptedException interruptedException) {}
        return false;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.fConfig = config;
    }
}

