/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.ui.IPreferenceConstants;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.tools.IOrganizeManifestsSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class OrganizeManifestsWizardPage
extends WizardPage
implements IPreferenceConstants,
IOrganizeManifestsSettings {
    private Button fRemoveUnresolved;
    private Button fCalculateUses;
    private Button fAddMissing;
    private Button fMarkInternal;
    private Text fPackageFilter;
    private Label fPackageFilterLabel;
    private Button fRemoveImport;
    private Button fOptionalImport;
    private Button fModifyDependencies;
    private Button fUnusedDependencies;
    private Button fAdditonalDependencies;
    private Button fFixIconNLSPaths;
    private Button fRemovedUnusedKeys;
    private Button fRemoveLazy;
    private Button[] fTopLevelButtons;
    private Button[] fParentButtons;
    private static String title = PDEUIMessages.OrganizeManifestsWizardPage_title;

    protected OrganizeManifestsWizardPage() {
        super(title);
        this.setTitle(title);
        this.setDescription(PDEUIMessages.OrganizeManifestsWizardPage_description);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1808));
        this.createExportedPackagesGroup(container);
        this.createRequireImportGroup(container);
        this.createGeneralGroup(container);
        this.createNLSGroup(container);
        this.setButtonArrays();
        this.presetOptions();
        this.hookListeners();
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.organize_manifest");
        Dialog.applyDialogFont((Control)container);
    }

    private void createExportedPackagesGroup(Composite container) {
        Group group = this.createGroup(container, PDEUIMessages.OrganizeManifestsWizardPage_exportedGroup, 1, true);
        this.fAddMissing = new Button((Composite)group, 32);
        this.fAddMissing.setText(PDEUIMessages.OrganizeManifestsWizardPage_addMissing);
        this.fMarkInternal = new Button((Composite)group, 32);
        this.fMarkInternal.setText(PDEUIMessages.OrganizeManifestsWizardPage_markInternal);
        Composite comp = new Composite((Composite)group, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        this.fPackageFilterLabel = new Label(comp, 0);
        this.fPackageFilterLabel.setText(PDEUIMessages.OrganizeManifestsWizardPage_packageFilter);
        GridData gd = new GridData();
        gd.horizontalIndent = 20;
        this.fPackageFilterLabel.setLayoutData((Object)gd);
        this.fPackageFilter = new Text(comp, 2048);
        this.fPackageFilter.setLayoutData((Object)new GridData(768));
        this.fRemoveUnresolved = new Button((Composite)group, 32);
        this.fRemoveUnresolved.setText(PDEUIMessages.OrganizeManifestsWizardPage_removeUnresolved);
        gd = new GridData();
        gd.verticalIndent = 5;
        this.fRemoveUnresolved.setLayoutData((Object)gd);
        this.fCalculateUses = new Button((Composite)group, 32);
        this.fCalculateUses.setText(PDEUIMessages.OrganizeManifestsWizardPage_calculateUses);
        gd = new GridData();
        gd.verticalIndent = 5;
        this.fCalculateUses.setLayoutData((Object)gd);
    }

    private void createRequireImportGroup(Composite container) {
        Group group = this.createGroup(container, PDEUIMessages.OrganizeManifestsWizardPage_dependenciesGroup, 1, true);
        Composite comp = new Composite((Composite)group, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        this.fModifyDependencies = new Button(comp, 32);
        this.fModifyDependencies.setText(PDEUIMessages.OrganizeManifestsWizardPage_unresolvedDependencies);
        this.fRemoveImport = new Button(comp, 16);
        this.fRemoveImport.setText(PDEUIMessages.OrganizeManifestsWizardPage_remove);
        this.fOptionalImport = new Button(comp, 16);
        this.fOptionalImport.setText(PDEUIMessages.OrganizeManifestsWizardPage_markOptional);
        this.fUnusedDependencies = new Button((Composite)group, 32);
        this.fUnusedDependencies.setText(PDEUIMessages.OrganizeManifestsWizardPage_removeUnused);
        this.fAdditonalDependencies = new Button((Composite)group, 32);
        this.fAdditonalDependencies.setText(PDEUIMessages.OrganizeManifestsWizardPage_addDependencies);
    }

    private void createGeneralGroup(Composite container) {
        Group group = this.createGroup(container, PDEUIMessages.OrganizeManifestsWizardPage_generalGroup, 1, true);
        this.fRemoveLazy = new Button((Composite)group, 32);
        this.fRemoveLazy.setText(PDEUIMessages.OrganizeManifestsWizardPage_lazyStart);
    }

    private void createNLSGroup(Composite container) {
        Group group = this.createGroup(container, PDEUIMessages.OrganizeManifestsWizardPage_internationalizationGroup, 1, true);
        this.fFixIconNLSPaths = new Button((Composite)group, 32);
        this.fFixIconNLSPaths.setText(PDEUIMessages.OrganizeManifestsWizardPage_prefixNL);
        this.fRemovedUnusedKeys = new Button((Composite)group, 32);
        this.fRemovedUnusedKeys.setText(PDEUIMessages.OrganizeManifestsWizardPage_removeUnusedKeys);
    }

    private Group createGroup(Composite parent, String text, int span, boolean colsEqual) {
        Group group = new Group(parent, 0);
        group.setText(text);
        GridLayout layout = new GridLayout(span, colsEqual);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        group.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        group.setLayoutData((Object)gd);
        return group;
    }

    private void presetOptions() {
        IDialogSettings settings = this.getDialogSettings();
        this.fAddMissing.setSelection(!settings.getBoolean("OrganizeManifests.ExportedPackages.addMissing"));
        this.fMarkInternal.setSelection(!settings.getBoolean("OrganizeManifests.ExportedPackages.makeInternal"));
        String filter = settings.get("OrganizeManifests.ExportedPackages.packageFilter");
        this.fPackageFilter.setText(filter != null ? filter : "*.internal*");
        this.fRemoveUnresolved.setSelection(!settings.getBoolean("OrganizeManifests.ExportedPackages.removeUnresolved"));
        this.fCalculateUses.setSelection(settings.getBoolean("OrganizeManifests.calculateUses"));
        this.fModifyDependencies.setSelection(!settings.getBoolean("OrganizeManifests.RequireImport.modifyDep"));
        this.fRemoveImport.setSelection(!settings.getBoolean("OrganizeManifests.RequireImport.resolve:markOptional"));
        this.fOptionalImport.setSelection(settings.getBoolean("OrganizeManifests.RequireImport.resolve:markOptional"));
        this.fUnusedDependencies.setSelection(settings.getBoolean("OrganizeManifests.RequireImport.findRemoveUnused"));
        this.fAdditonalDependencies.setSelection(settings.getBoolean("OrganizeManifests.AddDependencies"));
        this.fRemoveLazy.setSelection(!settings.getBoolean("OrganizeManifests.General.cleanup"));
        this.fFixIconNLSPaths.setSelection(settings.getBoolean("OrganizeManifests.Translation.nls"));
        this.fRemovedUnusedKeys.setSelection(settings.getBoolean("OrganizeManifests.Translation.unusedKeys"));
        this.setEnabledStates();
        this.setPageComplete();
    }

    protected void preformOk() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put("OrganizeManifests.ExportedPackages.addMissing", !this.fAddMissing.getSelection());
        settings.put("OrganizeManifests.ExportedPackages.makeInternal", !this.fMarkInternal.getSelection());
        settings.put("OrganizeManifests.ExportedPackages.packageFilter", this.fPackageFilter.getText());
        settings.put("OrganizeManifests.ExportedPackages.removeUnresolved", !this.fRemoveUnresolved.getSelection());
        settings.put("OrganizeManifests.calculateUses", this.fCalculateUses.getSelection());
        settings.put("OrganizeManifests.RequireImport.modifyDep", !this.fModifyDependencies.getSelection());
        settings.put("OrganizeManifests.RequireImport.resolve:markOptional", this.fOptionalImport.getSelection());
        settings.put("OrganizeManifests.RequireImport.findRemoveUnused", this.fUnusedDependencies.getSelection());
        settings.put("OrganizeManifests.AddDependencies", this.fAdditonalDependencies.getSelection());
        settings.put("OrganizeManifests.General.cleanup", !this.fRemoveLazy.getSelection());
        settings.put("OrganizeManifests.Translation.nls", this.fFixIconNLSPaths.getSelection());
        settings.put("OrganizeManifests.Translation.unusedKeys", this.fRemovedUnusedKeys.getSelection());
    }

    private void setEnabledStates() {
        boolean markInternal = this.fMarkInternal.getSelection();
        this.fPackageFilter.setEnabled(markInternal);
        this.fPackageFilter.setEditable(markInternal);
        this.fPackageFilterLabel.setEnabled(markInternal);
        boolean modifyDependencies = this.fModifyDependencies.getSelection();
        this.fRemoveImport.setEnabled(modifyDependencies);
        this.fOptionalImport.setEnabled(modifyDependencies);
    }

    private void setButtonArrays() {
        this.fTopLevelButtons = new Button[]{this.fRemoveUnresolved, this.fAddMissing, this.fModifyDependencies, this.fMarkInternal, this.fUnusedDependencies, this.fAdditonalDependencies, this.fFixIconNLSPaths, this.fRemovedUnusedKeys, this.fRemoveLazy, this.fCalculateUses};
        this.fParentButtons = new Button[]{this.fMarkInternal, this.fModifyDependencies};
    }

    private void setPageComplete() {
        boolean pageComplete = false;
        int i = 0;
        while (i < this.fTopLevelButtons.length) {
            if (this.fTopLevelButtons[i].getSelection()) {
                pageComplete = true;
                break;
            }
            ++i;
        }
        this.setPageComplete(pageComplete);
    }

    private void hookListeners() {
        this.hookListener(this.fParentButtons, new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OrganizeManifestsWizardPage.this.setEnabledStates();
            }
        });
        this.hookListener(this.fTopLevelButtons, new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OrganizeManifestsWizardPage.this.setPageComplete();
            }
        });
    }

    private void hookListener(Button[] buttons, SelectionAdapter adapter) {
        int i = 0;
        while (i < buttons.length) {
            buttons[i].addSelectionListener((SelectionListener)adapter);
            ++i;
        }
    }

    protected IDialogSettings getSettings() {
        return this.getDialogSettings();
    }
}

