/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ui.templates;

import org.eclipse.pde.ui.templates.AbstractChoiceOption;
import org.eclipse.pde.ui.templates.BaseOptionTemplateSection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class ComboChoiceOption
extends AbstractChoiceOption {
    private Combo fCombo;
    private Label fLabel;

    public ComboChoiceOption(BaseOptionTemplateSection section, String name, String label, String[][] choices) {
        super(section, name, label, choices);
    }

    public void createControl(Composite parent, int span) {
        this.fLabel = this.createLabel(parent, 1);
        this.fLabel.setEnabled(this.isEnabled());
        this.fill((Control)this.fLabel, 1);
        this.fCombo = new Combo(parent, 8);
        this.fill((Control)this.fCombo, 1);
        int i = 0;
        while (i < this.fChoices.length) {
            String[] choice = this.fChoices[i];
            this.fCombo.add(choice[1], i);
            this.fCombo.setEnabled(this.isEnabled());
            ++i;
        }
        this.fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ComboChoiceOption.this.isBlocked()) {
                    return;
                }
                if (ComboChoiceOption.this.fCombo.getSelectionIndex() != -1) {
                    String[] choice = ComboChoiceOption.this.fChoices[ComboChoiceOption.this.fCombo.getSelectionIndex()];
                    ComboChoiceOption.this.setValue(choice[0]);
                    ComboChoiceOption.this.getSection().validateOptions(ComboChoiceOption.this);
                }
            }
        });
        if (this.getChoice() != null) {
            this.selectChoice(this.getChoice());
        }
    }

    protected void setOptionValue(Object value) {
        if (this.fCombo != null && value != null) {
            this.selectChoice(value.toString());
        }
    }

    protected void setOptionEnabled(boolean enabled) {
        if (this.fLabel != null) {
            this.fLabel.setEnabled(enabled);
            this.fCombo.setEnabled(enabled);
        }
    }

    protected void selectOptionChoice(String choice) {
        this.fCombo.setText(choice);
        if (this.fCombo.getSelectionIndex() == -1) {
            this.fCombo.select(0);
        }
    }
}

