/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.IBuildPropertiesConstants;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.eclipse.pde.internal.build.IXMLConstants;
import org.eclipse.pde.internal.build.Messages;
import org.eclipse.pde.internal.build.PDEUIStateWrapper;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.ant.AntScript;
import org.eclipse.pde.internal.build.site.BuildTimeSite;
import org.eclipse.pde.internal.build.site.BuildTimeSiteFactory;
import org.eclipse.pde.internal.build.site.PDEState;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.SiteManager;

public abstract class AbstractScriptGenerator
implements IXMLConstants,
IPDEBuildConstants,
IBuildPropertiesConstants {
    private static Properties immutableAntProperties = null;
    protected static boolean embeddedSource = false;
    protected static boolean forceUpdateJarFormat = false;
    private static List configInfos;
    protected static String workingDirectory;
    protected static boolean buildingOSGi;
    protected AntScript script;
    protected Properties platformProperties;
    private static PDEUIStateWrapper pdeUIState;
    protected String[] sitePaths;
    protected String[] pluginPath;
    protected BuildTimeSiteFactory siteFactory;
    protected boolean filterState = false;
    protected List featuresForFilterRoots = new ArrayList();
    protected List pluginsForFilterRoots = new ArrayList();
    protected boolean reportResolutionErrors;

    static {
        buildingOSGi = true;
        configInfos = new ArrayList(1);
        configInfos.add(Config.genericConfig());
    }

    public static List getConfigInfos() {
        return configInfos;
    }

    public abstract void generate() throws CoreException;

    protected static void setStaticAntProperties(Properties properties) {
        immutableAntProperties = properties == null ? new Properties() : properties;
        if (AbstractScriptGenerator.getImmutableAntProperty("packagerMode") == null) {
            immutableAntProperties.setProperty("packagerMode", "false");
        }
        if (!AbstractScriptGenerator.getPropertyAsBoolean("packagerMode") || AbstractScriptGenerator.getImmutableAntProperty("packagerAsNormalizer") == null) {
            immutableAntProperties.setProperty("packagerAsNormalizer", "true");
        }
    }

    public static String getImmutableAntProperty(String key) {
        return AbstractScriptGenerator.getImmutableAntProperty(key, null);
    }

    public static boolean getPropertyAsBoolean(String key) {
        String booleanValue = AbstractScriptGenerator.getImmutableAntProperty(key, null);
        return "true".equalsIgnoreCase(booleanValue);
    }

    public static String getImmutableAntProperty(String key, String defaultValue) {
        if (immutableAntProperties == null || !immutableAntProperties.containsKey(key)) {
            return defaultValue;
        }
        Object obj = immutableAntProperties.get(key);
        return obj instanceof String ? (String)obj : null;
    }

    public static void setConfigInfo(String spec) throws CoreException {
        configInfos.clear();
        String[] configs = Utils.getArrayFromStringWithBlank(spec, "&");
        configInfos = new ArrayList(configs.length);
        String[] os = new String[configs.length];
        String[] ws = new String[configs.length];
        String[] archs = new String[configs.length];
        int i = 0;
        while (i < configs.length) {
            String[] configElements = Utils.getArrayFromStringWithBlank(configs[i], ",");
            if (configElements.length != 3) {
                Status error = new Status(4, "org.eclipse.pde.build", 22, NLS.bind((String)Messages.error_configWrongFormat, (Object)configs[i]), null);
                throw new CoreException((IStatus)error);
            }
            Config aConfig = new Config(configs[i]);
            if (aConfig.equals(Config.genericConfig())) {
                configInfos.add(Config.genericConfig());
            } else {
                configInfos.add(aConfig);
            }
            os[i] = aConfig.getOs();
            ws[i] = aConfig.getWs();
            archs[i] = aConfig.getArch();
            ++i;
        }
        SiteManager.setOS((String)Utils.getStringFromArray(os, ","));
        SiteManager.setWS((String)Utils.getStringFromArray(ws, ","));
        SiteManager.setOSArch((String)Utils.getStringFromArray(archs, ","));
    }

    public void setWorkingDirectory(String location) {
        workingDirectory = location;
    }

    public String getLocation(BundleDescription model) {
        return model.getLocation();
    }

    public static Properties readProperties(String location, String fileName, int errorLevel) throws CoreException {
        Properties result = new Properties();
        File file = new File(location, fileName);
        try {
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
            try {
                result.load(input);
            }
            finally {
                ((InputStream)input).close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (errorLevel != 1 && errorLevel != 0) {
                String message = NLS.bind((String)Messages.exception_missingFile, (Object)file);
                BundleHelper.getDefault().getLog().log((IStatus)new Status(errorLevel, "org.eclipse.pde.build", 10, message, null));
            }
            result = MissingProperties.getInstance();
        }
        catch (IOException e) {
            String message = NLS.bind((String)Messages.exception_readingFile, (Object)file);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 10, message, (Throwable)e));
        }
        return result;
    }

    public void openScript(String scriptLocation, String scriptName) throws CoreException {
        if (this.script != null) {
            return;
        }
        try {
            BufferedOutputStream scriptStream = new BufferedOutputStream(new FileOutputStream(String.valueOf(scriptLocation) + '/' + scriptName));
            try {
                this.script = new AntScript(scriptStream);
            }
            catch (IOException e) {
                try {
                    ((OutputStream)scriptStream).close();
                    String message = NLS.bind((String)Messages.exception_writingFile, (Object)(String.valueOf(scriptLocation) + '/' + scriptName));
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
                }
                catch (IOException iOException) {}
            }
        }
        catch (FileNotFoundException e) {
            String message = NLS.bind((String)Messages.exception_writingFile, (Object)(String.valueOf(scriptLocation) + '/' + scriptName));
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
        }
    }

    public void closeScript() {
        this.script.close();
    }

    public void setBuildingOSGi(boolean b) {
        buildingOSGi = b;
    }

    public static boolean isBuildingOSGi() {
        return buildingOSGi;
    }

    public static String getWorkingDirectory() {
        return workingDirectory;
    }

    public static String getDefaultOutputFormat() {
        return "zip";
    }

    public static boolean getDefaultEmbeddedSource() {
        return false;
    }

    public static void setEmbeddedSource(boolean embed) {
        embeddedSource = embed;
    }

    public static boolean getForceUpdateJarFormat() {
        return false;
    }

    public static void setForceUpdateJar(boolean force) {
        forceUpdateJarFormat = force;
    }

    public static String getDefaultConfigInfos() {
        return "*, *, *";
    }

    public static boolean getDefaultBuildingOSGi() {
        return true;
    }

    public BuildTimeSite getSite(boolean refresh) throws CoreException {
        if (this.siteFactory != null && !refresh) {
            return (BuildTimeSite)this.siteFactory.createSite();
        }
        if (this.siteFactory == null || refresh) {
            this.siteFactory = new BuildTimeSiteFactory();
            this.siteFactory.setFilterState(this.filterState);
            this.siteFactory.setFilterRoots(this.featuresForFilterRoots, this.pluginsForFilterRoots);
            this.siteFactory.setReportResolutionErrors(this.reportResolutionErrors);
        }
        this.siteFactory.setSitePaths(this.getPaths());
        this.siteFactory.setInitialState(pdeUIState);
        BuildTimeSite result = (BuildTimeSite)this.siteFactory.createSite();
        if (this.platformProperties != null) {
            result.setPlatformPropeties(this.platformProperties);
        }
        return result;
    }

    private String[] getPaths() {
        if (this.sitePaths == null) {
            if (this.pluginPath != null) {
                this.sitePaths = new String[this.pluginPath.length + 1];
                System.arraycopy(this.pluginPath, 0, this.sitePaths, 0, this.pluginPath.length);
                this.sitePaths[this.sitePaths.length - 1] = workingDirectory;
            } else {
                this.sitePaths = new String[]{workingDirectory};
            }
        }
        return this.sitePaths;
    }

    public void setBuildSiteFactory(BuildTimeSiteFactory siteFactory) {
        this.siteFactory = siteFactory;
    }

    public String[] getPluginPath() {
        return this.pluginPath;
    }

    public void setPluginPath(String[] path) {
        this.pluginPath = path;
    }

    public void setPDEState(State state) {
        this.ensurePDEUIStateNotNull();
        pdeUIState.setState(state);
    }

    public void setStateExtraData(HashMap classpath, Map patchData) {
        this.ensurePDEUIStateNotNull();
        pdeUIState.setExtraData(classpath, patchData);
    }

    public void setNextId(long nextId) {
        this.ensurePDEUIStateNotNull();
        pdeUIState.setNextId(nextId);
    }

    protected void flushState() {
        pdeUIState = null;
    }

    private void ensurePDEUIStateNotNull() {
        if (pdeUIState == null) {
            pdeUIState = new PDEUIStateWrapper();
        }
    }

    protected boolean havePDEUIState() {
        return pdeUIState != null;
    }

    protected String findFile(String location, boolean makeRelative) {
        String result;
        BundleDescription bundle;
        PDEState state;
        if (location == null || location.length() == 0) {
            return null;
        }
        try {
            state = this.getSite(false).getRegistry();
        }
        catch (CoreException coreException) {
            return null;
        }
        Path path = new Path(location);
        String id = path.segment(0);
        BundleDescription[] matches = state.getState().getBundles(id);
        if (matches != null && matches.length != 0 && (bundle = matches[0]) != null && (result = this.checkFile((IPath)new Path(bundle.getLocation()), path, makeRelative)) != null) {
            return result;
        }
        IFeature feature = null;
        try {
            feature = this.getSite(false).findFeature(id, null, false);
        }
        catch (CoreException coreException) {}
        if (feature == null) {
            return null;
        }
        ISiteFeatureReference ref = feature.getSite().getFeatureReference(feature);
        IPath featureBase = new Path(ref.getURL().getFile()).removeLastSegments(1);
        return this.checkFile(featureBase, path, makeRelative);
    }

    private String checkFile(IPath base, Path target, boolean makeRelative) {
        IPath path = base.append(target.removeFirstSegments(1));
        String result = path.toOSString();
        if (!new File(result).exists()) {
            return null;
        }
        if (makeRelative) {
            return Utils.makeRelative(path, (IPath)new Path(workingDirectory)).toOSString();
        }
        return result;
    }

    public void setFilterState(boolean filter) {
        this.filterState = filter;
    }

    public void setPlatformProperties(String filename) {
        block16: {
            if (filename == null || filename.trim().length() == 0) {
                return;
            }
            File file = new File(filename);
            if (!file.exists()) {
                return;
            }
            this.platformProperties = new Properties();
            InputStream input = null;
            try {
                try {
                    input = new BufferedInputStream(new FileInputStream(file));
                    this.platformProperties.load(input);
                }
                catch (IOException e) {
                    this.platformProperties = null;
                    String message = NLS.bind((String)Messages.error_loading_platform_properties, (Object)filename);
                    Status status = new Status(2, "org.eclipse.pde.build", message, (Throwable)e);
                    BundleHelper.getDefault().getLog().log((IStatus)status);
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static class MissingProperties
    extends Properties {
        private static final long serialVersionUID = 3546924667060303927L;
        private static MissingProperties singleton;

        private MissingProperties() {
        }

        public synchronized Object setProperty(String key, String value) {
            throw new UnsupportedOperationException();
        }

        public synchronized Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        public static MissingProperties getInstance() {
            if (singleton == null) {
                singleton = new MissingProperties();
            }
            return singleton;
        }
    }
}

